/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.journal.repository;

import com.infinite.focus.server.journal.dto.JournalDTO;
import com.infinite.focus.server.journal.repository.JournalRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class JournalRepositoryImpl
implements JournalRepository {
    private final JdbcTemplate jdbcTemplate;

    public JournalRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static JournalDTO mapRow(ResultSet rs, int i) throws SQLException {
        return JournalDTO.builder().journal_id(rs.getLong("journal_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).mood_id(rs.getLong("mood_id")).mood_name(rs.getString("mood_name")).mood_name_es(rs.getString("mood_name_es")).sub_mood_id(rs.getLong("sub_mood_id")).sub_mood_name(rs.getString("sub_mood_name")).sub_mood_name_es(rs.getString("sub_mood_name_es")).journal_description(rs.getString("journal_description")).hasBadWords(false).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public JournalDTO create(long student_id, long standard_id, long mood_id, String mood_name, String mood_name_es, long sub_mood_id, String sub_mood_name, String sub_mood_name_es, String journal_description) {
        String INSERT_SQL = "INSERT INTO journal (student_id, standard_id, mood_id, mood_name, mood_name_es, sub_mood_id, sub_mood_name, sub_mood_name_es, journal_description, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO journal (student_id, standard_id, mood_id, mood_name, mood_name_es, sub_mood_id, sub_mood_name, sub_mood_name_es, journal_description, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setLong(1, student_id);
            ps.setLong(2, standard_id);
            ps.setLong(3, mood_id);
            ps.setString(4, mood_name);
            ps.setString(5, mood_name_es);
            ps.setLong(6, sub_mood_id);
            ps.setString(7, sub_mood_name);
            ps.setString(8, sub_mood_name_es);
            ps.setString(9, journal_description);
            ps.setTimestamp(10, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(11, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int journal_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)journal_id);
    }

    public JournalDTO update(long id, long student_id, long standard_id, long mood_id, String mood_name, String mood_name_es, long sub_mood_id, String sub_mood_name, String sub_mood_name_es, String journal_description) {
        String SQL = "UPDATE journal SET student_id = ?, standard_id = ?, mood_id = ?, mood_name = ?, mood_name_es = ?, sub_mood_id = ?, sub_mood_name = ?, sub_mood_name_es = ?, journal_description = ?, updated_at = ? WHERE journal_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE journal SET student_id = ?, standard_id = ?, mood_id = ?, mood_name = ?, mood_name_es = ?, sub_mood_id = ?, sub_mood_name = ?, sub_mood_name_es = ?, journal_description = ?, updated_at = ? WHERE journal_id = ? ", new Object[]{student_id, standard_id, mood_id, mood_name, mood_name_es, sub_mood_id, sub_mood_name, sub_mood_name_es, journal_description, Timestamp.valueOf(LocalDateTime.now()), id});
        if (updateCount == 1) {
            return this.findById(id);
        }
        throw new ResponseStatusException(HttpStatus.CONFLICT, "Not updated!!!");
    }

    public JournalDTO findById(long id) {
        String SQL = "SELECT * FROM journal WHERE journal_id = ? ";
        try {
            return (JournalDTO)this.jdbcTemplate.queryForObject(SQL, JournalRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteByStudentIds(Set<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "DELETE FROM journal WHERE student_id IN(%S)";
        try {
            this.jdbcTemplate.update(String.format(SQL, inSql), student_ids.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getLastRecordId() {
        String SQL = "SELECT journal_id FROM journal ORDER BY journal_id DESC LIMIT 0,1 ";
        try {
            Long journal_id = (Long)this.jdbcTemplate.queryForObject(SQL, (rs, i) -> rs.getLong("journal_id"));
            return journal_id == null ? 0L : journal_id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM journal WHERE journal_id = ? ";
        this.jdbcTemplate.update("DELETE FROM journal WHERE journal_id = ? ", new Object[]{id});
    }

    public Page<JournalDTO> findPageByStudentIds(Set<Long> student_ids, Date fromDate, Date toDate, Pageable pageable) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        StringBuilder rowCountSql = new StringBuilder("SELECT count(1) AS row_count FROM journal WHERE student_id IN(%S) ");
        if (fromDate != null && toDate != null) {
            rowCountSql.append("AND created_at BETWEEN ? AND ? ");
            args.add((Long)((Object)new Timestamp(fromDate.getTime())));
            args.add((Long)((Object)new Timestamp(toDate.getTime())));
        }
        Integer total = (Integer)this.jdbcTemplate.queryForObject(String.format(rowCountSql.toString(), inSql), args.toArray(), (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM journal WHERE student_id IN(%S) ");
        if (fromDate != null && toDate != null) {
            querySql.append("AND created_at BETWEEN ? AND ? ");
        }
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            String property = order.getProperty();
            if (order.getProperty().equals("createdAt")) {
                property = "created_at";
            }
            querySql.append("ORDER BY ").append(property).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(String.format(querySql.toString(), inSql), args.toArray(), JournalRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }
}

