/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentgroup.controller;

import com.infinite.focus.server.studentgroup.request.AddGroupByStudentIdRequest;
import com.infinite.focus.server.studentgroup.request.GetStudentsByGroupIdsRequest;
import com.infinite.focus.server.studentgroup.request.RemoveAllGroupsByStudentIdsRequest;
import com.infinite.focus.server.studentgroup.service.StudentGroupService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-group"})
public class StudentGroupController {
    @Autowired
    private StudentGroupService studentGroupService;

    @PostMapping(value={"/get-student-ids-by-group-ids"})
    public ResponseEntity<List<Long>> getStudentIdsByGroupIds(@RequestBody GetStudentsByGroupIdsRequest request) {
        return new ResponseEntity((Object)this.studentGroupService.getStudentIdsByGroupIds(request.getGroup_ids()), HttpStatus.OK);
    }

    @PostMapping(value={"/remove-all-groups-by-student-ids"})
    public ResponseEntity<Void> removeAllGroupsByStudentIds(@RequestBody RemoveAllGroupsByStudentIdsRequest request) {
        this.studentGroupService.removeAllGroupsByStudentIds(request.getStudent_ids());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/add-group-by-student-id"})
    public ResponseEntity<List<Long>> addGroupByStudentId(@RequestBody AddGroupByStudentIdRequest request) {
        return new ResponseEntity((Object)this.studentGroupService.addGroupByStudentId(request.getStudent_id(), request.getGroup_id()), HttpStatus.OK);
    }
}

