/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.freetrial.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.CorporateAuthService;
import com.infinite.focus.server.auth.service.DistrictAuthService;
import com.infinite.focus.server.auth.service.InstructorAuthService;
import com.infinite.focus.server.auth.service.ParentAuthService;
import com.infinite.focus.server.auth.service.SchoolAuthService;
import com.infinite.focus.server.auth.service.StudentAuthService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.repository.FreeTrialRepository;
import com.infinite.focus.server.freetrial.request.FreeTrialRequest;
import com.infinite.focus.server.freetrial.request.GetFreeTrialsRequest;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.freetrial.wrapper.FreeTrialWrapper;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.model.OrganizationDetail;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.mail.MessagingException;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class FreeTrialServiceImpl
implements FreeTrialService {
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    DistrictAuthService districtAuthService;
    @Autowired
    CorporateAuthService corporateAuthService;
    @Autowired
    ParentAuthService parentAuthService;
    @Autowired
    DistrictService districtService;
    @Autowired
    SchoolAuthService schoolAuthService;
    @Autowired
    SchoolService schoolService;
    @Autowired
    InstructorAuthService instructorAuthService;
    @Autowired
    InstructorService instructorService;
    @Autowired
    StudentAuthService studentAuthService;
    @Autowired
    StudentService studentService;
    @Autowired
    FreeTrialRepository freeTrialRepository;
    @Autowired
    EntityManager entityManager;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    EmailSenderService emailSenderService;
    @Autowired
    TemplateService templateService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    CorporateService corporateService;
    @Autowired
    MessageService messageService;

    public LinkedHashMap<String, Object> createFreeTrial(FreeTrialRequest request) {
        if (AppUtils.isNullOrEmpty((String)request.getName_of_organization())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.name.of.organization.is.not.found"));
        }
        if (request.getTrial_start_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.start.date.is.not.found"));
        }
        if (request.getTrial_end_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.end.date.is.not.found"));
        }
        if (request.getCheckpoint_1() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.checkpoint.one.is.not.found"));
        }
        if (request.getCheckpoint_2() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.checkpoint.two.is.not.found"));
        }
        if (request.getDescision_point_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.decision.point.date.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getTrial_evaluation_priorities())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.evaluation.priorities.is.not.found"));
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            return this.createFreeTrialForLargeOrganization(request);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            return this.createFreeTrialForOrganization(request);
        }
        return null;
    }

    private LinkedHashMap<String, Object> createFreeTrialForOrganization(FreeTrialRequest request) {
        if (request.getOrganization() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getOrganization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.email.is.not.found"));
        }
        if (!AppUtils.isValidateEmail((String)request.getOrganization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.organization.s.email.is.not.valid"));
        }
        if (this.isEmailAlreadyExist(request.getOrganization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.organization.s.email.is.already.exist"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getOrganization().getAddress())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.address.is.not.found"));
        }
        request.getOrganization().setPassword(AppUtils.generatePassword());
        if (AppUtils.isNullOrEmpty((String)request.getOrganization().getRole_in_organization())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.role.in.organization.is.not.found"));
        }
        boolean hasInstructorDetails = this.hasInstructorDetails(true, request);
        boolean hasStudentDetails = this.hasStudentDetails(request);
        if (hasInstructorDetails && request.getOrganization().getEmail().equals(request.getInstructor().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.organization.and.instructor.emails.must.not.match.with.each.other"));
        }
        FreeTrial freeTrial = new FreeTrial();
        freeTrial.setName_of_organization(request.getName_of_organization());
        freeTrial.setOrganization_type(request.getOrganization_type());
        freeTrial.setFocus_on(request.getFocus_on());
        freeTrial.setTrial_start_date(request.getTrial_start_date());
        freeTrial.setTrial_end_date(request.getTrial_end_date());
        freeTrial.setCheck_point_1(request.getCheckpoint_1());
        freeTrial.setCheck_point_2(request.getCheckpoint_2());
        freeTrial.setDescisions_points_date(request.getDescision_point_date());
        freeTrial.setTrial_evaluation_priorities(request.getTrial_evaluation_priorities());
        request.getOrganization().setName(request.getName_of_organization());
        School school = this.schoolAuthService.createSchoolTrialAccount(0L, request.getOrganization(), request.getFocus_on());
        freeTrial.setOrganization_id(school.getSchool_id());
        if (hasInstructorDetails) {
            Instructor instructor = this.instructorAuthService.createInstructorTrialAccount(school.getSchool_id(), request.getInstructor());
            request.getInstructor().setRegistration_code(instructor.getRegistration_code());
            if (hasStudentDetails) {
                this.studentAuthService.createStudentTrialAccount(instructor.getInstructor_id(), 0L, request.getStudent());
            }
        } else if (hasStudentDetails) {
            this.studentAuthService.createStudentTrialAccount(0L, 0L, request.getStudent());
        }
        this.freeTrialRepository.save((Object)freeTrial);
        LinkedHashMap<String, Object> freeTrialWapper = new LinkedHashMap<String, Object>();
        freeTrialWapper.put("free_trial", freeTrial);
        freeTrialWapper.put("organization", request.getOrganization());
        this.sendFreeTrailEmailOrganization(request.getOrganization().getEmail(), request.getOrganization().getPassword(), request.getOrganization().getName());
        if (hasInstructorDetails) {
            freeTrialWapper.put("instructor", request.getInstructor());
            this.sendFreeTrailEmailInstructor(request.getInstructor().getEmail(), request.getInstructor().getPassword());
        }
        if (hasStudentDetails) {
            if (!hasInstructorDetails) {
                request.getStudent().setClass_name(null);
            }
            freeTrialWapper.put("student", request.getStudent());
        }
        return freeTrialWapper;
    }

    private boolean hasStudentDetails(FreeTrialRequest request) {
        if (!(request.getStudent() == null || AppUtils.isNullOrEmpty((String)request.getStudent().getFirst_name()) && AppUtils.isNullOrEmpty((String)request.getStudent().getLast_name()) && AppUtils.isNullOrEmpty((String)request.getStudent().getRole_in_organization()))) {
            if (AppUtils.isNullOrEmpty((String)request.getStudent().getFirst_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.s.first.name.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getStudent().getLast_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.s.last.name.is.not.found"));
            }
            request.getStudent().setPassword(this.getPasswordByNameAndDate(request.getStudent().getFirst_name() + request.getStudent().getLast_name(), new Date()));
            if (AppUtils.isNullOrEmpty((String)request.getStudent().getRole_in_organization())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.s.role.in.organization.is.not.found"));
            }
            return true;
        }
        return false;
    }

    private boolean hasInstructorDetails(boolean hasSchoolDetails, FreeTrialRequest request) {
        if (!(request.getInstructor() == null || AppUtils.isNullOrEmpty((String)request.getInstructor().getEmail()) && AppUtils.isNullOrEmpty((String)request.getInstructor().getFirst_name()) && AppUtils.isNullOrEmpty((String)request.getInstructor().getLast_name()) && AppUtils.isNullOrEmpty((String)request.getInstructor().getRole_in_organization()))) {
            if (!hasSchoolDetails) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getInstructor().getEmail())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.s.email.is.not.found"));
            }
            if (!AppUtils.isValidateEmail((String)request.getInstructor().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.s.email.is.not.valid"));
            }
            if (this.isEmailAlreadyExist(request.getInstructor().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.s.email.is.already.exist"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getInstructor().getFirst_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.s.first.name.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getInstructor().getLast_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.s.last.name.is.not.found"));
            }
            request.getInstructor().setPassword(AppUtils.generatePassword());
            if (AppUtils.isNullOrEmpty((String)request.getInstructor().getRole_in_organization())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.s.role.in.organization.is.not.found"));
            }
            return true;
        }
        return false;
    }

    private LinkedHashMap<String, Object> createFreeTrialForLargeOrganization(FreeTrialRequest request) {
        if (request.getLarge_organization() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLarge_organization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.s.email.is.not.found"));
        }
        if (!AppUtils.isValidateEmail((String)request.getLarge_organization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.large.organization.s.email.is.not.valid"));
        }
        if (this.isEmailAlreadyExist(request.getLarge_organization().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.large.organization.s.email.is.already.exist"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLarge_organization().getState())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.s.state.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLarge_organization().getCity())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.s.city.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLarge_organization().getRole_in_organization())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.s.role.in.organization.is.not.found"));
        }
        request.getLarge_organization().setPassword(AppUtils.generatePassword());
        boolean hasOrganizationDetails = this.hasOrganizationDetails(request);
        boolean hasInstructorDetails = this.hasInstructorDetails(hasOrganizationDetails, request);
        boolean hasStudentDetails = this.hasStudentDetails(request);
        HashSet<String> emails = new HashSet<String>();
        emails.add(request.getLarge_organization().getEmail());
        if (hasInstructorDetails) {
            emails.add(request.getOrganization().getEmail());
            emails.add(request.getInstructor().getEmail());
            if (emails.size() != 3) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.large.organization.organization.and.instructor.emails.must.not.match.with.each.other"));
            }
        } else if (hasOrganizationDetails) {
            emails.add(request.getOrganization().getEmail());
            if (emails.size() != 2) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.large.organization.and.organization.emails.must.not.match.with.each.other"));
            }
        }
        FreeTrial freeTrial = new FreeTrial();
        freeTrial.setName_of_organization(request.getName_of_organization());
        freeTrial.setOrganization_type(request.getOrganization_type());
        freeTrial.setFocus_on(request.getFocus_on());
        freeTrial.setTrial_start_date(request.getTrial_start_date());
        freeTrial.setTrial_end_date(request.getTrial_end_date());
        freeTrial.setCheck_point_1(request.getCheckpoint_1());
        freeTrial.setCheck_point_2(request.getCheckpoint_2());
        freeTrial.setDescisions_points_date(request.getDescision_point_date());
        freeTrial.setTrial_evaluation_priorities(request.getTrial_evaluation_priorities());
        request.getLarge_organization().setName(request.getName_of_organization());
        District district = this.districtAuthService.createDistrictTrialAccount(request.getLarge_organization(), request.getFocus_on());
        freeTrial.setOrganization_id(district.getDistrict_id());
        if (hasInstructorDetails) {
            School school = this.schoolAuthService.createSchoolTrialAccount(district.getDistrict_id(), request.getOrganization(), null);
            Instructor instructor = this.instructorAuthService.createInstructorTrialAccount(school.getSchool_id(), request.getInstructor());
            request.getInstructor().setRegistration_code(instructor.getRegistration_code());
            if (hasStudentDetails) {
                this.studentAuthService.createStudentTrialAccount(instructor.getInstructor_id(), 0L, request.getStudent());
            }
        } else if (hasOrganizationDetails) {
            this.schoolAuthService.createSchoolTrialAccount(district.getDistrict_id(), request.getOrganization(), null);
            if (hasStudentDetails) {
                this.studentAuthService.createStudentTrialAccount(0L, 0L, request.getStudent());
            }
        } else if (hasStudentDetails) {
            this.studentAuthService.createStudentTrialAccount(0L, 0L, request.getStudent());
        }
        this.freeTrialRepository.save((Object)freeTrial);
        LinkedHashMap<String, Object> freeTrialWapper = new LinkedHashMap<String, Object>();
        freeTrialWapper.put("free_trial", freeTrial);
        freeTrialWapper.put("large_organization", request.getLarge_organization());
        this.sendFreeTrailEmailOrganization(request.getLarge_organization().getEmail(), request.getLarge_organization().getPassword(), request.getLarge_organization().getName());
        if (hasInstructorDetails) {
            freeTrialWapper.put("organization", request.getOrganization());
            this.sendFreeTrailEmailOrganization(request.getOrganization().getEmail(), request.getOrganization().getPassword(), request.getOrganization().getName());
            freeTrialWapper.put("instructor", request.getInstructor());
            this.sendFreeTrailEmailInstructor(request.getInstructor().getEmail(), request.getInstructor().getPassword());
        } else if (hasOrganizationDetails) {
            freeTrialWapper.put("organization", request.getOrganization());
            this.sendFreeTrailEmailOrganization(request.getOrganization().getEmail(), request.getOrganization().getPassword(), request.getOrganization().getName());
        }
        if (hasStudentDetails) {
            if (!hasInstructorDetails) {
                request.getStudent().setClass_name(null);
            }
            freeTrialWapper.put("student", request.getStudent());
        }
        return freeTrialWapper;
    }

    private boolean hasOrganizationDetails(FreeTrialRequest request) {
        if (!(request.getOrganization() == null || AppUtils.isNullOrEmpty((String)request.getOrganization().getEmail()) && AppUtils.isNullOrEmpty((String)request.getOrganization().getName()) && AppUtils.isNullOrEmpty((String)request.getOrganization().getAddress()) && AppUtils.isNullOrEmpty((String)request.getOrganization().getRole_in_organization()))) {
            if (AppUtils.isNullOrEmpty((String)request.getOrganization().getEmail())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.email.is.not.found"));
            }
            if (!AppUtils.isValidateEmail((String)request.getOrganization().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.organization.s.email.is.not.valid"));
            }
            if (this.isEmailAlreadyExist(request.getOrganization().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.organization.s.email.is.already.exist"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getOrganization().getName())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.name.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getOrganization().getAddress())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.address.is.not.found"));
            }
            request.getOrganization().setPassword(AppUtils.generatePassword());
            if (AppUtils.isNullOrEmpty((String)request.getOrganization().getRole_in_organization())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.s.role.in.organization.is.not.found"));
            }
            return true;
        }
        return false;
    }

    public void sendFreeTrailEmailOrganization(String email, String password, String nameOfOrganization) {
        try {
            this.emailSenderService.sendHtmlMail(email, (Language.isSpanish() ? "Bienvenido a su juicio Clymb, " : "Welcome to Your Clymb Trial, ") + nameOfOrganization + "!", this.templateService.getFreeTrialOrganizationEmail(password, this.configurationService.getConfiguration().getFree_trial_organization_email_get_started(), this.configurationService.getConfiguration().getFree_trial_organization_email_support_center()));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public void sendFreeTrailEmailInstructor(String email, String password) {
        try {
            this.emailSenderService.sendHtmlMail(email, Language.isSpanish() ? "Bienvenido al juicio de Clymb" : "Welcome to Your Clymb Trial!", this.templateService.getFreeTrialOrganizationEmail(password, this.configurationService.getConfiguration().getFree_trial_instructor_email_get_started(), this.configurationService.getConfiguration().getFree_trial_instructor_email_support_center()));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private String getPasswordByNameAndDate(String name, Date date) {
        String password = null;
        String nameWithoutSpaces = name.replaceAll("\\s+", "");
        String timestamp = date.getTime() + "";
        String password1 = null;
        String password2 = null;
        if (nameWithoutSpaces.length() > 3) {
            password1 = nameWithoutSpaces.substring(0, 4);
            password2 = timestamp.substring(timestamp.length() - 4);
        } else if (nameWithoutSpaces.length() > 2) {
            password1 = nameWithoutSpaces.substring(0, 3);
            password2 = timestamp.substring(timestamp.length() - 5);
        } else if (nameWithoutSpaces.length() > 1) {
            password1 = nameWithoutSpaces.substring(0, 2);
            password2 = timestamp.substring(timestamp.length() - 6);
        } else if (nameWithoutSpaces.length() >= 1) {
            password1 = nameWithoutSpaces.substring(0, 1);
            password2 = timestamp.substring(timestamp.length() - 7);
        }
        password = password1.toUpperCase() + password2;
        return password;
    }

    private boolean isEmailAlreadyExist(String email) {
        Account a = this.accountRepository.findByUsername(email);
        return a != null;
    }

    public boolean checkTrialActiveByDistrictId(long district_id) {
        FreeTrial freeTrial;
        boolean datePassed;
        District district = this.districtService.getDistrictById(district_id);
        return district != null && !(datePassed = DateUtils.checkDateTimeIsPassed((Date)(freeTrial = this.freeTrialRepository.findByOrganizationTypeAndOrganizationId(OrganizationType.LARGE_ORGANIZATION.toString(), district.getDistrict_id())).getTrial_end_date()));
    }

    public boolean checkTrialActiveBySchoolId(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district != null) {
            return this.checkTrialActiveByDistrictId(school.getDistrict_id());
        }
        FreeTrial freeTrial = this.freeTrialRepository.findByOrganizationTypeAndOrganizationId(OrganizationType.ORGANIZATION.toString(), school.getSchool_id());
        boolean datePassed = DateUtils.checkDateTimeIsPassed((Date)freeTrial.getTrial_end_date());
        return !datePassed;
    }

    public boolean checkTrialActiveByInstructorId(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.is.not.found"));
        }
        return this.checkTrialActiveBySchoolId(instructor.getSchool_id());
    }

    public boolean checkTrialActiveByStudentId(long student_id) {
        Student student = this.studentService.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return this.checkTrialActiveByInstructorId(student.getInstructor_id());
    }

    public Page<FreeTrialWrapper> getFreeTrials(GetFreeTrialsRequest request) {
        ArrayList<OrganizationType> organizationTypes = new ArrayList<OrganizationType>();
        for (String organization_type : Arrays.asList(request.getOrganization_types().split("\\s*,\\s*"))) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION);
            }
            if (organization_type.equals(OrganizationType.ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.ORGANIZATION);
            }
            if (!organization_type.equals(OrganizationType.CORPORATE.toString())) continue;
            organizationTypes.add(OrganizationType.CORPORATE);
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(FreeTrial.class);
        Root freeTrialRoot = query.from(FreeTrial.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicates.add(qb.like(qb.lower((Expression)freeTrialRoot.get("name_of_organization")), "%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            CriteriaBuilder.In organizationTypePredicate = qb.in((Expression)freeTrialRoot.get("organization_type")).value(organizationTypes);
            predicates.add(organizationTypePredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getFreeTrials FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)freeTrialRoot.get("createdAt"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        Predicate isDeletedPredicate = qb.equal((Expression)freeTrialRoot.get("deleted"), (Object)false);
        predicates.add(isDeletedPredicate);
        query.where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)freeTrialRoot.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)freeTrialRoot.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(FreeTrial.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        ArrayList<FreeTrialWrapper> resultSet = new ArrayList<FreeTrialWrapper>();
        for (FreeTrial freeTrial : result) {
            FreeTrialWrapper wrapper = new FreeTrialWrapper();
            wrapper.setFree_trial_id(freeTrial.getFree_trial_id());
            wrapper.setName_of_organization(freeTrial.getName_of_organization());
            wrapper.setOrganization_type(freeTrial.getOrganization_type());
            wrapper.setFocus_on(freeTrial.getFocus_on());
            wrapper.setOrganization_id(freeTrial.getOrganization_id());
            wrapper.setTrial_start_date(freeTrial.getTrial_start_date());
            wrapper.setTrial_end_date(freeTrial.getTrial_end_date());
            wrapper.setCheck_point_1(freeTrial.getCheck_point_1());
            wrapper.setCheck_point_2(freeTrial.getCheck_point_2());
            wrapper.setDescisions_points_date(freeTrial.getDescisions_points_date());
            wrapper.setTrial_evaluation_priorities(freeTrial.getTrial_evaluation_priorities());
            wrapper.setStatus(freeTrial.getStatus());
            wrapper.setDeleted(freeTrial.isDeleted());
            wrapper.setCreatedAt(freeTrial.getCreatedAt());
            wrapper.setUpdatedAt(freeTrial.getUpdatedAt());
            OrganizationDetail organization = this.organizationService.findByOrganizationTypeAndOrganizationId(freeTrial.getOrganization_type().toString(), freeTrial.getOrganization_id());
            wrapper.setAddress(organization.getAddress());
            wrapper.setCity(organization.getCity());
            wrapper.setState(organization.getState());
            wrapper.setEmail(organization.getEmail());
            wrapper.setNumber_of_youth(organization.getNumber_of_youth());
            resultSet.add(wrapper);
        }
        PageImpl pagedResult = new PageImpl(resultSet, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public FreeTrial getFreeTrial(Long free_trial_id) {
        return this.freeTrialRepository.findByFreeTrialId(free_trial_id);
    }

    public FreeTrial findByOrganizationTypeAndOrganizationId(String organizationType, long organization_id) {
        return this.freeTrialRepository.findByOrganizationTypeAndOrganizationId(organizationType, organization_id);
    }

    public void deleteById(Long free_trial_id) {
        this.freeTrialRepository.deleteById((Object)free_trial_id);
    }

    public FreeTrial getFreeTrialByDistrictId(long district_id) {
        return this.findByOrganizationTypeAndOrganizationId(OrganizationType.LARGE_ORGANIZATION.toString(), district_id);
    }

    public FreeTrial getFreeTrialBySchoolId(long school_id) {
        return this.findByOrganizationTypeAndOrganizationId(OrganizationType.ORGANIZATION.toString(), school_id);
    }

    public FreeTrial getFreeTrialByCorporateId(long corporate_id) {
        return this.findByOrganizationTypeAndOrganizationId(OrganizationType.CORPORATE.toString(), corporate_id);
    }

    public FreeTrial editFreeTrial(long organization_id, OrganizationType organization_type, String name_of_organization, FocusOn focus_on, Date trial_end_date) {
        FreeTrial freeTrial = this.findByOrganizationTypeAndOrganizationId(organization_type.toString(), organization_id);
        if (freeTrial == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.free.trial.is.not.found"));
        }
        freeTrial.setName_of_organization(name_of_organization);
        freeTrial.setFocus_on(focus_on);
        freeTrial.setTrial_end_date(trial_end_date);
        freeTrial.setCreatedAt(freeTrial.getCreatedAt());
        freeTrial.setUpdatedAt(new Date());
        return (FreeTrial)this.freeTrialRepository.save((Object)freeTrial);
    }

    public FreeTrial deleteFreeTrial(long organization_id, OrganizationType organization_type, boolean deleted) {
        FreeTrial freeTrial = this.findByOrganizationTypeAndOrganizationId(organization_type.toString(), organization_id);
        if (freeTrial == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.free.trial.is.not.found"));
        }
        freeTrial.setDeleted(deleted);
        freeTrial.setCreatedAt(freeTrial.getCreatedAt());
        freeTrial.setUpdatedAt(new Date());
        if (freeTrial.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            this.districtService.deleteDistrict(freeTrial.getOrganization_id(), deleted, true);
        } else if (freeTrial.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            this.schoolService.deleteSchool(freeTrial.getOrganization_id(), deleted, true);
        } else if (freeTrial.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
            this.corporateService.deleteCorporate(freeTrial.getOrganization_id(), deleted, true);
        }
        return (FreeTrial)this.freeTrialRepository.save((Object)freeTrial);
    }

    public LinkedHashMap<String, Object> createFreeTrialForCorporate(FreeTrialRequest request) {
        if (AppUtils.isNullOrEmpty((String)request.getName_of_organization())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.name.of.organization.is.not.found"));
        }
        if (request.getTrial_start_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.start.date.is.not.found"));
        }
        if (request.getTrial_end_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.end.date.is.not.found"));
        }
        if (request.getCheckpoint_1() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.checkpoint.one.is.not.found"));
        }
        if (request.getCheckpoint_2() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.checkpoint.two.is.not.found"));
        }
        if (request.getDescision_point_date() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.decision.point.date.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getTrial_evaluation_priorities())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.trial.evaluation.priorities.is.not.found"));
        }
        if (request.getCorporate() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getCorporate().getEmail())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.s.email.is.not.found"));
        }
        if (!AppUtils.isValidateEmail((String)request.getCorporate().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.s.email.is.not.valid"));
        }
        if (this.isEmailAlreadyExist(request.getCorporate().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.s.email.is.already.exist"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getCorporate().getAddress())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.s.address.is.not.found"));
        }
        request.getCorporate().setPassword(AppUtils.generatePassword());
        boolean hasParentDetails = this.hasParentDetails(request);
        boolean hasCorporateStudentDetails = this.hasCorporateStudentDetails(request);
        if (hasParentDetails && request.getCorporate().getEmail().equals(request.getParent().getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.and.parent.emails.must.not.match.with.each.other"));
        }
        FreeTrial freeTrial = new FreeTrial();
        freeTrial.setName_of_organization(request.getName_of_organization());
        freeTrial.setOrganization_type(OrganizationType.CORPORATE);
        freeTrial.setFocus_on(request.getFocus_on());
        freeTrial.setTrial_start_date(request.getTrial_start_date());
        freeTrial.setTrial_end_date(request.getTrial_end_date());
        freeTrial.setCheck_point_1(request.getCheckpoint_1());
        freeTrial.setCheck_point_2(request.getCheckpoint_2());
        freeTrial.setDescisions_points_date(request.getDescision_point_date());
        freeTrial.setTrial_evaluation_priorities(request.getTrial_evaluation_priorities());
        request.getCorporate().setName(request.getName_of_organization());
        Corporate corporate = this.corporateAuthService.createCorporateTrialAccount(request.getCorporate(), request.getFocus_on());
        freeTrial.setOrganization_id(corporate.getCorporate_id());
        if (hasParentDetails) {
            Parent parent = this.parentAuthService.createParentTrialAccount(corporate.getCorporate_id(), request.getParent());
            request.getParent().setRegistration_code(parent.getRegistration_code());
            if (hasCorporateStudentDetails) {
                this.studentAuthService.createStudentTrialAccount(0L, parent.getParent_id(), request.getStudent());
            }
        } else if (hasCorporateStudentDetails) {
            this.studentAuthService.createStudentTrialAccount(0L, 0L, request.getStudent());
        }
        this.freeTrialRepository.save((Object)freeTrial);
        LinkedHashMap<String, Object> freeTrialWapper = new LinkedHashMap<String, Object>();
        freeTrialWapper.put("free_trial", freeTrial);
        freeTrialWapper.put("corporate", request.getCorporate());
        this.sendFreeTrailEmailOrganization(request.getCorporate().getEmail(), request.getCorporate().getPassword(), request.getCorporate().getName());
        if (hasParentDetails) {
            freeTrialWapper.put("parent", request.getParent());
            this.sendFreeTrailEmailInstructor(request.getParent().getEmail(), request.getParent().getPassword());
        }
        if (hasCorporateStudentDetails) {
            freeTrialWapper.put("student", request.getStudent());
        }
        return freeTrialWapper;
    }

    private boolean hasCorporateStudentDetails(FreeTrialRequest request) {
        if (!(request.getStudent() == null || AppUtils.isNullOrEmpty((String)request.getStudent().getFirst_name()) && AppUtils.isNullOrEmpty((String)request.getStudent().getLast_name()))) {
            if (AppUtils.isNullOrEmpty((String)request.getStudent().getFirst_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.s.first.name.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getStudent().getLast_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.s.last.name.is.not.found"));
            }
            request.getStudent().setPassword(this.getPasswordByNameAndDate(request.getStudent().getFirst_name() + request.getStudent().getLast_name(), new Date()));
            return true;
        }
        return false;
    }

    private boolean hasParentDetails(FreeTrialRequest request) {
        if (!(request.getParent() == null || AppUtils.isNullOrEmpty((String)request.getParent().getEmail()) && AppUtils.isNullOrEmpty((String)request.getParent().getFirst_name()) && AppUtils.isNullOrEmpty((String)request.getParent().getLast_name()))) {
            if (AppUtils.isNullOrEmpty((String)request.getParent().getEmail())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.parent.s.email.is.not.found"));
            }
            if (!AppUtils.isValidateEmail((String)request.getParent().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.parent.s.email.is.not.valid"));
            }
            if (this.isEmailAlreadyExist(request.getParent().getEmail())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.parent.s.email.is.already.exist"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getParent().getFirst_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.parent.s.first.name.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getParent().getLast_name())) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.parent.s.last.name.is.not.found"));
            }
            request.getParent().setPassword(AppUtils.generatePassword());
            return true;
        }
        return false;
    }

    public boolean checkTrialActiveByCorporateId(long corporate_id) {
        FreeTrial freeTrial;
        boolean datePassed;
        Corporate corporate = this.corporateService.getCorporateById(corporate_id);
        return corporate != null && !(datePassed = DateUtils.checkDateTimeIsPassed((Date)(freeTrial = this.freeTrialRepository.findByOrganizationTypeAndOrganizationId(OrganizationType.CORPORATE.toString(), corporate.getCorporate_id())).getTrial_end_date()));
    }
}

