/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.toppicks.repository;

import com.infinite.focus.server.toppicks.dto.TopPicksDTO;
import com.infinite.focus.server.toppicks.repository.TopPicksCoreRepository;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class TopPicksCoreRepositoryImpl
implements TopPicksCoreRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static TopPicksDTO mapRow(ResultSet rs, int i) throws SQLException {
        return TopPicksDTO.builder().top_picks_id(rs.getLong("top_picks_id")).quote(rs.getString("quote")).quote_es(rs.getString("quote_es")).isDailyTopPicks(Boolean.valueOf(rs.getBoolean("is_daily_top_picks"))).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public TopPicksDTO findDailyTopPicks() {
        String SQL = "SELECT * FROM top_picks WHERE is_daily_top_picks = true";
        try {
            return (TopPicksDTO)this.jdbcTemplate.queryForObject(SQL, TopPicksCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<TopPicksDTO> findAllOrderById() {
        String SQL = "SELECT * FROM top_picks ORDER BY top_picks_id ASC";
        return this.jdbcTemplate.query(SQL, TopPicksCoreRepositoryImpl::mapRow);
    }

    public TopPicksDTO findByQuote(String quote) {
        String SQL = "SELECT * FROM top_picks WHERE quote = ? ORDER BY top_picks_id ASC LIMIT 0, 1";
        try {
            return (TopPicksDTO)this.jdbcTemplate.queryForObject(SQL, TopPicksCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TopPicksDTO findById(long top_picks_id) {
        String SQL = "SELECT * FROM top_picks WHERE top_picks_id = ? ";
        try {
            return (TopPicksDTO)this.jdbcTemplate.queryForObject(SQL, TopPicksCoreRepositoryImpl::mapRow, new Object[]{top_picks_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM top_picks WHERE top_picks_id = ? ";
        this.jdbcTemplate.update("DELETE FROM top_picks WHERE top_picks_id = ? ", new Object[]{id});
    }

    public void update(long id, String quote, String quote_es) {
        String SQL = "UPDATE top_picks SET quote = ?, quote_es = ?, updated_at = ? WHERE top_picks_id = ?";
        this.jdbcTemplate.update("UPDATE top_picks SET quote = ?, quote_es = ?, updated_at = ? WHERE top_picks_id = ?", new Object[]{quote, quote_es, Timestamp.valueOf(LocalDateTime.now()), id});
    }

    public void updateAllIsDailyTopPicksToFalse() {
        String SQL = "UPDATE top_picks SET is_daily_top_picks = false, updated_at = ? ";
        this.jdbcTemplate.update("UPDATE top_picks SET is_daily_top_picks = false, updated_at = ? ", new Object[]{Timestamp.valueOf(LocalDateTime.now())});
    }

    public TopPicksDTO findRandomTopPicks() {
        String SQL = "SELECT * FROM top_picks ORDER BY RAND() LIMIT 0,1 ";
        try {
            return (TopPicksDTO)this.jdbcTemplate.queryForObject(SQL, TopPicksCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateIsDailyTopPicks(long id, Boolean is_daily_top_picks) {
        String SQL = "UPDATE top_picks SET is_daily_top_picks = ?, updated_at = ? WHERE top_picks_id = ?";
        this.jdbcTemplate.update("UPDATE top_picks SET is_daily_top_picks = ?, updated_at = ? WHERE top_picks_id = ?", new Object[]{is_daily_top_picks, Timestamp.valueOf(LocalDateTime.now()), id});
    }

    public TopPicksDTO create(String quote, String quote_es) {
        String INSERT_SQL = "INSERT INTO top_picks (quote, quote_es, is_daily_top_picks, created_at, updated_at) VALUES (?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO top_picks (quote, quote_es, is_daily_top_picks, created_at, updated_at) VALUES (?,?,?,?,?)", 1);
            ps.setString(1, quote);
            ps.setString(2, quote_es);
            ps.setBoolean(3, false);
            ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int top_picks_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)top_picks_id);
    }
}

