/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postmood.repository;

import com.infinite.focus.server.postmood.dto.PostMoodDTO;
import com.infinite.focus.server.postmood.repository.PostMoodRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PostMoodRepositoryImpl
implements PostMoodRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static PostMoodDTO mapRow(ResultSet rs, int i) throws SQLException {
        return PostMoodDTO.builder().post_mood_id(rs.getLong("post_mood_id")).post_id(rs.getLong("post_id")).mood_id(rs.getLong("mood_id")).build();
    }

    public List<PostMoodDTO> create(long post_id, Set<Long> mood_ids) {
        String INSERT_SQL = "INSERT INTO post_mood (post_id, mood_id, created_at, updated_at) VALUES (?,?,?,?)";
        Set insertedIds = (Set)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO post_mood (post_id, mood_id, created_at, updated_at) VALUES (?,?,?,?)", 1), ps -> {
            for (Long mood_id : mood_ids) {
                ps.setLong(1, post_id);
                ps.setLong(2, mood_id);
                ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
                ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet resultSet = ps.getGeneratedKeys();
            HashSet<Long> ids = new HashSet<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return this.findByIds(insertedIds);
    }

    public List<PostMoodDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<PostMoodDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM post_mood WHERE post_mood_id IN(%s) ORDER BY post_mood_id ASC";
        List postAndMoodDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), PostMoodRepositoryImpl::mapRow);
        return postAndMoodDTOS;
    }

    public void delete(long post_id) {
        String SQL = "DELETE FROM post_mood WHERE post_id = ?";
        this.jdbcTemplate.update("DELETE FROM post_mood WHERE post_id = ?", new Object[]{post_id});
    }

    public List<Long> findPostIdsByMoodIds(Set<Long> mood_ids) {
        if (AppUtils.isNullOrEmpty(mood_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(mood_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(post_id) FROM post_mood WHERE mood_id IN(%s) ORDER BY post_id ASC";
        List post_ids = this.jdbcTemplate.query(String.format(SQL, inSql), mood_ids.toArray(), (rs, i) -> rs.getLong(1));
        return post_ids;
    }

    public List<PostMoodDTO> findPostMoodListByPostIds(Set<Long> post_ids) {
        if (AppUtils.isNullOrEmpty(post_ids)) {
            return new ArrayList<PostMoodDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(post_ids.size(), "?"));
        String SQL = "SELECT * FROM post_mood WHERE post_id IN(%s) ORDER BY post_id ASC";
        List postMoodDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), post_ids.toArray(), PostMoodRepositoryImpl::mapRow);
        return postMoodDTOS;
    }
}

