/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.repository;

import com.infinite.focus.server.logging.dto.LoggingDTO;
import com.infinite.focus.server.logging.repository.LoggingRepository;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import javax.transaction.Transactional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class LoggingRepositoryImpl
implements LoggingRepository {
    private final JdbcTemplate jdbcTemplate;

    public LoggingRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static LoggingDTO mapRow(ResultSet rs, int i) throws SQLException {
        return LoggingDTO.builder().logging_id(rs.getLong("logging_id")).user_type(rs.getString("user_type")).user_id(rs.getLong("user_id")).is_request(rs.getBoolean("is_request")).url(rs.getString("url")).method(rs.getString("method")).headers(rs.getString("headers")).params(rs.getString("params")).req_resp(rs.getString("req_resp")).created_at((Date)rs.getTimestamp("created_at")).build();
    }

    @Transactional
    public void create(String user_type, long user_id, boolean is_request, String url, String method, String headers, String params, String req_resp) {
        String INSERT_SQL = "INSERT INTO logging (user_type, user_id, is_request, url, method, headers, params, req_resp) VALUES (?,?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO logging (user_type, user_id, is_request, url, method, headers, params, req_resp) VALUES (?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, user_type);
            ps.setLong(2, user_id);
            ps.setBoolean(3, is_request);
            ps.setString(4, url);
            ps.setString(5, method);
            ps.setString(6, headers);
            ps.setString(7, params);
            ps.setString(8, req_resp);
            return ps;
        }, (KeyHolder)holder);
        int logging_id = Objects.requireNonNull(holder.getKey()).intValue();
    }

    @Transactional
    public LoggingDTO findById(long id) {
        String SQL = "SELECT * FROM logging WHERE logging_id = ? ";
        try {
            return (LoggingDTO)this.jdbcTemplate.queryForObject(SQL, LoggingRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

