/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.survey.controller;

import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.dashboard.model.LabelAndCount;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructorsurveychoice.service.InstructorSurveyChoiceService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.largeorganizationsurveychoice.service.LargeOrganizationSurveyChoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationsurveychoice.service.OrganizationSurveyChoiceService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.survey.entity.Survey;
import com.infinite.focus.server.survey.model.LabelAndCountAndAverage;
import com.infinite.focus.server.survey.model.QuestionAndData;
import com.infinite.focus.server.survey.request.AssignToYouthRequest;
import com.infinite.focus.server.survey.request.GetDataAnalyticsRequest;
import com.infinite.focus.server.survey.request.SurveySubmitRequest;
import com.infinite.focus.server.survey.service.SurveyService;
import com.infinite.focus.server.surveyquestion.model.SurveyType;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.youthsurveychoice.service.YouthSurveyChoiceService;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/survey"})
public class SurveyController {
    @Autowired
    AuthService authService;
    @Autowired
    SurveyService surveyService;
    @Autowired
    LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService;
    @Autowired
    OrganizationSurveyChoiceService organizationSurveyChoiceService;
    @Autowired
    InstructorSurveyChoiceService instructorSurveyChoiceService;
    @Autowired
    YouthSurveyChoiceService youthSurveyChoiceService;
    @Autowired
    ActivityCriteriaRepository activityCriteriaRepository;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/assign/to/youth"})
    public ResponseEntity<Message> assignToYouth(@RequestBody AssignToYouthRequest request) {
        this.youthSurveyChoiceService.assignSurveyToYouth(request.getToday());
        this.instructorSurveyChoiceService.assignSurveyToInstructor(request.getToday());
        this.organizationSurveyChoiceService.assignSurveyToOrganization(request.getToday());
        this.largeOrganizationSurveyChoiceService.assignSurveyToLargeOrganization(request.getToday());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("assigned.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/sync-dates"})
    public ResponseEntity<Message> syncDates(@RequestBody AssignToYouthRequest request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("sync.in.progress"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/submit"})
    public ResponseEntity<Message> submit(@RequestHeader(value="Authorization") String token, @RequestBody SurveySubmitRequest request) {
        if (request.getType().equals((Object)SurveyType.YOUTH)) {
            Student student = this.authService.isStudent(token);
            Survey survey = this.surveyService.getSurveyById(request.getQuestion_index().longValue());
            this.youthSurveyChoiceService.updateYouthSurveyChoice(student.getStudent_id(), survey.getSurvey_id(), request.getSurvey_choices());
        } else if (request.getType().equals((Object)SurveyType.INSTRUCTOR)) {
            Instructor instructor = this.authService.isInstructor(token);
            Survey survey = this.surveyService.getSurveyById(request.getQuestion_index().longValue());
            this.instructorSurveyChoiceService.updateInstructorSurveyChoice(instructor.getInstructor_id(), survey.getSurvey_id(), request.getSurvey_choices());
        } else if (request.getType().equals((Object)SurveyType.ORGANIZATION)) {
            List schools = this.authService.isSchool(token);
            School school = null;
            if (!AppUtils.isNullOrEmpty((List)schools)) {
                school = schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id().longValue()).findFirst().orElse(null);
            }
            if (school == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            Survey survey = this.surveyService.getSurveyById(request.getQuestion_index().longValue());
            this.organizationSurveyChoiceService.updateOrganizationSurveyChoice(school.getSchool_id(), survey.getSurvey_id(), request.getSurvey_choices());
        } else if (request.getType().equals((Object)SurveyType.LARGE_ORGANIZATION)) {
            District district = this.authService.isDistrict(token);
            Survey survey = this.surveyService.getSurveyById(request.getQuestion_index().longValue());
            this.largeOrganizationSurveyChoiceService.updateLargeOrganizationSurveyChoice(district.getDistrict_id(), survey.getSurvey_id(), request.getSurvey_choices());
        }
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("survey.submitted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get/data/analytics"})
    public ResponseEntity<Object> getDataAnalytics(@RequestHeader(value="Authorization") String token, @RequestBody GetDataAnalyticsRequest request) {
        Date fromDate = null;
        Date toDate = null;
        String fromDateStr = null;
        String toDateStr = null;
        String fromTimeZone = null;
        String toTimeZone = null;
        try {
            SimpleDateFormat YYYYMMM = DateUtils.YYYYMMM;
            YYYYMMM.setTimeZone(request.getTimeZone());
            Date date = YYYYMMM.parse(request.getYear() + " " + request.getMonth());
            fromDate = DateUtils.getStartDateTimeOfTheMonth((Date)date, (TimeZone)request.getTimeZone());
            toDate = DateUtils.getEndDateTimeOfTheMonth((Date)date, (TimeZone)request.getTimeZone());
            System.out.println("UTC-FromDate " + fromDate + " UTC-ToDate " + toDate + " UTC-TimeZone " + request.getTimeZone());
            fromDateStr = DateUtils.getDateInString((Date)DateUtils.getStartDateTimeOfTheMonth((Date)date, (TimeZone)request.getTimeZone()));
            toDateStr = DateUtils.getDateInString((Date)DateUtils.getEndDateTimeOfTheMonth((Date)date, (TimeZone)request.getTimeZone()));
            fromTimeZone = DateUtils.getSystemTimeOffset((ZonedDateTime)new Date().toInstant().atZone(ZoneId.systemDefault()));
            toTimeZone = DateUtils.getSystemTimeOffset((ZonedDateTime)new Date().toInstant().atZone(ZoneId.of(request.getTimeZone().getID())));
            System.out.println("FromDate " + fromDateStr + " ToDate " + toDateStr + " FromTimeZone " + fromTimeZone + " ToTimeZone " + toTimeZone);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QuestionAndData labelAndCountAndAverages = new QuestionAndData();
        if (fromDateStr == null || toDateStr == null) {
            return new ResponseEntity((Object)labelAndCountAndAverages, HttpStatus.OK);
        }
        if (request.getDataAnalyticsType().equals((Object)SurveyType.YOUTH)) {
            labelAndCountAndAverages = this.youthSurveyChoiceService.getDataAnalytics(fromDateStr, toDateStr, fromTimeZone, toTimeZone);
        } else if (request.getDataAnalyticsType().equals((Object)SurveyType.INSTRUCTOR)) {
            labelAndCountAndAverages = this.instructorSurveyChoiceService.getDataAnalytics(fromDateStr, toDateStr, fromTimeZone, toTimeZone);
        } else if (request.getDataAnalyticsType().equals((Object)SurveyType.ORGANIZATION)) {
            labelAndCountAndAverages = this.organizationSurveyChoiceService.getDataAnalytics(fromDateStr, toDateStr, fromTimeZone, toTimeZone);
        } else if (request.getDataAnalyticsType().equals((Object)SurveyType.LARGE_ORGANIZATION)) {
            labelAndCountAndAverages = this.largeOrganizationSurveyChoiceService.getDataAnalytics(fromDateStr, toDateStr, fromTimeZone, toTimeZone);
        }
        return new ResponseEntity((Object)this.getQuestionAndData(labelAndCountAndAverages), HttpStatus.OK);
    }

    private LinkedHashMap<String, Object> getQuestionAndData(QuestionAndData questionAndData) {
        LinkedHashMap<String, Object> questionAndData_en = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> questionAndData_es = new LinkedHashMap<String, Object>();
        LinkedHashMap data_en = new LinkedHashMap();
        LinkedHashMap data_es = new LinkedHashMap();
        LinkedHashMap stats_en = new LinkedHashMap();
        LinkedHashMap stats_es = new LinkedHashMap();
        for (LabelAndCountAndAverage labelAndCountAndAverage : questionAndData.getLabelAndCountAndAverages()) {
            LinkedList<Number> linkedListCountAndAverage = new LinkedList<Number>();
            linkedListCountAndAverage.add(labelAndCountAndAverage.getCount());
            linkedListCountAndAverage.add(labelAndCountAndAverage.getAverage());
            data_en.put(labelAndCountAndAverage.getLabel(), linkedListCountAndAverage);
            if (!Language.isSpanish()) continue;
            LinkedList<Number> linkedListCountAndAverage_es = new LinkedList<Number>();
            linkedListCountAndAverage_es.add(labelAndCountAndAverage.getCount());
            linkedListCountAndAverage_es.add(labelAndCountAndAverage.getAverage());
            data_es.put(labelAndCountAndAverage.getLabel_es(), linkedListCountAndAverage_es);
        }
        questionAndData_en.put("question", questionAndData.getSurveyQuestion().getQuestion());
        questionAndData_en.put("data", data_en);
        questionAndData_en.put("stats", stats_en);
        LinkedList<LabelAndCount> statsListEn = new LinkedList<LabelAndCount>();
        statsListEn.add(LabelAndCount.builder().label("Total Survey Sent: ").count((Object)questionAndData.getTotal_survey_sent()).build());
        statsListEn.add(LabelAndCount.builder().label("Active Users Who Received Survey: ").count(questionAndData.getActive_users_who_received_survey()).build());
        statsListEn.add(LabelAndCount.builder().label("Filled Survey: ").count((Object)questionAndData.getFilled_survey()).build());
        questionAndData_en.put("stats", statsListEn);
        if (Language.isSpanish()) {
            questionAndData_es.put("question", questionAndData.getSurveyQuestion().getQuestion_es());
            questionAndData_es.put("data", data_es);
            LinkedList<LabelAndCount> statsListEs = new LinkedList<LabelAndCount>();
            statsListEs.add(LabelAndCount.builder().label("Total de encuestas enviadas: ").count((Object)questionAndData.getTotal_survey_sent()).build());
            statsListEs.add(LabelAndCount.builder().label("Usuarios activos que recibieron la encuesta: ").count(questionAndData.getActive_users_who_received_survey()).build());
            statsListEs.add(LabelAndCount.builder().label("Encuesta rellenada: ").count((Object)questionAndData.getFilled_survey()).build());
            questionAndData_es.put("stats", statsListEs);
        }
        LinkedHashMap<String, Object> questionAndDataPerLanguage = new LinkedHashMap<String, Object>();
        questionAndDataPerLanguage.put("en", questionAndData_en);
        if (Language.isSpanish()) {
            questionAndDataPerLanguage.put("es", questionAndData_es);
        }
        return questionAndDataPerLanguage;
    }
}

