/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.askforhelp.controller;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.request.CreateAskForHelpRequest;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByIdRequest;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByStudentIdRequest;
import com.infinite.focus.server.askforhelp.request.GetByStudentAndSchoolIdRequest;
import com.infinite.focus.server.askforhelp.request.SetSOSRequestIdRequest;
import com.infinite.focus.server.askforhelp.service.AskForHelpService;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpEventWrapper;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpWrapper;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/ask-for-help"})
public class AskForHelpController {
    private final AskForHelpService askForHelpService;

    public AskForHelpController(AskForHelpService askForHelpService) {
        this.askForHelpService = askForHelpService;
    }

    @PostMapping(value={"/get-pending-ask-for-help-by-student-id"})
    ResponseEntity<AskForHelpDTO> getPendingAskForHelpByStudentId(@RequestBody GetAskForHelpByStudentIdRequest request) {
        AskForHelpDTO askForHelpDTO = this.askForHelpService.getPendingAskForHelpByStudentId(request.getStudent_id());
        if (askForHelpDTO != null) {
            return new ResponseEntity((Object)askForHelpDTO, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/create"})
    ResponseEntity<AskForHelpDTO> create(@RequestBody CreateAskForHelpRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.create(request.getStudent_id(), request.getMood_update_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/set-sos-request-id"})
    ResponseEntity<AskForHelpDTO> setSOSRequestId(@RequestBody SetSOSRequestIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.setSOSRequestId(request.getAsk_for_help_id(), request.getSos_request_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-ask-for-help-by-id"})
    ResponseEntity<AskForHelpDTO> getPendingAskForHelpByStudentId(@RequestBody GetAskForHelpByIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.getAskForHelpById(request.getAsk_for_help_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id-and-school-id"})
    ResponseEntity<AskForHelpWrapper> getByStudentIdAndSchoolId(@RequestBody GetByStudentAndSchoolIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.getByStudentIdAndSchoolId(request.getStudent_id(), request.getSchool_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/check-by-student-id"})
    ResponseEntity<AskForHelpEventWrapper> checkByStudentId(@RequestBody GetAskForHelpByStudentIdRequest request) {
        AskForHelpEventWrapper askForHelpEventWrapper = this.askForHelpService.checkByStudentId(request.getStudent_id());
        if (askForHelpEventWrapper == null) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity((Object)askForHelpEventWrapper, HttpStatus.OK);
    }
}

