/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.twilio.advice;

import java.util.Date;
import java.util.LinkedHashMap;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class ApplicationExceptionHandler {
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Object> handleInvalidArgument(MethodArgumentNotValidException ex, WebRequest request) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("timestamp", new Date());
        body.put("status", HttpStatus.BAD_REQUEST.value());
        body.put("error", HttpStatus.BAD_REQUEST);
        body.put("message", ((FieldError)ex.getBindingResult().getFieldErrors().get(0)).getDefaultMessage());
        body.put("path", ((ServletWebRequest)request).getRequest().getRequestURI().toString());
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }
}

