/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.service.userstats;

import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.service.userstats.UserStatsService;
import com.infinite.focus.server.dashboard.service.userstats.UserStatsServiceImpl;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.entity.Grade;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.service.GradeService;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.instructor.repository.InstructorCriteriaRepository;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.view.InstructorView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserStatsServiceImpl
implements UserStatsService {
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    InstructorCriteriaRepository instructorCriteriaRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    ActivityCriteriaRepository activityCriteriaRepository;
    @Autowired
    StudentCriteriaRepository studentCriteriaRepository;
    @Autowired
    GradeService gradeService;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;
    String forwardSlash = "/";

    public Object getOverall(GetDataDashBoardRequest request) {
        System.out.println("-----------------------OVERALL-----------------------------");
        String fromDate = DateUtils.getDateInString((Date)request.getFromDate());
        String toDate = DateUtils.getDateInString((Date)request.getToDate());
        long studentCount = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.studentRepository.getCountByCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.studentRepository.getCount();
        long instructorCount = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.instructorRepository.getCountByCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.instructorRepository.getCount();
        long totalCount = studentCount + instructorCount;
        System.out.println("Stduent's count\t\t\t\t\t" + studentCount);
        System.out.println("Instructor's count\t\t\t\t" + instructorCount);
        System.out.println("------------------------------------------------------------");
        System.out.println("Total count\t\t\t\t\t" + totalCount);
        BigDecimal avgStudents = DigitUtils.getPercentageBigDecimal((Long)studentCount, (Long)totalCount);
        BigDecimal avgInstructors = DigitUtils.getPercentageBigDecimal((Long)instructorCount, (Long)totalCount);
        System.out.println("------------------------------------------------------------");
        System.out.println("---------Percentage = (Value " + this.forwardSlash + " Total Value) \ufffd 100-----------");
        System.out.println("Average Stduents\t\t\t\t" + avgStudents);
        System.out.println("Average Instructors\t\t\t\t" + avgInstructors);
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        LinkedHashMap graphData = new LinkedHashMap();
        LinkedList<Number> studentsList = new LinkedList<Number>();
        studentsList.add(studentCount);
        studentsList.add(avgStudents);
        graphData_en.put("Students", studentsList);
        graphData_es.put("Estudiantes", studentsList);
        LinkedList<Number> instructorsList = new LinkedList<Number>();
        instructorsList.add(instructorCount);
        instructorsList.add(avgInstructors);
        graphData_en.put("Instructors", instructorsList);
        graphData_es.put("Instructores", instructorsList);
        graphData.put("en", graphData_en);
        graphData.put("es", graphData_es);
        return graphData;
    }

    public Object getTeachers(GetDataDashBoardRequest request) {
        System.out.println("------------------------------------ TEACHERS ---------------------------------------");
        LinkedHashMap<String, LinkedHashMap> graphData = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap graphData_en = this.getTeachersByGrade(request, request.getFromDate(), request.getToDate());
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            LinkedHashMap graphData_es = graphData_en.entrySet().stream().collect(LinkedHashMap::new, (map, entry) -> {
                LinkedList cfr_ignored_0 = (LinkedList)map.put(Language.getGradeKey((String)((String)entry.getKey()), (GradeView)this.gradeRepository.findByGradeName((String)entry.getKey()), (String)Language.getLanguage()), entry.getValue());
            }, Map::putAll);
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Object>> getTeachersByGrade(GetDataDashBoardRequest request, Date fromDate, Date toDate) {
        System.out.println("------------------------------------ TEACHERS BY GRADE ---------------------------------------");
        List gradeViews = this.gradeRepository.getGradesOrderByGradeId();
        LinkedHashMap<String, Long> gradeAndCountMap = new LinkedHashMap<String, Long>();
        Long totalCount = 0L;
        for (int i = 0; i < gradeViews.size(); ++i) {
            String key = ((GradeView)gradeViews.get(i)).getGrade_name();
            Long count = this.instructorCriteriaRepository.getInstructorIdsByGradeIdAndCreatedAtBetweenFromDateAndToDate(((GradeView)gradeViews.get(i)).getGrade_id(), fromDate, toDate).size();
            totalCount = totalCount + count;
            gradeAndCountMap.put(key, count);
            System.out.println(key + " \t\t\t\t" + count);
        }
        System.out.println("-----------------------------------------------------------------------------");
        System.out.println("Total \t\t\t\t" + totalCount);
        System.out.println("----------------Percentage = (Value " + this.forwardSlash + " Total Value) \ufffd 100---------------------");
        LinkedHashMap<String, LinkedList<Object>> graphData = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalPercentage = 0.0;
        for (String key : gradeAndCountMap.keySet()) {
            LinkedList<Number> list = new LinkedList<Number>();
            Long count = (Long)gradeAndCountMap.get(key);
            list.add(count);
            BigDecimal percentag = DigitUtils.getPercentageBigDecimalInTwoDigit((Long)count, (Long)totalCount);
            list.add(percentag);
            totalPercentage = totalPercentage + percentag.doubleValue();
            System.out.println(key + " \t\t\t\t" + count + "\t\t" + totalCount + "\t\t" + percentag);
            graphData.put(key, list);
        }
        totalPercentage = DigitUtils.formatDouble((Double)totalPercentage);
        LinkedList<Number> list = new LinkedList<Number>();
        list.add(totalCount);
        list.add(DigitUtils.formatBigDecimalInTwoDigit((BigDecimal)new BigDecimal(totalPercentage)));
        graphData.put("Total", list);
        System.out.println("-----------------------------------------------------------------------------");
        System.out.println("Total \t\t\t\t" + totalCount + "\t\t" + totalCount + "\t\t" + totalPercentage);
        return graphData;
    }

    public Object getStudents(GetDataDashBoardRequest request) {
        long count;
        System.out.println("------------------------------User Stats's Student --------------------------------");
        Date firstStudentCreatedDate = this.studentRepository.getFirstStudentCreatedDate();
        Date fromDate = firstStudentCreatedDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentCreatedDate);
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap genders_es = new LinkedHashMap();
            List studentsOfGenders = this.getStudentsByAllGender(request);
            for (String gender : request.getGenders()) {
                System.out.println("----------------------------- " + gender + "------------------------------");
                count = studentsOfGenders.stream().filter(c -> c.getGender().equalsIgnoreCase(gender)).count();
                genders_en.put(gender, this.getStudent(count, fromDate, toDate, request.getTimeZone()));
                genders_es.put(this.genderRepository.findByGender(gender).getGender_es(), genders_en.get(gender));
            }
            graphData_en.put("Gender", genders_en);
            graphData_es.put("G\u00e9nero", genders_es);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap ages_es = new LinkedHashMap();
            List studentsOfAges = this.getStudentsByAllAge(request);
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                count = studentsOfAges.stream().filter(c -> TimeUtils.getAge((Date)c.getDate_of_birth()) == age).count();
                ages_en.put(String.valueOf(age), this.getStudent(count, fromDate, toDate, request.getTimeZone()));
                ages_es.put(String.valueOf(age), ages_en.get(String.valueOf(age)));
            }
            graphData_en.put("Age", ages_en);
            graphData_es.put("Edad", ages_es);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap ethnicityMap_es = new LinkedHashMap();
            List studentsOfEthnicities = this.getStudentsByAllEthnicity(request);
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                count = studentsOfEthnicities.stream().filter(c -> c.getEthnicity().equalsIgnoreCase(ethnicity)).count();
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                ethnicityMap_en.put(ethnicityItem.getEthnicity(), this.getStudent(count, fromDate, toDate, request.getTimeZone()));
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), ethnicityMap_en.get(ethnicityItem.getEthnicity()));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            graphData_es.put("Etnia", ethnicityMap_es);
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap grades_es = new LinkedHashMap();
            List studentsOfGrades = this.getStudentsByAllGrade(request);
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                count = studentsOfGrades.stream().filter(c -> Objects.equals(c.getGrade_id(), grade_id)).count();
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                grades_en.put(gradeView.getGrade_name(), this.getStudent(count, fromDate, toDate, request.getTimeZone()));
                grades_es.put(gradeView.getGrade_name_es(), grades_en.get(gradeView.getGrade_name()));
            }
            graphData_en.put("Grade", grades_en);
            graphData_es.put("Grado", grades_es);
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<Object> getStudent(long count, Date fromDate, Date toDate, TimeZone timeZone) {
        LinkedList<Object> reportings = new LinkedList<Object>();
        if (count > 0L) {
            Double size = count;
            System.out.println("Student List Size - " + size + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public Object getStudentsAndDemographicStrands(GetDataDashBoardRequest request) {
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$DemographicType[request.getDemographicType().ordinal()]) {
            case 1: {
                return this.getStudentsCountByGenders(request);
            }
            case 2: {
                return this.getStudentsCountByAges(request);
            }
            case 3: {
                return this.getStudentsCountByEthnicity(request);
            }
            case 4: {
                return this.getStudentsCountByGrades(request);
            }
        }
        return new LinkedHashMap();
    }

    public Object getStudentsCountByGenders(GetDataDashBoardRequest request) {
        LinkedHashMap countAndAvgMap_en = new LinkedHashMap();
        LinkedHashMap countAndAvgMap_es = new LinkedHashMap();
        Double totalCount = 0.0;
        List studentsOfGenders = this.getStudentsByAllGender(request);
        for (String key : request.getGenders()) {
            Gender gender = this.genderRepository.findByGender(key);
            Long count = studentsOfGenders.stream().filter(c -> c.getGender().equalsIgnoreCase(key)).count();
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap_en.put(key, list);
            countAndAvgMap_es.put(gender.getGender_es(), countAndAvgMap_en.get(key));
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_en, (Double)totalCount);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        graphData.put("en", countAndAvgMap_en);
        if (Language.isSpanish()) {
            DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_es, (Double)totalCount);
            graphData.put("es", countAndAvgMap_es);
        }
        return graphData;
    }

    public Object getStudentsCountByEthnicity(GetDataDashBoardRequest request) {
        LinkedHashMap countAndAvgMap_en = new LinkedHashMap();
        LinkedHashMap countAndAvgMap_es = new LinkedHashMap();
        Double totalCount = 0.0;
        List studentsOfEthnicities = this.getStudentsByAllEthnicity(request);
        for (int i = 0; i < request.getEthnicity().size(); ++i) {
            String key = (String)request.getEthnicity().get(i);
            Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(key);
            long count = studentsOfEthnicities.stream().filter(c -> c.getEthnicity().equalsIgnoreCase(key)).count();
            totalCount = totalCount + (double)count;
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap_en.put(key, list);
            countAndAvgMap_es.put(ethnicityItem.getEthnicity_es(), countAndAvgMap_en.get(key));
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_en, (Double)totalCount);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        graphData.put("en", countAndAvgMap_en);
        if (Language.isSpanish()) {
            DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_es, (Double)totalCount);
            graphData.put("es", countAndAvgMap_es);
        }
        return graphData;
    }

    public Object getStudentsCountByAges(GetDataDashBoardRequest request) {
        LinkedHashMap countAndAvgMap_en = new LinkedHashMap();
        LinkedHashMap countAndAvgMap_es = new LinkedHashMap();
        Double totalCount = 0.0;
        List studentsOfAges = this.getStudentsByAllAge(request);
        for (Integer key : request.getAges()) {
            Long count = studentsOfAges.stream().filter(c -> TimeUtils.getAge((Date)c.getDate_of_birth()) == key).count();
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap_en.put(String.valueOf(key), list);
            countAndAvgMap_es.put(String.valueOf(key), countAndAvgMap_en.get(String.valueOf(key)));
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_en, (Double)totalCount);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        graphData.put("en", countAndAvgMap_en);
        if (Language.isSpanish()) {
            DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_es, (Double)totalCount);
            graphData.put("es", countAndAvgMap_es);
        }
        return graphData;
    }

    public Object getStudentsCountByGrades(GetDataDashBoardRequest request) {
        LinkedHashMap countAndAvgMap_en = new LinkedHashMap();
        LinkedHashMap countAndAvgMap_es = new LinkedHashMap();
        double totalCount = 0.0;
        List studentsOfGrades = this.getStudentsByAllGrade(request);
        for (int i = 0; i < request.getGradeIds().size(); ++i) {
            Long key = (Long)request.getGradeIds().get(i);
            GradeView gradeView = this.gradeRepository.findByGradeId(key);
            long count = studentsOfGrades.stream().filter(c -> Objects.equals(c.getGrade_id(), key)).count();
            totalCount += (double)count;
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap_en.put(gradeView.getGrade_name(), list);
            countAndAvgMap_es.put(gradeView.getGrade_name_es(), countAndAvgMap_en.get(gradeView.getGrade_name()));
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_en, (Double)totalCount);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        graphData.put("en", countAndAvgMap_en);
        if (Language.isSpanish()) {
            DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_es, (Double)totalCount);
            graphData.put("es", countAndAvgMap_es);
        }
        return graphData;
    }

    private List<StudentDTO> getStudentsByAllEthnicity(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        getDataDashBoardRequest.getEthnicity().clear();
        getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
        return this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, true);
    }

    private List<StudentDTO> getStudentsByAllGender(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        getDataDashBoardRequest.getGenders().clear();
        getDataDashBoardRequest.getGenders().addAll(request.getGenders());
        return this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, true);
    }

    private List<StudentDTO> getStudentsByAllAge(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        getDataDashBoardRequest.getAges().clear();
        getDataDashBoardRequest.getAges().addAll(request.getAges());
        return this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, true);
    }

    private List<StudentDTO> getStudentsByAllGrade(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        getDataDashBoardRequest.getGradeIds().clear();
        getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
        return this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, true);
    }

    public Object getLoginAttemptsStudentsData(GetDataDashBoardRequest request) {
        return this.getLoginAttemptsStudents(request);
    }

    public Object getLoginAttemptsStudents(GetDataDashBoardRequest request) {
        List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities, Language.getLanguage());
        LinkedList<LabelAndValue> graphData_en = new LinkedList<LabelAndValue>();
        LinkedList<LabelAndValue> graphData_es = new LinkedList<LabelAndValue>();
        for (String[] keys : activitiesMap.keySet()) {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
            List values = (List)activitiesMap.get(keys);
            for (int i = 0; i < values.size(); ++i) {
                ids.add(((ActivityDTO)values.get(i)).getStudent_id());
            }
            graphData_en.add(new LabelAndValue(keys[0], (double)ids.size()));
            if (!Language.isSpanish()) continue;
            graphData_es.add(new LabelAndValue(keys[1], (double)ids.size()));
        }
        LinkedHashMap<String, LinkedList<LabelAndValue>> graphData = new LinkedHashMap<String, LinkedList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<LabelAndValue> getLoginAttemptsStudentsHourlySlotWiseData(GetDataDashBoardRequest request) {
        return this.getLoginAttemptsStudentsHourlySlotWise(request);
    }

    public LinkedList<LabelAndValue> getLoginAttemptsStudentsHourlySlotWise(GetDataDashBoardRequest request) {
        SimpleDateFormat dateFormat = DateUtils.getSimpleDateFormatWithPatternAndZonedDateTime((String)"HH:mm", (ZonedDateTime)request.getZonedDateTime());
        List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities, Language.getLanguage());
        ArrayList allActivites = new ArrayList();
        for (Object keys : activitiesMap.keySet()) {
            allActivites.addAll((Collection)activitiesMap.get(keys));
        }
        for (int i = 0; i < allActivites.size(); ++i) {
            Object keys;
            keys = (ActivityDTO)allActivites.get(i);
        }
        LinkedHashMap hourlyTimeSloteMap = this.get24HourlyTimeSlots();
        for (String key : hourlyTimeSloteMap.keySet()) {
            ArrayList<ActivityDTO> values = new ArrayList<ActivityDTO>();
            for (int i = 0; i < allActivites.size(); ++i) {
                ActivityDTO value = (ActivityDTO)allActivites.get(i);
                if (!this.activitiesInTimeSlote(dateFormat, key, value).booleanValue()) continue;
                values.add(value);
            }
            hourlyTimeSloteMap.put(key, values);
        }
        LinkedList<LabelAndValue> graphData = new LinkedList<LabelAndValue>();
        for (String key24hourKey : hourlyTimeSloteMap.keySet()) {
            String key12hourKey = this.convert24HourlyTimeSlotsKeyTo12HourlyTimeSlotsKey(key24hourKey);
            graphData.add(new LabelAndValue(key12hourKey, (double)((List)hourlyTimeSloteMap.get(key24hourKey)).size()));
        }
        return graphData;
    }

    private LinkedHashMap<String, List<ActivityDTO>> get24HourlyTimeSlots() {
        LinkedHashMap<String, List<ActivityDTO>> timeSloteMap = new LinkedHashMap<String, List<ActivityDTO>>();
        timeSloteMap.put("00:00-01:00", new ArrayList());
        timeSloteMap.put("01:00-02:00", new ArrayList());
        timeSloteMap.put("02:00-03:00", new ArrayList());
        timeSloteMap.put("03:00-04:00", new ArrayList());
        timeSloteMap.put("04:00-05:00", new ArrayList());
        timeSloteMap.put("05:00-06:00", new ArrayList());
        timeSloteMap.put("06:00-07:00", new ArrayList());
        timeSloteMap.put("07:00-08:00", new ArrayList());
        timeSloteMap.put("08:00-09:00", new ArrayList());
        timeSloteMap.put("09:00-10:00", new ArrayList());
        timeSloteMap.put("10:00-11:00", new ArrayList());
        timeSloteMap.put("11:00-12:00", new ArrayList());
        timeSloteMap.put("12:00-13:00", new ArrayList());
        timeSloteMap.put("13:00-14:00", new ArrayList());
        timeSloteMap.put("14:00-15:00", new ArrayList());
        timeSloteMap.put("15:00-16:00", new ArrayList());
        timeSloteMap.put("16:00-17:00", new ArrayList());
        timeSloteMap.put("17:00-18:00", new ArrayList());
        timeSloteMap.put("18:00-19:00", new ArrayList());
        timeSloteMap.put("19:00-20:00", new ArrayList());
        timeSloteMap.put("20:00-21:00", new ArrayList());
        timeSloteMap.put("21:00-22:00", new ArrayList());
        timeSloteMap.put("22:00-23:00", new ArrayList());
        timeSloteMap.put("23:00-00:00", new ArrayList());
        return timeSloteMap;
    }

    private String convert24HourlyTimeSlotsKeyTo12HourlyTimeSlotsKey(String key24HourlyTimeSlots) {
        switch (key24HourlyTimeSlots) {
            case "00:00-01:00": {
                return "12:00-01:00 AM";
            }
            case "01:00-02:00": {
                return "01:00-02:00 AM";
            }
            case "02:00-03:00": {
                return "02:00-03:00 AM";
            }
            case "03:00-04:00": {
                return "03:00-04:00 AM";
            }
            case "04:00-05:00": {
                return "04:00-05:00 AM";
            }
            case "05:00-06:00": {
                return "05:00-06:00 AM";
            }
            case "06:00-07:00": {
                return "06:00-07:00 AM";
            }
            case "07:00-08:00": {
                return "07:00-08:00 AM";
            }
            case "08:00-09:00": {
                return "08:00-09:00 AM";
            }
            case "09:00-10:00": {
                return "09:00-10:00 AM";
            }
            case "10:00-11:00": {
                return "10:00-11:00 AM";
            }
            case "11:00-12:00": {
                return "11:00-12:00 AM";
            }
            case "12:00-13:00": {
                return "12:00-01:00 PM";
            }
            case "13:00-14:00": {
                return "01:00-02:00 PM";
            }
            case "14:00-15:00": {
                return "02:00-03:00 PM";
            }
            case "15:00-16:00": {
                return "03:00-04:00 PM";
            }
            case "16:00-17:00": {
                return "04:00-05:00 PM";
            }
            case "17:00-18:00": {
                return "05:00-06:00 PM";
            }
            case "18:00-19:00": {
                return "06:00-07:00 PM";
            }
            case "19:00-20:00": {
                return "07:00-08:00 PM";
            }
            case "20:00-21:00": {
                return "08:00-09:00 PM";
            }
            case "21:00-22:00": {
                return "09:00-10:00 PM";
            }
            case "22:00-23:00": {
                return "10:00-11:00 PM";
            }
            case "23:00-00:00": {
                return "11:00-12:00 PM";
            }
        }
        return "";
    }

    private Boolean activitiesInTimeSlote(SimpleDateFormat dateFormat, String timeSlote, ActivityDTO activity) {
        try {
            String[] parts = timeSlote.split("-");
            String string1 = parts[0];
            Date time1 = dateFormat.parse(string1);
            Calendar calendar1 = Calendar.getInstance();
            calendar1.setTime(time1);
            calendar1.add(5, 1);
            String string2 = parts[1];
            Date time2 = dateFormat.parse(string2);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(time2);
            if (string1.equals("23:00")) {
                calendar2.add(5, 2);
            } else {
                calendar2.add(5, 1);
            }
            String activityTime = dateFormat.format(activity.getStart_date_time());
            Date d = dateFormat.parse(activityTime);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(d);
            calendar3.add(5, 1);
            Date x = calendar3.getTime();
            if (x.after(calendar1.getTime()) && x.before(calendar2.getTime())) {
                return true;
            }
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object getLoginAttemptsTeachersData(GetDataDashBoardRequest request) {
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                LinkedHashMap values = this.getLoginAttemptsTeachers(getDataDashBoardRequest);
                graphData_en.put(gradeView.getGrade_name(), values.get("en"));
                if (!Language.isSpanish()) continue;
                graphData_es.put(gradeView.getGrade_name_es(), values.get("es"));
            }
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<LabelAndValue>> getLoginAttemptsTeachers(GetDataDashBoardRequest request) {
        List activities = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities, Language.getLanguage());
        LinkedList<LabelAndValue> graphData_en = new LinkedList<LabelAndValue>();
        LinkedList<LabelAndValue> graphData_es = new LinkedList<LabelAndValue>();
        for (String[] keys : activitiesMap.keySet()) {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
            List values = (List)activitiesMap.get(keys);
            for (int i = 0; i < values.size(); ++i) {
                ids.add(((ActivityDTO)values.get(i)).getInstructor_id());
            }
            graphData_en.add(new LabelAndValue(keys[0], (double)ids.size()));
            if (!Language.isSpanish()) continue;
            graphData_es.add(new LabelAndValue(keys[1], (double)ids.size()));
        }
        LinkedHashMap<String, LinkedList<LabelAndValue>> graphData = new LinkedHashMap<String, LinkedList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getLoginAttemptsTeachersHourlySlotWiseData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList> graphData_en = new LinkedHashMap<String, LinkedList>();
        LinkedHashMap graphData_es = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                graphData_en.put(gradeView.getGrade_name(), this.getLogiAttemptsTeachersHourlySlotWise(getDataDashBoardRequest));
                graphData_es.put(gradeView.getGrade_name_es(), graphData_en.get(gradeView.getGrade_name()));
            }
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedList<LabelAndValue> getLogiAttemptsTeachersHourlySlotWise(GetDataDashBoardRequest request) {
        SimpleDateFormat dateFormat = DateUtils.getSimpleDateFormatWithPatternAndZonedDateTime((String)"HH:mm", (ZonedDateTime)request.getZonedDateTime());
        List activities = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities, Language.getLanguage());
        ArrayList allActivites = new ArrayList();
        for (String[] keys : activitiesMap.keySet()) {
            allActivites.addAll((Collection)activitiesMap.get(keys));
        }
        for (int i = 0; i < allActivites.size(); ++i) {
            ActivityDTO value = (ActivityDTO)allActivites.get(i);
            System.out.println(value.getActivity_id() + " StartDate " + DateUtils.dayWitTimeFormat.format(value.getStart_date_time()) + " End Date " + DateUtils.dayWitTimeFormat.format(value.getEnd_date_time()));
        }
        LinkedHashMap hourlyTimeSloteMap = this.get24HourlyTimeSlots();
        for (String key : hourlyTimeSloteMap.keySet()) {
            System.out.println(key);
            ArrayList<ActivityDTO> values = new ArrayList<ActivityDTO>();
            for (int i = 0; i < allActivites.size(); ++i) {
                ActivityDTO value = (ActivityDTO)allActivites.get(i);
                if (!this.activitiesInTimeSlote(dateFormat, key, value).booleanValue()) continue;
                values.add(value);
                System.out.println("StartDate " + DateUtils.dayWitTimeFormat.format(value.getStart_date_time()) + " End Date " + DateUtils.dayWitTimeFormat.format(value.getEnd_date_time()));
            }
            hourlyTimeSloteMap.put(key, values);
        }
        LinkedList<LabelAndValue> graphData = new LinkedList<LabelAndValue>();
        for (String key24hourKey : hourlyTimeSloteMap.keySet()) {
            String key12hourKey = this.convert24HourlyTimeSlotsKeyTo12HourlyTimeSlotsKey(key24hourKey);
            graphData.add(new LabelAndValue(key12hourKey, (double)((List)hourlyTimeSloteMap.get(key24hourKey)).size()));
        }
        return graphData;
    }

    public Object getAverageLoginAttemptTeachers(GetDataDashBoardRequest request) {
        long account_id;
        AccountView accountView;
        System.out.println("------------------------------User Stats's Average Login Attempts - Teachers --------------------------------");
        List instructorViews = this.instructorRepository.findAllInstructorIdOrderById();
        System.out.println("Instructors - " + instructorViews.size());
        Date firstInstructorCreatedDate = new Date();
        if (AppUtils.isNullOrEmpty((List)instructorViews) && (accountView = this.accountRepository.findAccountViewByAccountId(Long.valueOf(account_id = ((InstructorView)instructorViews.get(0)).getAccount_id().longValue()))) != null && accountView.getCreatedAt() != null) {
            firstInstructorCreatedDate = accountView.getCreatedAt();
        }
        Date fromDate = AppUtils.isNullOrEmpty((List)instructorViews) ? DateUtils.setTimeToFromDate((Date)new Date()) : firstInstructorCreatedDate;
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap grades_es = new LinkedHashMap();
            for (Long grade_id : request.getGradeIds()) {
                Grade grade = (Grade)this.gradeRepository.getOne((Object)grade_id);
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades_en.put(grade.getGrade_name(), this.getAverageLoginAttemptTeachers(getDataDashBoardRequest, fromDate, toDate, getDataDashBoardRequest.getTimeZone()));
                grades_es.put(grade.getGrade_name_es(), grades_en.get(grade.getGrade_name()));
            }
            graphData_en.put("Grade", grades_en);
            graphData_es.put("Grado", grades_es);
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<Object> getAverageLoginAttemptTeachers(GetDataDashBoardRequest request, Date fromDate, Date toDate, TimeZone timeZone) {
        List activities = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedList<Object> reportings = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)activities)) {
            Double size = activities.size();
            System.out.println("Instructor List Size - " + size + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public Object getPercentageByGrades(GetDataDashBoardRequest request) {
        LinkedHashMap countAndAvgMap_en = new LinkedHashMap();
        LinkedHashMap countAndAvgMap_es = new LinkedHashMap();
        Double totalCount = 0.0;
        for (int i = 0; i < request.getGradeIds().size(); ++i) {
            Long grade_id = (Long)request.getGradeIds().get(i);
            GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
            GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().add(grade_id);
            long count = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)).size();
            totalCount = totalCount + (double)count;
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap_en.put(gradeView.getGrade_name(), list);
            countAndAvgMap_es.put(gradeView.getGrade_name_es(), countAndAvgMap_en.get(gradeView.getGrade_name()));
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap_en, (Double)totalCount);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        graphData.put("en", countAndAvgMap_en);
        if (Language.isSpanish()) {
            graphData.put("es", countAndAvgMap_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        getDataDashBoardRequest.setZonedDateTime(request.getZonedDateTime());
        getDataDashBoardRequest.setTimeZone(request.getTimeZone());
        return getDataDashBoardRequest;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByOSForStudent(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        String fromDate = DateUtils.getDateInString((Date)request.getFromDate());
        String toDate = DateUtils.getDateInString((Date)request.getToDate());
        List studentsCountAndPercentageByOS = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.studentRepository.getStudentCountAndPercentageByUseOfOSCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.studentRepository.getStudentCountAndPercentageByUseOfOS();
        for (int i = 0; i < studentsCountAndPercentageByOS.size(); ++i) {
            Object[] studentCountAndPercentageByOS = (Object[])studentsCountAndPercentageByOS.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(studentCountAndPercentageByOS[1]);
            list.add(studentCountAndPercentageByOS[2]);
            countAndAvgMap.put(studentCountAndPercentageByOS[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByBrowserForStudent(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        String fromDate = DateUtils.getDateInString((Date)request.getFromDate());
        String toDate = DateUtils.getDateInString((Date)request.getToDate());
        List studentsCountAndPercentageByBrowser = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.studentRepository.getStudentCountAndPercentageByUseOfBrowserCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.studentRepository.getStudentCountAndPercentageByUseOfBrowser();
        for (int i = 0; i < studentsCountAndPercentageByBrowser.size(); ++i) {
            Object[] studentCountAndPercentageByBrowser = (Object[])studentsCountAndPercentageByBrowser.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(studentCountAndPercentageByBrowser[1]);
            list.add(studentCountAndPercentageByBrowser[2]);
            countAndAvgMap.put(studentCountAndPercentageByBrowser[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByOSForInstructor(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        String fromDate = DateUtils.getDateInString((Date)request.getFromDate());
        String toDate = DateUtils.getDateInString((Date)request.getToDate());
        List instructorsCountAndPercentageByOS = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.instructorRepository.getInstructorCountAndPercentageByUseOfOSCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.instructorRepository.getInstructorCountAndPercentageByUseOfOS();
        for (int i = 0; i < instructorsCountAndPercentageByOS.size(); ++i) {
            Object[] instructorCountAndPercentageByOS = (Object[])instructorsCountAndPercentageByOS.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(instructorCountAndPercentageByOS[1]);
            list.add(instructorCountAndPercentageByOS[2]);
            countAndAvgMap.put(instructorCountAndPercentageByOS[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByBrowserForInstructor(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        String fromDate = DateUtils.getDateInString((Date)request.getFromDate());
        String toDate = DateUtils.getDateInString((Date)request.getToDate());
        List instructorsCountAndPercentageByBrowser = AppUtils.isNotNullOrEmpty((String)fromDate) && AppUtils.isNotNullOrEmpty((String)toDate) ? this.instructorRepository.getInstructorCountAndPercentageByUseOfBrowserCreatedAtBetweenFromDateAndToDate(fromDate, toDate) : this.instructorRepository.getInstructorCountAndPercentageByUseOfBrowser();
        for (int i = 0; i < instructorsCountAndPercentageByBrowser.size(); ++i) {
            Object[] instructorCountAndPercentageByBrowser = (Object[])instructorsCountAndPercentageByBrowser.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(instructorCountAndPercentageByBrowser[1]);
            list.add(instructorCountAndPercentageByBrowser[2]);
            countAndAvgMap.put(instructorCountAndPercentageByBrowser[0].toString(), list);
        }
        return countAndAvgMap;
    }
}

