/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dailyappreciation.service;

import com.infinite.focus.server.dailyappreciation.dto.DailyAppreciationDTO;
import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationCoreRepository;
import com.infinite.focus.server.dailyappreciation.service.DailyAppreciationService;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DailyAppreciationServiceImpl
implements DailyAppreciationService {
    private final DailyAppreciationCoreRepository dailyAppreciationCoreRepository;

    public DailyAppreciationServiceImpl(DailyAppreciationCoreRepository dailyAppreciationCoreRepository) {
        this.dailyAppreciationCoreRepository = dailyAppreciationCoreRepository;
    }

    public Page<DailyAppreciationDTO> getByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.dailyAppreciationCoreRepository.findPageByStudentId(student_id, (Pageable)paging);
        return new PageImpl(pagedResult.stream().peek(dailyAppreciation -> dailyAppreciation.setAppreciation_image(this.getAppreciationImageByAppreciationText(dailyAppreciation.getText()))).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
    }

    public String getAppreciationImageByAppreciationText(String appreciationItem) {
        String appreciation_images_path = "/images/appreciation_images/";
        switch (appreciationItem) {
            case "Family": {
                return appreciation_images_path + "Family.png";
            }
            case "Friends": {
                return appreciation_images_path + "Friends.png";
            }
            case "School": {
                return appreciation_images_path + "School.png";
            }
            case "Me": {
                return appreciation_images_path + "Me.png";
            }
            case "My Teacher": 
            case "A Teacher": {
                return appreciation_images_path + "MyTeacher.png";
            }
            case "My Pets": {
                return appreciation_images_path + "MyPets.png";
            }
            case "Technology": 
            case "Math": {
                return appreciation_images_path + "Technology.png";
            }
            case "Music": {
                return appreciation_images_path + "Music.png";
            }
            case "Art": {
                return appreciation_images_path + "Art.png";
            }
        }
        return "";
    }
}

