/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.invoice.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.entity.InvoiceItem;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.invoice.request.CreateInvoiceRequest;
import com.infinite.focus.server.invoice.request.GetInvoicesRequest;
import com.infinite.focus.server.invoice.request.MarkAsPaidRequest;
import com.infinite.focus.server.invoice.response.GetInvoicePdfLinkResponse;
import com.infinite.focus.server.invoice.service.InvoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.stripe.exception.SignatureVerificationException;
import com.stripe.model.Customer;
import com.stripe.model.Event;
import com.stripe.model.EventDataObjectDeserializer;
import com.stripe.model.StripeObject;
import com.stripe.net.Webhook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/invoice"})
public class InvoiceController {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    AuthService authService;
    @Autowired
    InvoiceService invoiceService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/get/invoices"})
    @ResponseBody
    public ResponseEntity<Page<InvoiceItem>> getInvoices(@RequestHeader(value="Authorization") String token, @RequestBody GetInvoicesRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.invoiceService.getInvoices(request), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/create-invoice-for-new-organization"})
    @ResponseBody
    public ResponseEntity<Invoice> createInvoiceForNewOrganization(@RequestHeader(value="Authorization") String token, @RequestBody CreateInvoiceRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.invoiceService.createInvoiceForNewOrganization(request.getNumber_of_youth(), request.getAmount(), request.getName_of_organization(), request.getOrganization_type(), request.getEmail_to_send_invoice(), InvoiceType.NEW), HttpStatus.OK);
    }

    @PostMapping(value={"/create-invoice-for-increasing-youth-capacity"})
    @ResponseBody
    public ResponseEntity<Invoice> createInvoiceForIncreasingYouthCapacity(@RequestHeader(value="Authorization") String token, @RequestBody CreateInvoiceRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.invoiceService.createInvoiceForIncreasingYouthCapacity(request.getNumber_of_youth(), request.getAmount(), request.getOrganization_id(), request.getOrganization_type(), request.getEmail_to_send_invoice()), HttpStatus.OK);
    }

    @PostMapping(value={"/create-invoice-for-subscription-renewal"})
    @ResponseBody
    public ResponseEntity<Invoice> createInvoiceForSubscriptionRenewal(@RequestHeader(value="Authorization") String token, @RequestBody CreateInvoiceRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.invoiceService.createInvoiceForSubscriptionRenewal(request.getAmount(), request.getOrganization_id(), request.getOrganization_type(), request.getEmail_to_send_invoice()), HttpStatus.OK);
    }

    @PostMapping(value={"/mark-as-paid"})
    @ResponseBody
    public ResponseEntity<Invoice> markAsPaid(@RequestHeader(value="Authorization") String token, @RequestBody MarkAsPaidRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.invoiceService.markAsPaid(request), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @RequestMapping(value={"/webhook"}, method={RequestMethod.POST})
    public ResponseEntity<String> webhook(@RequestBody String payload, @RequestHeader(value="Stripe-Signature") String sigHeader) {
        System.out.println("Stripe-Signature " + sigHeader);
        Event event = null;
        try {
            event = Webhook.constructEvent((String)payload, (String)sigHeader, (String)this.configurationService.getStripeSignature());
        }
        catch (SignatureVerificationException e) {
            System.out.println("Failed signature verification");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
        EventDataObjectDeserializer dataObjectDeserializer = event.getDataObjectDeserializer();
        StripeObject stripeObject = null;
        if (dataObjectDeserializer.getObject().isPresent()) {
            stripeObject = (StripeObject)dataObjectDeserializer.getObject().get();
        }
        switch (event.getType()) {
            case "customer.created": {
                System.out.println("webhook - customer.created");
                Customer customer = (Customer)stripeObject;
                System.out.println(customer);
                break;
            }
            case "payment_intent.succeeded": {
                break;
            }
            case "payment_method.attached": {
                break;
            }
            case "invoice.created": {
                System.out.println("webhook - invoice.created");
                break;
            }
            case "invoice.deleted": {
                System.out.println("webhook - invoice.deleted");
                break;
            }
            case "invoice.finalization_failed": {
                break;
            }
            case "invoice.finalized": {
                System.out.println("webhook - invoice.finalized");
                break;
            }
            case "invoice.marked_uncollectible": {
                break;
            }
            case "invoice.paid": {
                System.out.println("webhook - invoice.paid");
                this.invoiceService.invoicePaid(stripeObject);
                break;
            }
            case "invoice.payment_action_required": {
                break;
            }
            case "invoice.payment_failed": {
                break;
            }
            case "invoice.payment_succeeded": {
                System.out.println("webhook - invoice.payment_succeeded");
                break;
            }
            case "invoice.sent": {
                break;
            }
            case "invoice.upcoming": {
                break;
            }
            case "invoice.updated": {
                break;
            }
            case "invoice.voided": {
                break;
            }
            case "invoiceitem.created": {
                break;
            }
            case "invoiceitem.deleted": {
                break;
            }
            case "invoiceitem.updated": {
                break;
            }
            default: {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
            }
        }
        return new ResponseEntity((Object)this.messageService.getMessage("success"), HttpStatus.OK);
    }

    @PostMapping(value={"/resend-invoice"})
    @ResponseBody
    public ResponseEntity<Message> resendInvoice(@RequestHeader(value="Authorization") String token, @RequestBody MarkAsPaidRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.invoiceService.resendInvoice(request.getInvoice_id()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/send-license-key"})
    @ResponseBody
    public ResponseEntity<Message> sendLicenseKey(@RequestHeader(value="Authorization") String token, @RequestBody MarkAsPaidRequest request) {
        this.authService.isAdmin(token);
        Invoice invoice = this.invoiceService.getInvoiceByInvoiceId(request.getInvoice_id());
        if (invoice == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found.in.db"));
        }
        this.invoiceService.sendLicenseKeyEmail(invoice);
        return new ResponseEntity((Object)new Message(this.messageService.getMessage("license.key.sent.successfully")), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/delete-invoice"})
    @ResponseBody
    public ResponseEntity<Message> deleteInvoice(@RequestHeader(value="Authorization") String token, @RequestBody MarkAsPaidRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.invoiceService.deleteInvoice(request.getInvoice_id()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/invoice/pdf/link"})
    @ResponseBody
    public ResponseEntity<GetInvoicePdfLinkResponse> getInvoicePdfLink(@RequestHeader(value="Authorization") String token, @RequestBody MarkAsPaidRequest request) {
        this.authService.isAdmin(token);
        Invoice invoice = this.invoiceService.getInvoiceByInvoiceId(request.getInvoice_id());
        if (invoice == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found.in.db"));
        }
        String invoicePdfLink = this.invoiceService.getInvoicePdfLink(invoice);
        return new ResponseEntity((Object)new GetInvoicePdfLinkResponse(invoicePdfLink), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }
}

