/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.template.controller;

import com.infinite.focus.server.template.request.GetForgotPasswordTemplateRequest;
import com.infinite.focus.server.template.request.GetSOSEmailAskForHelpTemplateRequest;
import com.infinite.focus.server.template.service.TemplateService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/template"})
public class TemplateController {
    private final TemplateService templateService;

    public TemplateController(TemplateService templateService) {
        this.templateService = templateService;
    }

    @PostMapping(value={"/get-sos-email-ask-for-help-template"})
    ResponseEntity<String> getSOSEmailAskForHelpTemplate(@RequestBody GetSOSEmailAskForHelpTemplateRequest request) {
        return new ResponseEntity((Object)this.templateService.getSOSEmailAskForHelpTemplate(request.getStudent_name(), request.getGrade(), request.getLanguage()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-email-ask-for-help-template-with-question-and-answer"})
    ResponseEntity<String> getSOSEmailAskForHelpTemplateWithQuestionAndAnswer(@RequestBody GetSOSEmailAskForHelpTemplateRequest request) {
        return new ResponseEntity((Object)this.templateService.getSOSEmailAskForHelpTemplateWithQuestionAndAnswer(request.getStudent_name(), request.getGrade(), request.getSos_request_id(), request.isParent(), request.getLanguage()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-forgot-password-template"})
    ResponseEntity<String> getForgotPasswordTemplate(@RequestBody GetForgotPasswordTemplateRequest request) {
        return new ResponseEntity((Object)this.templateService.getForgotPasswordEmailText(request.getReset_password_link(), request.getLanguage()), HttpStatus.OK);
    }
}

