/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.grade.service;

import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.service.GradeService;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class GradeServiceImpl
implements GradeService {
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardJPARepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    AccessCodeRepository accessCodeRepository;
    @Autowired
    MessageService messageService;

    public GradeView findByGradeId(long grade_id) {
        return this.gradeRepository.findByGradeId(Long.valueOf(grade_id));
    }

    public GradeView getGradeById(long grade_id) {
        return this.gradeRepository.findByGradeId(Long.valueOf(grade_id));
    }

    public GradeView isValidGrade(long grade_id) {
        GradeView gradeView = this.gradeRepository.findByGradeId(Long.valueOf(grade_id));
        if (gradeView == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("grade.is.not.found"));
        }
        return gradeView;
    }

    public List<GradeView> getGradesOrderByGradeId() {
        return this.gradeRepository.getGradesOrderByGradeId();
    }

    public long getStudentCountByGradeIdAndCreatedAtBetweenFromDateAndToDate(long grade_id, Date fromDate, Date toDate) {
        List standardViews = this.standardRepository.findAllByGradeIdOrderByStandardIdASC(Long.valueOf(grade_id));
        return standardViews.stream().map(standardView -> this.studentRepository.findByStandardId(standardView.getStandard_id())).flatMap(studentViews -> studentViews.stream().filter(studentView -> {
            AccountView accountView = this.accountRepository.findAccountViewByAccountId(studentView.getAccount_id());
            AccessCodeView accessCodeView = this.accessCodeRepository.findAccessCodeViewByStudentId(studentView.getStudent_id());
            return accountView != null && !AppUtils.isNullOrEmpty((String)accountView.getUsername()) && DateUtils.isDateInBetweenFromDateAndToDate((Date)fromDate, (Date)toDate, (Date)accountView.getCreatedAt()) && accessCodeView != null && accessCodeView.getStatus() == Status.ACCEPTED;
        })).count();
    }

    public long getStudentCountByGradeId(long grade_id) {
        List standardViews = this.standardRepository.findAllByGradeIdOrderByStandardIdASC(Long.valueOf(grade_id));
        return standardViews.stream().map(standardView -> this.studentRepository.findByStandardId(standardView.getStandard_id())).flatMap(studentViews -> studentViews.stream().filter(studentView -> {
            AccountView accountView = this.accountRepository.findAccountViewByAccountId(studentView.getAccount_id());
            AccessCodeView accessCodeView = this.accessCodeRepository.findAccessCodeViewByStudentId(studentView.getStudent_id());
            return accountView != null && !AppUtils.isNullOrEmpty((String)accountView.getUsername()) && accessCodeView != null && accessCodeView.getStatus() == Status.ACCEPTED;
        })).count();
    }
}

