/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.repository;

import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.school.dto.SchoolDTO;
import com.infinite.focus.server.school.repository.SchoolCoreRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SchoolCoreRepositoryImpl
implements SchoolCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public SchoolCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static SchoolDTO mapRow(ResultSet rs, int i) throws SQLException {
        String focus_on = rs.getString("focus_on");
        return SchoolDTO.builder().school_id(rs.getLong("school_id")).account_id(rs.getLong("account_id")).address(rs.getString("address")).district_id(rs.getLong("district_id")).school_name(rs.getString("school_name")).registration_code(rs.getString("registration_code")).createdAt((Date)rs.getTimestamp("created_at")).license_key(rs.getString("license_key")).licence_key_expiry_date((Date)rs.getTimestamp("licence_key_expiry_date")).licence_key_added_date((Date)rs.getTimestamp("licence_key_added_date")).active(rs.getBoolean("active")).focus_on(!AppUtils.isNullOrEmpty((String)focus_on) ? FocusOn.valueOf((String)focus_on) : null).deleted(rs.getBoolean("deleted")).number_of_youth(rs.getLong("number_of_youth")).clever_id(rs.getString("clever_id")).last_sync((Date)rs.getTimestamp("last_sync")).sync_progressed(rs.getBoolean("sync_progressed")).auto_approve_wall_posts(rs.getBoolean("auto_approve_wall_posts")).language(rs.getString("language")).enable_journal(rs.getBoolean("enable_journal")).enable_wow(rs.getBoolean("enable_wow")).build();
    }

    public List<SchoolDTO> findAll() {
        String SQL = "SELECT * FROM school s JOIN account a ON s.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' ORDER BY s.school_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, SchoolCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public SchoolDTO findById(long district_id) {
        String SQL = "SELECT * FROM school s WHERE s.school_id = ? ";
        try {
            return (SchoolDTO)this.jdbcTemplate.queryForObject(SQL, SchoolCoreRepositoryImpl::mapRow, new Object[]{district_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SchoolDTO> findAllFromClever() {
        String SQL = "SELECT * FROM school s JOIN account a ON s.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' AND s.clever_id IS NOT NULL AND s.clever_id != '' ORDER BY s.school_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, SchoolCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<Long> findAllIdsFromClever() {
        String SQL = "SELECT DISTINCT(s.school_id) FROM school s JOIN account a ON s.account_id = a.account_id WHERE a.username IS NOT NULL AND a.username != '' AND s.clever_id IS NOT NULL AND s.clever_id != '' ORDER BY s.school_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("school_id"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

