/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosrequest.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestByAskForHelpId;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestByInstructorIdRequest;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestBySchoolIdAndStudentDemographicsRequest;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestNotViewedCountByInstructorIdRequest;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestNotViewedCountBySchoolIdRequest;
import com.infinite.focus.server.sosrequest.request.SubmitSOSRequestRequest;
import com.infinite.focus.server.sosrequest.response.GetSOSRequestNotViewedCountByInstructorIdResponse;
import com.infinite.focus.server.sosrequest.response.GetSOSRequestNotViewedCountBySchoolIdResponse;
import com.infinite.focus.server.sosrequest.service.SOSRequestService;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestForInstructorWrapper;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestWrapper;
import com.infinite.focus.server.student.entity.Student;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sos-request"})
public class SOSRequestController {
    private final AuthService authService;
    private final SOSRequestService sosRequestService;

    public SOSRequestController(AuthService authService, SOSRequestService sosRequestService) {
        this.authService = authService;
        this.sosRequestService = sosRequestService;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<SOSRequestWrapper> create(@RequestHeader(value="Authorization") String token, @RequestBody SubmitSOSRequestRequest request) {
        String language = LocaleContextHolder.getLocale().getLanguage();
        System.out.println(language);
        Student student = this.authService.isStudent(token);
        SOSRequestWrapper sosRequestWrapper = this.sosRequestService.create(request.getStudent_id(), request.getMood_update_id(), request.getAnswers());
        this.sosRequestService.sendSOSNotification(student.getStudent_id());
        if (student.getInstructor() != null) {
            this.sosRequestService.setSOSEmailToInstructor(student.getInstructor().getAccount_id(), student.getFirst_name() + " " + student.getLast_name(), student.getStandard().getStandard_name(), sosRequestWrapper.getRequest().getSos_request_id(), language);
        }
        if (student.getParent() != null) {
            this.sosRequestService.setSOSEmailToParent(student.getParent().getAccount_id(), student.getParent().getEmail(), student.getFirst_name() + " " + student.getLast_name(), student.getStandard().getStandard_name(), sosRequestWrapper.getRequest().getSos_request_id(), language);
        }
        this.sosRequestService.setSOSEmailToOrganization(student.getSchool().getAccount_id(), student.getFirst_name() + " " + student.getLast_name(), student.getStandard().getStandard_name(), sosRequestWrapper.getRequest().getSos_request_id(), language);
        return new ResponseEntity((Object)sosRequestWrapper, HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-sos-request-by-ask-for-help-id"})
    public ResponseEntity<SOSRequestDTO> getSOSRequestByAskForHelpId(@RequestBody GetSOSRequestByAskForHelpId request) {
        return new ResponseEntity((Object)this.sosRequestService.getSOSRequestByAskForHelpId(request.getAsk_for_help_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-request-not-viewed-count-by-instructor-id"})
    public ResponseEntity<GetSOSRequestNotViewedCountByInstructorIdResponse> getSOSRequestNotViewedCountByInstructorId(@RequestBody GetSOSRequestNotViewedCountByInstructorIdRequest request) {
        return new ResponseEntity((Object)GetSOSRequestNotViewedCountByInstructorIdResponse.builder().sos_request_not_viewed_count(this.sosRequestService.getSOSRequestNotViewedCountByInstructorId(request.getInstructor_id())).build(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-request-not-viewed-count-by-school-id"})
    public ResponseEntity<GetSOSRequestNotViewedCountBySchoolIdResponse> getSOSRequestNotViewedCountBySchoolId(@RequestBody GetSOSRequestNotViewedCountBySchoolIdRequest request) {
        return new ResponseEntity((Object)GetSOSRequestNotViewedCountBySchoolIdResponse.builder().sos_request_not_viewed_count(this.sosRequestService.getSOSRequestNotViewedCountBySchoolId(request.getSchool_id())).build(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-requests-by-instructor-id"})
    public ResponseEntity<Page<SOSRequestForInstructorWrapper>> getSOSRequestByInstructorId(@RequestBody GetSOSRequestByInstructorIdRequest request) {
        return new ResponseEntity((Object)this.sosRequestService.getSOSRequestByInstructorId(request.getInstructor_id(), request.getName(), request.getStudents_ids(), request.getPageNo(), request.getPageSize(), request.getOrderBy(), request.getSortBy(), request.getFromDate(), request.getToDate()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-requests-by-school-id-and-student-demographics"})
    public ResponseEntity<Page<SOSRequestForInstructorWrapper>> getSOSRequestBySchoolIdAndStudentDemographics(@RequestBody GetSOSRequestBySchoolIdAndStudentDemographicsRequest request) {
        return new ResponseEntity((Object)this.sosRequestService.getSOSRequestBySchoolIdAndStudentDemographics(request.getSchool_id(), request.getName(), request.getGenders(), request.getAges(), request.getEthnicity(), request.getGradeIds(), request.getClassIds(), request.getPageNo(), request.getPageSize(), request.getOrderBy(), request.getSortBy(), request.getFromDate(), request.getToDate()), HttpStatus.OK);
    }
}

