/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpvstate.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.studentpvstate.model.LabelAndStrValue;
import com.infinite.focus.server.studentpvstate.request.GetStudentPVStateByTimeLineRequest;
import com.infinite.focus.server.studentpvstate.service.StudentPVStateService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-pv-state"})
public class StudentPVStateController {
    private final AuthService authService;
    private final StudentPVStateService studentPVStateService;

    public StudentPVStateController(AuthService authService, StudentPVStateService studentPVStateService) {
        this.authService = authService;
        this.studentPVStateService = studentPVStateService;
    }

    @PostMapping(value={"/get-by-timeline"})
    ResponseEntity<List<LabelAndStrValue>> getByTimeLine(@RequestHeader(value="Authorization") String token, @RequestBody GetStudentPVStateByTimeLineRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.studentPVStateService.getByTimeLine(request.getStudent_id(), request.getTimeLine(), request.getTimeZone()), (HttpStatusCode)HttpStatus.OK);
    }
}

