/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.assessmentpost.repository;

import com.infinite.focus.server.assessmentpost.repository.AssessmentPostRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AssessmentPostRepositoryImpl
implements AssessmentPostRepository {
    private final JdbcTemplate jdbcTemplate;

    public AssessmentPostRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void createAssessmentPostTable() {
        String SQL = "CREATE TABLE IF NOT EXISTS assessment_post(assessment_id bigint not null, post_id bigint not null )";
        this.jdbcTemplate.execute(SQL);
    }

    public void create(long assessment_id, Set<Long> post_ids) {
        if (!AppUtils.isNullOrEmpty(post_ids)) {
            this.deleteByAssessmentId(assessment_id);
            String INSERT_SQL = "INSERT INTO assessment_post (  assessment_id, post_id ) VALUES (?,?)";
            ArrayList arrayList = (ArrayList)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO assessment_post (  assessment_id, post_id ) VALUES (?,?)", 1), ps -> {
                Iterator iterator = post_ids.iterator();
                while (iterator.hasNext()) {
                    long post_id = (Long)iterator.next();
                    ps.setLong(1, assessment_id);
                    ps.setLong(2, post_id);
                    ps.addBatch();
                }
                ps.executeBatch();
                ResultSet resultSet = ps.getGeneratedKeys();
                ArrayList<Long> ids = new ArrayList<Long>();
                while (resultSet.next()) {
                    ids.add(resultSet.getLong(1));
                }
                return ids;
            });
        }
    }

    public void deleteByAssessmentId(long assessment_id) {
        String SQL = "DELETE FROM assessment_post WHERE assessment_id = ? ";
        try {
            this.jdbcTemplate.update(SQL, new Object[]{assessment_id});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

