/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporatenotification.service;

import com.infinite.focus.server.client.CorporateClient;
import com.infinite.focus.server.client.PushNotificationClient;
import com.infinite.focus.server.corporate.request.SetNewNotificationsForCorporateRequest;
import com.infinite.focus.server.corporatenotification.entity.CorporateNotification;
import com.infinite.focus.server.corporatenotification.repository.CorporateNotificationCoreRepository;
import com.infinite.focus.server.corporatenotification.repository.CorporateNotificationRepository;
import com.infinite.focus.server.corporatenotification.service.CorporateNotificationService;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class CorporateNotificationServiceImpl
implements CorporateNotificationService {
    private final PushNotificationClient pushNotificationClient;
    private final CorporateNotificationCoreRepository corporateNotificationCoreRepository;
    private final CorporateNotificationRepository corporateNotificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final CorporateClient corporateClient;

    public CorporateNotificationServiceImpl(PushNotificationClient pushNotificationClient, CorporateNotificationCoreRepository corporateNotificationCoreRepository, CorporateNotificationRepository corporateNotificationRepository, RealTimeMessageService realTimeMessageService, CorporateClient corporateClient) {
        this.pushNotificationClient = pushNotificationClient;
        this.corporateNotificationCoreRepository = corporateNotificationCoreRepository;
        this.corporateNotificationRepository = corporateNotificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.corporateClient = corporateClient;
    }

    public Page<CorporateNotification> getCorporateNotificationsByCorporateId(Long corporate_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate) {
        return this.corporateNotificationCoreRepository.getCorporateNotificationsByCorporateId(corporate_id, pageNo, pageSize, sortBy, orderBy, fromDate, toDate);
    }

    public void addNotificationByCorporateId(Map<Long, Long> corporate_ids_and_account_ids, String text, String text_es) {
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        for (long corporate_id : corporate_ids_and_account_ids.keySet()) {
            CorporateNotification corporateNotification = new CorporateNotification();
            corporateNotification.setCorporate_id(corporate_id);
            corporateNotification.setText(text);
            corporateNotification.setText_es(text_es);
            corporateNotification.setCreatedAt(new Date());
            this.corporateNotificationRepository.save((Object)corporateNotification);
            this.corporateClient.setNewNotifications(SetNewNotificationsForCorporateRequest.builder().corporate_id(corporate_id).new_notifications(true).build());
            String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + text + "\",\"message_es\":\"" + text_es + "\"}";
            this.realTimeMessageService.sendMessage(corporate_id, json_message);
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).notification_id(corporateNotification.getCorporate_id()).account_id(corporate_ids_and_account_ids.get(corporate_id).longValue()).title(corporateNotification.getText()).title_es(corporateNotification.getText_es()).message(corporateNotification.getText()).message_es(corporateNotification.getText_es()).createdAt(corporateNotification.getCreatedAt()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
        }
        try {
            this.pushNotificationClient.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

