/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.invoice.repository;

import com.infinite.focus.server.invoice.dto.InvoiceItemDTO;
import com.infinite.focus.server.invoice.repository.InvoiceCoreRepository;
import com.infinite.focus.server.invoice.request.GetInvoicesRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class InvoiceCoreRepositoryImpl
implements InvoiceCoreRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    String INVOICE_ITEM = "SELECT UUID() AS uuid,\n       invoice_id,\n       organization_type,\n       invoice_type,\n       CASE\n           WHEN (invoice_type = 'NEW' AND invoice_status = 'PENDING') OR organization_id = 0 THEN name_of_organization\n           WHEN organization_type = 'LARGE_ORGANIZATION' THEN (SELECT district_name FROM district WHERE district_id = invo.organization_id)\n           WHEN organization_type = 'ORGANIZATION' THEN (SELECT school_name FROM school WHERE school_id = invo.organization_id)\n           WHEN organization_type = 'CORPORATE' THEN (SELECT corporate_name FROM corporate WHERE corporate_id = invo.organization_id)\n       END AS name_of_organization,\n       stripe_invoice_id AS invoice,\n       stripe_customer_email AS customer,\n       number_of_youth,\n       amount,\n       license_key,\n       created_at,\n       updated_at,\n       CASE\n           WHEN invoice_status = 'PENDING' THEN 'Pending'\n           WHEN invoice_status = 'PAID' THEN 'Paid'\n           WHEN invoice_status = 'VOID' THEN 'Void'\n       END AS status\nFROM invoice invo\n";

    public InvoiceCoreRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<InvoiceItemDTO> getInvoices(GetInvoicesRequest request) {
        StringBuilder sql = new StringBuilder("SELECT * FROM (").append(this.INVOICE_ITEM).append(") AS invo WHERE ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM (").append(this.INVOICE_ITEM).append(") AS invo WHERE ");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<String> conditions = new ArrayList<String>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            conditions.add("LOWER(invo.name_of_organization) LIKE :name_of_organization");
            parameters.addValue("name_of_organization", (Object)("%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getInvoice())) {
            conditions.add("LOWER(invo.invoice) LIKE :invoice");
            parameters.addValue("invoice", (Object)("%" + request.getInvoice().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getCustomer())) {
            conditions.add("LOWER(invo.customer) LIKE :customer");
            parameters.addValue("customer", (Object)("%" + request.getCustomer().toLowerCase() + "%"));
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            conditions.add("invo.created_at BETWEEN :from_date AND :to_date");
            parameters.addValue("from_date", (Object)request.getFromDate());
            parameters.addValue("to_date", (Object)request.getToDate());
        }
        sql.append(String.join((CharSequence)" AND ", conditions));
        countSql.append(String.join((CharSequence)" AND ", conditions));
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        parameters.addValue("limit", (Object)pageable.getPageSize());
        parameters.addValue("offset", (Object)pageable.getOffset());
        List result = this.namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)parameters, (rs, i) -> {
            InvoiceItemDTO invoiceItemDTO = new InvoiceItemDTO();
            invoiceItemDTO.setUuid(UUID.fromString(rs.getString("uuid")));
            invoiceItemDTO.setInvoice_id(rs.getLong("invoice_id"));
            invoiceItemDTO.setName_of_organization(rs.getString("name_of_organization"));
            invoiceItemDTO.setInvoice_type(rs.getString("invoice_type"));
            invoiceItemDTO.setOrganization_type(rs.getString("organization_type"));
            invoiceItemDTO.setAmount(rs.getDouble("amount"));
            invoiceItemDTO.setLicense_key(rs.getString("license_key"));
            invoiceItemDTO.setNumber_of_youth(rs.getInt("number_of_youth"));
            invoiceItemDTO.setInvoice(rs.getString("invoice"));
            invoiceItemDTO.setCustomer(rs.getString("customer"));
            invoiceItemDTO.setStatus(rs.getString("status"));
            invoiceItemDTO.setCreatedAt((Date)rs.getTimestamp("created_at"));
            invoiceItemDTO.setUpdatedAt((Date)rs.getTimestamp("updated_at"));
            return invoiceItemDTO;
        });
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), (SqlParameterSource)parameters, Long.class);
        return new PageImpl(result, (Pageable)pageable, count.longValue());
    }
}

