/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.accesscode.repository;

import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface AccessCodeRepository
extends JpaRepository<AccessCode, Long> {
    public AccessCode findByAccessCode(String var1);

    @Query(value="SELECT * FROM access_code WHERE instructor_id = ?1", nativeQuery=true)
    public Iterable<AccessCode> findByInstructorId(Long var1);

    @Query(value="SELECT * FROM access_code WHERE instructor_id = ?1 and status = ?2", nativeQuery=true)
    public Page<AccessCode> findByInstructorIdAndStatus(Long var1, String var2, Pageable var3);

    @Query(value="SELECT * FROM access_code WHERE student_id = ?1", nativeQuery=true)
    public AccessCode findByStudentId(Long var1);

    @Query(value="SELECT * FROM access_code WHERE student_id = ?1", nativeQuery=true)
    public AccessCodeView findAccessCodeViewByStudentId(Long var1);

    @Query(value="SELECT * FROM access_code WHERE student_id = ?1 and instructor_id = ?2", nativeQuery=true)
    public AccessCode findByStudentIdAndInstructorId(Long var1, Long var2);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM access_code WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE access_code SET instructor_id = ?1 WHERE student_id IN(?2)", nativeQuery=true)
    public void updateUpdateInstructorIdByStudentIds(long var1, List<Long> var3);

    @Transactional
    @Modifying
    @Query(value="UPDATE access_code SET instructor_id = ?1, parent_id = ?2 WHERE student_id = ?3", nativeQuery=true)
    public void updateUpdateInstructorIdAndParentIdByStudentId(long var1, long var3, long var5);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM access_code WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM access_code WHERE access_code_id IN(?1)", nativeQuery=true)
    public List<AccessCode> findByIds(List<Long> var1);
}

