/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.assessment.service;

import com.infinite.focus.server.account.wrapper.AccountDataWrapper;
import com.infinite.focus.server.assessment.dto.AssessmentDTO;
import com.infinite.focus.server.assessment.entity.Assessment;
import com.infinite.focus.server.assessment.model.AssessmentAndStreak;
import com.infinite.focus.server.assessment.model.AssessmentType;
import com.infinite.focus.server.assessment.model.AssessmentWrapper;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.assessment.repository.AssessmentCoreRepository;
import com.infinite.focus.server.assessment.repository.AssessmentRepository;
import com.infinite.focus.server.assessment.service.AssessmentService;
import com.infinite.focus.server.assessment.service.AssessmentServiceImpl;
import com.infinite.focus.server.assessmentcategory.request.CreateAssessmentCategoryRequest;
import com.infinite.focus.server.assessmentpost.request.CreateAssessmentPostRequest;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.client.AssessmentCategoryClient;
import com.infinite.focus.server.client.AssessmentPostClient;
import com.infinite.focus.server.client.DataSetClient;
import com.infinite.focus.server.client.MoodUpdateClient;
import com.infinite.focus.server.client.PVStateClient;
import com.infinite.focus.server.client.RelationshipSkillsUpdateClient;
import com.infinite.focus.server.client.ResponsibleDecisionMakingUpdateClient;
import com.infinite.focus.server.client.SelfManagementUpdateClient;
import com.infinite.focus.server.client.SocialAwarenessUpdateClient;
import com.infinite.focus.server.client.StudentClient;
import com.infinite.focus.server.client.SubMoodAndStandardClient;
import com.infinite.focus.server.compassdashboard.request.AssessmentRequest;
import com.infinite.focus.server.compassdashboard.request.GetTravelLogForStudentRequest;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.dataset.request.GetPVStatesByDataSetIdsRequest;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.service.MoodService;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByIdRequest;
import com.infinite.focus.server.moodupdate.service.MoodUpdateService;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.service.PostService;
import com.infinite.focus.server.pvstate.dto.PVStateDTO;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.pvstate.request.GetAvgPVStateByPVStatesRequest;
import com.infinite.focus.server.relationshipskills.dto.RelationshipSkillsUpdateDTO;
import com.infinite.focus.server.relationshipskills.entity.RelationshipSkillsUpdate;
import com.infinite.focus.server.relationshipskills.request.GetByRelationshipSkillsUpdateIdRequest;
import com.infinite.focus.server.relationshipskills.service.RelationshipSkillsUpdateService;
import com.infinite.focus.server.responsibledecisionmaking.dto.ResponsibleDecisionMakingUpdateDTO;
import com.infinite.focus.server.responsibledecisionmaking.entity.ResponsibleDecisionMakingUpdate;
import com.infinite.focus.server.responsibledecisionmaking.request.GetByResponsibleDecisionMakingUpdateIdRequest;
import com.infinite.focus.server.responsibledecisionmaking.service.ResponsibleDecisionMakingUpdateService;
import com.infinite.focus.server.selfmanagement.dto.SelfManagementUpdateDTO;
import com.infinite.focus.server.selfmanagement.entity.SelfManagementUpdate;
import com.infinite.focus.server.selfmanagement.request.GetBySelfManagementUpdateIdRequest;
import com.infinite.focus.server.selfmanagement.service.SelfManagementUpdateService;
import com.infinite.focus.server.socialawareness.dto.SocialAwarenessUpdateDTO;
import com.infinite.focus.server.socialawareness.entity.SocialAwarenessUpdate;
import com.infinite.focus.server.socialawareness.request.GetBySocialAwarenessUpdateIdRequest;
import com.infinite.focus.server.socialawareness.service.SocialAwarenessUpdateService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.GetStudentRequest;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.submoodandstandard.request.GetByMoodIdStandardIdAndSubMoodIdRequest;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AssessmentServiceImpl
implements AssessmentService {
    private final AssessmentRepository assessmentRepository;
    private final AssessmentCoreRepository assessmentCoreRepository;
    private final MoodService moodService;
    private final MoodUpdateService moodUpdateService;
    private final ResponsibleDecisionMakingUpdateService responsibleDecisionMakingUpdateService;
    private final SelfManagementUpdateService selfManagementUpdateService;
    private final SocialAwarenessUpdateService socialAwarenessUpdateService;
    private final RelationshipSkillsUpdateService relationshipSkillsUpdateService;
    private final PostService postService;
    private final StudentService studentService;
    private final MessageService messageService;
    private final ConfigurationRepository configurationRepository;
    private final SubMoodAndStandardClient subMoodAndStandardClient;
    private final StudentClient studentClient;
    private final MoodUpdateClient moodUpdateClient;
    private final AssessmentCategoryClient assessmentCategoryClient;
    private final AssessmentPostClient assessmentPostClient;
    private final ResponsibleDecisionMakingUpdateClient responsibleDecisionMakingUpdateClient;
    private final SelfManagementUpdateClient selfManagementUpdateClient;
    private final SocialAwarenessUpdateClient socialAwarenessUpdateClient;
    private final RelationshipSkillsUpdateClient relationshipSkillsUpdateClient;
    private final DataSetClient dataSetClient;
    private final PVStateClient pvStateClient;

    public AssessmentServiceImpl(AssessmentRepository assessmentRepository, AssessmentCoreRepository assessmentCoreRepository, MoodService moodService, MoodUpdateService moodUpdateService, ResponsibleDecisionMakingUpdateService responsibleDecisionMakingUpdateService, SelfManagementUpdateService selfManagementUpdateService, SocialAwarenessUpdateService socialAwarenessUpdateService, RelationshipSkillsUpdateService relationshipSkillsUpdateService, PostService postService, StudentService studentService, MessageService messageService, ConfigurationRepository configurationRepository, SubMoodAndStandardClient subMoodAndStandardClient, StudentClient studentClient, MoodUpdateClient moodUpdateClient, AssessmentCategoryClient assessmentCategoryClient, AssessmentPostClient assessmentPostClient, ResponsibleDecisionMakingUpdateClient responsibleDecisionMakingUpdateClient, SelfManagementUpdateClient selfManagementUpdateClient, SocialAwarenessUpdateClient socialAwarenessUpdateClient, RelationshipSkillsUpdateClient relationshipSkillsUpdateClient, DataSetClient dataSetClient, PVStateClient pvStateClient) {
        this.assessmentRepository = assessmentRepository;
        this.assessmentCoreRepository = assessmentCoreRepository;
        this.moodService = moodService;
        this.moodUpdateService = moodUpdateService;
        this.responsibleDecisionMakingUpdateService = responsibleDecisionMakingUpdateService;
        this.selfManagementUpdateService = selfManagementUpdateService;
        this.socialAwarenessUpdateService = socialAwarenessUpdateService;
        this.relationshipSkillsUpdateService = relationshipSkillsUpdateService;
        this.postService = postService;
        this.studentService = studentService;
        this.messageService = messageService;
        this.configurationRepository = configurationRepository;
        this.subMoodAndStandardClient = subMoodAndStandardClient;
        this.studentClient = studentClient;
        this.moodUpdateClient = moodUpdateClient;
        this.assessmentCategoryClient = assessmentCategoryClient;
        this.assessmentPostClient = assessmentPostClient;
        this.responsibleDecisionMakingUpdateClient = responsibleDecisionMakingUpdateClient;
        this.selfManagementUpdateClient = selfManagementUpdateClient;
        this.socialAwarenessUpdateClient = socialAwarenessUpdateClient;
        this.relationshipSkillsUpdateClient = relationshipSkillsUpdateClient;
        this.dataSetClient = dataSetClient;
        this.pvStateClient = pvStateClient;
    }

    public AssessmentAndStreak createAssessment(AssessmentRequest assessmentRequest) {
        Student student = this.studentService.getStudentById(assessmentRequest.getStudent_id());
        Assessment assessment = this.assessmentRepository.findByAssementId(assessmentRequest.getAssessment_id());
        if (assessment == null && assessmentRequest.getAssessment_type() != AssessmentType.SELF_AWARENESS) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.assessment.is.not.found"));
        }
        AssessmentAndStreak assessmentAndStreak = new AssessmentAndStreak();
        switch (1.$SwitchMap$com$infinite$focus$server$assessment$model$AssessmentType[assessmentRequest.getAssessment_type().ordinal()]) {
            case 1: {
                assessmentRequest.getSelf_awareness().setStudent_id(assessmentRequest.getStudent_id());
                MoodUpdateAndStreak self_awareness = this.moodUpdateClient.create(assessmentRequest.getSelf_awareness());
                assessmentAndStreak.setStreak(self_awareness.getStreak());
                assessment = new Assessment();
                assessment.setStudent_id(assessmentRequest.getStudent_id());
                assessment.setStandard_id(student.getStandard_id());
                assessment.setSelf_awareness_id(self_awareness.getMoodUpdate().getMood_update_id());
                assessment.setSelf_awareness_score(self_awareness.getMoodUpdate().getScore());
                this.assessmentRepository.save((Object)assessment);
                break;
            }
            case 2: {
                if (this.allowOnlySelfAwareness(student.getStandard().getStandard_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.elementary.s.student.need.not.to.submit.responsible.decision.making"));
                }
                assessmentRequest.getResponsible_decision_making_update().setStudent_id(assessmentRequest.getStudent_id());
                assessmentRequest.getResponsible_decision_making_update().setStandard_id(student.getStandard_id());
                ResponsibleDecisionMakingUpdate responsibleDecisionMakingUpdate = this.responsibleDecisionMakingUpdateService.createResponsibleDecisionMakingUpdate(assessmentRequest.getResponsible_decision_making_update());
                assessment.setResponsible_decision_making_id(responsibleDecisionMakingUpdate.getResponsible_decision_making_update_id());
                assessment.setResponsible_decision_making_score(responsibleDecisionMakingUpdate.getScore());
                assessment.setUpdatedAt(new Date());
                this.assessmentRepository.save((Object)assessment);
                break;
            }
            case 3: {
                if (this.allowOnlySelfAwareness(student.getStandard().getStandard_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.elementary.s.student.need.not.to.submit.self.management"));
                }
                assessmentRequest.getSelf_management_update().setStudent_id(assessmentRequest.getStudent_id());
                assessmentRequest.getSelf_management_update().setStandard_id(student.getStandard_id());
                SelfManagementUpdate selfManagementUpdate = this.selfManagementUpdateService.createSelfManagementUpdate(assessmentRequest.getSelf_management_update());
                assessment.setSelf_management_id(selfManagementUpdate.getSelf_management_update_id());
                assessment.setSelf_management__score(selfManagementUpdate.getScore());
                assessment.setUpdatedAt(new Date());
                this.assessmentRepository.save((Object)assessment);
                break;
            }
            case 4: {
                if (this.allowOnlySelfAwareness(student.getStandard().getStandard_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.elementary.s.student.need.not.to.submit.social.awareness"));
                }
                assessmentRequest.getSocial_awareness_update().setStudent_id(assessmentRequest.getStudent_id());
                assessmentRequest.getSocial_awareness_update().setStandard_id(student.getStandard_id());
                SocialAwarenessUpdate socialAwarenessUpdate = this.socialAwarenessUpdateService.createSocialAwarenessUpdate(assessmentRequest.getSocial_awareness_update());
                assessment.setSocial_awareness_id(socialAwarenessUpdate.getSocial_awareness_update_id());
                assessment.setSocial_awareness_score(socialAwarenessUpdate.getScore());
                assessment.setUpdatedAt(new Date());
                this.assessmentRepository.save((Object)assessment);
                break;
            }
            case 5: {
                if (this.allowOnlySelfAwareness(student.getStandard().getStandard_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.elementary.s.student.need.not.to.submit.relationship.skills"));
                }
                assessmentRequest.getRelationship_skills_update().setStudent_id(assessmentRequest.getStudent_id());
                assessmentRequest.getRelationship_skills_update().setStandard_id(student.getStandard_id());
                RelationshipSkillsUpdate relationshipSkillsUpdate = this.relationshipSkillsUpdateService.createRelationshipSkillsUpdate(assessmentRequest.getRelationship_skills_update());
                assessment.setRelationship_skills_id(relationshipSkillsUpdate.getRelationship_skills_update_id());
                assessment.setRelationship_skills_score(relationshipSkillsUpdate.getScore());
                assessment.setUpdatedAt(new Date());
                this.assessmentRepository.save((Object)assessment);
                break;
            }
        }
        assessmentAndStreak.setAssessment(assessment);
        return assessmentAndStreak;
    }

    public Object getTravelLog(GetTravelLogForStudentRequest getTravelLogForStudentRequest) {
        switch (1.$SwitchMap$com$infinite$focus$server$assessment$model$AssessmentType[getTravelLogForStudentRequest.getAssessment_type().ordinal()]) {
            case 1: {
                String baseUrlApi = this.configurationRepository.getConfiguration().getBaseUrlApi();
                Page moodUpdates = this.moodUpdateService.getByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy());
                return new PageImpl(moodUpdates.stream().peek(m -> {
                    m.setImage_elementary(baseUrlApi + m.getImage_elementary());
                    m.setImage_others(baseUrlApi + m.getImage_others());
                    m.setAnimated_image(baseUrlApi + m.getAnimated_image());
                }).collect(Collectors.toList()), moodUpdates.getPageable(), moodUpdates.getTotalElements());
            }
            case 2: {
                Page responsibleDecisionMakingUpdateWrappers = this.responsibleDecisionMakingUpdateService.getResponsibleDecisionMakingUpdateLogByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy());
                return responsibleDecisionMakingUpdateWrappers;
            }
            case 3: {
                Page selfManagementUpdateWrappers = this.selfManagementUpdateService.getSelfManagementUpdateLogByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy());
                return selfManagementUpdateWrappers;
            }
            case 4: {
                Page socialAwarenessUpdateWrappers = this.socialAwarenessUpdateService.getSocialAwarenessUpdateLogByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy());
                return socialAwarenessUpdateWrappers;
            }
            case 5: {
                Page relationshipSkillsUpdateWrappers = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateLogByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy());
                return relationshipSkillsUpdateWrappers;
            }
        }
        return new ArrayList();
    }

    public AssessmentWrapper getMostRecentAssessmentDataByStudentId(long student_id) {
        Assessment assessment = this.assessmentRepository.getMostRecentAssessmentByStudentId(student_id);
        if (assessment == null) {
            return null;
        }
        return this.getAssessmentWrapperByAssessment(assessment);
    }

    public AssessmentWrapper getAssessmentWrapperByAssessment(Assessment assessment) {
        AssessmentWrapper aw = new AssessmentWrapper();
        aw.setAssessment_id(assessment.getAssessment_id());
        aw.setStudent_id(assessment.getStudent_id());
        MoodUpdateDTO selfAwarenessUpdate = this.moodService.getMoodUpdateById(assessment.getSelf_awareness_id());
        aw.setSelf_awareness_update(selfAwarenessUpdate);
        ResponsibleDecisionMakingUpdate responsibleDecisionMakingUpdate = this.responsibleDecisionMakingUpdateService.getResponsibleDecisionMakingUpdateById(assessment.getResponsible_decision_making_id());
        aw.setResponsible_decision_making_update(responsibleDecisionMakingUpdate);
        SelfManagementUpdate selfManagementUpdate = this.selfManagementUpdateService.getSelfManagementUpdateById(assessment.getSelf_management_id());
        aw.setSelf_management_update(selfManagementUpdate);
        SocialAwarenessUpdate socialAwarenessUpdate = this.socialAwarenessUpdateService.getSocialAwarenessUpdateById(assessment.getSocial_awareness_id());
        aw.setSocial_awareness_update(socialAwarenessUpdate);
        RelationshipSkillsUpdate relationshipSkillsUpdate = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateById(assessment.getRelationship_skills_id());
        aw.setRelationship_skills_update(relationshipSkillsUpdate);
        aw.setCreatedAt(assessment.getCreatedAt());
        aw.setUpdatedAt(assessment.getUpdatedAt());
        return aw;
    }

    public void setAssessmentForToday(AccountDataWrapper accountDataWrapper) {
        long hours;
        AssessmentWrapper assessmentWrapper = this.getMostRecentAssessmentDataByStudentId(accountDataWrapper.getS().getStudent_id());
        if (assessmentWrapper != null && assessmentWrapper.getRelationship_skills_update() == null && !this.allowOnlySelfAwareness(accountDataWrapper.getS().getStandard().getStandard_id()) && (hours = DateUtils.countHoursBetweenFromDateAndToDate((Date)assessmentWrapper.getCreatedAt(), (Date)new Date())) < 24L) {
            accountDataWrapper.setAssessmentWrapper(assessmentWrapper);
        }
    }

    public AssessmentWrapper getPendingAssessmentForToday(long student_id, long standard_id) {
        long hours;
        Assessment assessment = this.assessmentRepository.getMostRecentAssessmentByStudentId(student_id);
        if (assessment == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.assessment.is.not.found"));
        }
        if (assessment.getRelationship_skills_id() == 0L && !this.allowOnlySelfAwareness(standard_id) && (hours = DateUtils.countHoursBetweenFromDateAndToDate((Date)assessment.getCreatedAt(), (Date)new Date())) < 24L) {
            return this.getAssessmentWrapperByAssessment(assessment);
        }
        return null;
    }

    public List<CategoryAndScore> getCategoriesAndScoresForAssessment(Assessment assessment) {
        ArrayList<CategoryAndScore> categoryAndScoreList = new ArrayList<CategoryAndScore>();
        CategoryAndScore selfAwareness = this.moodService.getCategoryAndScoreBySelfAwarenessIdAndScore(assessment.getSelf_awareness_id(), assessment.getSelf_awareness_score());
        categoryAndScoreList.add(selfAwareness);
        CategoryAndScore socialAwareness = this.socialAwarenessUpdateService.getCategoryAndScoreBySocialAwarenessUpdateIdAndScore(assessment.getSocial_awareness_id(), assessment.getSocial_awareness_score());
        categoryAndScoreList.add(socialAwareness);
        CategoryAndScore selfManagement = this.selfManagementUpdateService.getCategoryAndScoreBySelfManagementUpdateIdAndScore(assessment.getSelf_management_id(), assessment.getSelf_management_score());
        categoryAndScoreList.add(selfManagement);
        CategoryAndScore responsibleDecisionMaking = this.responsibleDecisionMakingUpdateService.getCategoryAndScoreByResponsibleDecisionMakingUpdateIdAndScore(assessment.getResponsible_decision_making_id(), assessment.getResponsible_decision_making_score());
        categoryAndScoreList.add(responsibleDecisionMaking);
        CategoryAndScore relationshipSkills = this.relationshipSkillsUpdateService.getCategoryAndScoreByRelationshipSkillsUpdateIdAndScore(assessment.getRelationship_skills_id(), assessment.getRelationship_skills_score());
        categoryAndScoreList.add(relationshipSkills);
        return categoryAndScoreList;
    }

    public void syncAssessmentCategoryAndPost() {
        for (Assessment assessment : this.assessmentRepository.findAll().stream().sorted(Comparator.comparingLong(Assessment::getAssessment_id)).collect(Collectors.toList())) {
            try {
                Student student = this.studentClient.getStudentById(GetStudentRequest.builder().student_id(Long.valueOf(assessment.getStudent_id())).build());
                if (assessment.getSelf_awareness_id() > 0L && assessment.getResponsible_decision_making_id() > 0L && assessment.getSelf_management_id() > 0L && assessment.getSocial_awareness_id() > 0L && assessment.getRelationship_skills_id() > 0L) {
                    this.getPostsForAssessment(student.getStandard_id(), assessment);
                }
                if (assessment.getSelf_awareness_id() <= 0L || !this.allowOnlySelfAwareness(student.getStandard().getStandard_id())) continue;
                this.getPostsForSelfAwareness(student.getStandard_id(), assessment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<PostDTO> getPostsForAssessment(long standard_id, Assessment assessment) {
        List categoryAndScoreList = this.getCategoriesAndScoresForAssessment(assessment);
        Collections.sort(categoryAndScoreList, Comparator.comparing(CategoryAndScore::getScore));
        LinkedHashSet<Double> scores = new LinkedHashSet<Double>();
        for (CategoryAndScore categoryAndScore : categoryAndScoreList) {
            String category_name = categoryAndScore.getCategory().getCategory_name();
            double score = categoryAndScore.getScore();
            System.out.println("Category Name : " + category_name + "   Score : " + score);
            scores.add(score);
        }
        ArrayList<PostDTO> posts = new ArrayList<PostDTO>();
        Set category_ids = categoryAndScoreList.stream().map(CategoryAndScore::getCategory).map(CategoryDTO::getCategory_id).limit(3L).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        this.assessmentCategoryClient.create(CreateAssessmentCategoryRequest.builder().assessment_id(assessment.getAssessment_id()).category_ids(category_ids).build());
        if (scores.size() == 1) {
            posts.addAll(this.postService.get3RandomPost(standard_id));
        } else {
            posts.addAll(this.postService.get3RandomPostByCategories(standard_id, category_ids));
        }
        this.assessmentPostClient.create(CreateAssessmentPostRequest.builder().assessment_id(assessment.getAssessment_id()).post_ids(posts.stream().map(PostDTO::getPost_id).collect(Collectors.toSet())).build());
        return posts;
    }

    public List<PostDTO> getPostsForSelfAwareness(long standard_id, Assessment assessment) {
        CategoryAndScore selfAwareness = this.moodService.getCategoryAndScoreBySelfAwarenessIdAndScore(assessment.getSelf_awareness_id(), assessment.getSelf_awareness_score());
        ArrayList<PostDTO> posts = new ArrayList<PostDTO>();
        posts.addAll(this.postService.get3RandomPostByCategoryId(standard_id, selfAwareness.getCategory().getCategory_id()));
        HashSet<Long> category_ids = new HashSet<Long>();
        category_ids.add(selfAwareness.getCategory().getCategory_id());
        this.assessmentCategoryClient.create(CreateAssessmentCategoryRequest.builder().assessment_id(assessment.getAssessment_id()).category_ids(category_ids).build());
        this.assessmentPostClient.create(CreateAssessmentPostRequest.builder().assessment_id(assessment.getAssessment_id()).post_ids(posts.stream().map(PostDTO::getPost_id).collect(Collectors.toSet())).build());
        return posts;
    }

    public boolean allowOnlySelfAwareness(long standard_id) {
        return standard_id <= 6L;
    }

    public void savePVState(Assessment assessment) {
        ArrayList<PVState> pvStates = new ArrayList<PVState>();
        MoodUpdateDTO moodUpdateDTO = this.moodUpdateClient.getById(GetSelfAwarenessByIdRequest.builder().self_awareness_id(assessment.getSelf_awareness_id()).build());
        pvStates.add(moodUpdateDTO.getPv_state());
        SubMoodAndStandardDTO subMoodAndStandardDTO = this.subMoodAndStandardClient.getByMoodIdAndStandardIdAndSubMoodId(GetByMoodIdStandardIdAndSubMoodIdRequest.builder().mood_id(moodUpdateDTO.getMood_id()).standard_id(moodUpdateDTO.getStandard_id()).sub_mood_id(moodUpdateDTO.getSub_mood_id()).build());
        pvStates.add(subMoodAndStandardDTO.getPv_state());
        if (assessment.getRelationship_skills_id() > 0L) {
            ArrayList<Long> data_set_ids = new ArrayList<Long>();
            ResponsibleDecisionMakingUpdateDTO responsibleDecisionMakingUpdateDTO = this.responsibleDecisionMakingUpdateClient.getById(GetByResponsibleDecisionMakingUpdateIdRequest.builder().responsible_decision_making_update_id(assessment.getResponsible_decision_making_id()).build());
            data_set_ids.add(responsibleDecisionMakingUpdateDTO.getData_set_id());
            SelfManagementUpdateDTO selfManagementUpdateDTO = this.selfManagementUpdateClient.getById(GetBySelfManagementUpdateIdRequest.builder().self_management_update_id(assessment.getSelf_management_id()).build());
            data_set_ids.add(selfManagementUpdateDTO.getData_set_id());
            SocialAwarenessUpdateDTO socialAwarenessUpdateDTO = this.socialAwarenessUpdateClient.getById(GetBySocialAwarenessUpdateIdRequest.builder().social_awareness_update_id(assessment.getSocial_awareness_id()).build());
            data_set_ids.add(socialAwarenessUpdateDTO.getData_set_id());
            RelationshipSkillsUpdateDTO relationshipSkillsUpdateDTO = this.relationshipSkillsUpdateClient.getById(GetByRelationshipSkillsUpdateIdRequest.builder().relationship_skills_update_id(assessment.getRelationship_skills_id()).build());
            data_set_ids.addAll(Arrays.stream(relationshipSkillsUpdateDTO.getData_set_ids().split("\\s*,\\s*")).map(Long::valueOf).collect(Collectors.toList()));
            pvStates.addAll(this.dataSetClient.getPVStatesByDataSetIds(GetPVStatesByDataSetIdsRequest.builder().data_set_ids(data_set_ids).build()));
        }
        PVStateDTO pvStateDTO = this.pvStateClient.getAvgPVStateByPVStates(GetAvgPVStateByPVStatesRequest.builder().pv_states(pvStates).build());
        assessment.setPv_state(pvStateDTO.getPv_state());
        this.assessmentRepository.save((Object)assessment);
    }

    public List<Assessment> getAll() {
        return this.assessmentRepository.findAll();
    }

    public List<AssessmentDTO> getByStudentIdAndBetweenFromDateAndToDate(long student_id, Date from_date, Date to_date) {
        return this.assessmentCoreRepository.findByStudentIdAndBetweenFromDateAndToDate(student_id, from_date, to_date);
    }
}

