/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.compassdashboard.controller;

import com.infinite.focus.server.askforhelp.request.GetAskForHelpByStudentIdRequest;
import com.infinite.focus.server.assessment.entity.Assessment;
import com.infinite.focus.server.assessment.model.AssessmentAndStreak;
import com.infinite.focus.server.assessment.model.AssessmentType;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.assessment.service.AssessmentService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.request.GetCategoriesByIdsRequest;
import com.infinite.focus.server.client.AskForHelpClient;
import com.infinite.focus.server.client.CategoryClient;
import com.infinite.focus.server.client.MoodClient;
import com.infinite.focus.server.compassdashboard.request.AssessmentRequest;
import com.infinite.focus.server.compassdashboard.request.GetLowScoreCategoriesByAssessmentTextsRequest;
import com.infinite.focus.server.compassdashboard.request.GetTravelLogForStudentRequest;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/compass-dashboard"})
public class CompassDashboardController {
    private final AuthService authService;
    private final DataSetService dataService;
    private final AssessmentService assessmentService;
    private final StudentService studentService;
    private final ConfigurationRepository configurationRepository;
    private final AskForHelpClient askForHelpClient;
    private final MoodClient moodClient;
    private final CategoryClient categoryClient;

    public CompassDashboardController(AuthService authService, DataSetService dataService, AssessmentService assessmentService, StudentService studentService, ConfigurationRepository configurationRepository, AskForHelpClient askForHelpClient, MoodClient moodClient, CategoryClient categoryClient) {
        this.authService = authService;
        this.dataService = dataService;
        this.assessmentService = assessmentService;
        this.studentService = studentService;
        this.configurationRepository = configurationRepository;
        this.askForHelpClient = askForHelpClient;
        this.moodClient = moodClient;
        this.categoryClient = categoryClient;
    }

    @GetMapping(value={"/get/datasets"})
    public ResponseEntity<List<DataSet>> getContents(@RequestHeader(value="Authorization") String token) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.dataService.getDataSets(), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/create/dataset"})
    @ResponseBody
    public ResponseEntity<DataSet> createMood(@RequestHeader(value="Authorization") String token, @RequestParam(value="assessment_category") AssessmentCategory assessment_category, @RequestParam(value="assessment_category_name") String assessment_category_name, @RequestParam(value="title") String title, @RequestParam(required=false, value="sub_title") String sub_title, @RequestParam(value="score") double score) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.dataService.createDataSet(assessment_category, assessment_category_name, title, sub_title, score), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/update/dataset"})
    @ResponseBody
    public ResponseEntity<DataSet> updateMood(@RequestHeader(value="Authorization") String token, @RequestBody DataSet request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.dataService.updateDataSet(request), (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/dataset/{data_set_id}"})
    public ResponseEntity<Message> deleteMood(@RequestHeader(value="Authorization") String token, @PathVariable(value="data_set_id") long data_set_id) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.dataService.deleteDataSetById(data_set_id), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/create/assessment"})
    @ResponseBody
    public ResponseEntity<Object> createAssessment(@RequestHeader(value="Authorization") String token, @RequestBody AssessmentRequest assessmentRequest) {
        this.authService.isAuthenticated(token);
        Student student = this.studentService.getStudentById(assessmentRequest.getStudent_id());
        HashMap<String, Object> assessmentResponseWrapper = new HashMap<String, Object>();
        AssessmentAndStreak assessmentAndStreak = this.assessmentService.createAssessment(assessmentRequest);
        assessmentResponseWrapper.put("assessment_id", assessmentAndStreak.getAssessment().getAssessment_id());
        if (assessmentAndStreak.getAssessment() != null && assessmentAndStreak.getAssessment().getSelf_awareness_id() > 0L && assessmentAndStreak.getAssessment().getResponsible_decision_making_id() > 0L && assessmentAndStreak.getAssessment().getSelf_management_id() > 0L && assessmentAndStreak.getAssessment().getSocial_awareness_id() > 0L && assessmentAndStreak.getAssessment().getRelationship_skills_id() > 0L && assessmentRequest.getAssessment_type().equals((Object)AssessmentType.RELATIONSHIP_SKILLS)) {
            try {
                new Thread(() -> this.assessmentService.savePVState(assessmentAndStreak.getAssessment())).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            assessmentResponseWrapper.put("posts", this.assessmentService.getPostsForAssessment(student.getStandard_id(), assessmentAndStreak.getAssessment()));
        }
        if (assessmentAndStreak.getAssessment() != null && assessmentAndStreak.getAssessment().getSelf_awareness_id() > 0L && this.assessmentService.allowOnlySelfAwareness(student.getStandard().getStandard_id()) && assessmentRequest.getAssessment_type().equals((Object)AssessmentType.SELF_AWARENESS)) {
            try {
                new Thread(() -> this.assessmentService.savePVState(assessmentAndStreak.getAssessment())).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            assessmentResponseWrapper.put("posts", this.assessmentService.getPostsForSelfAwareness(student.getStandard_id(), assessmentAndStreak.getAssessment()));
        }
        assessmentResponseWrapper.put("streak", assessmentAndStreak.getStreak());
        if (assessmentRequest.getAssessment_type().equals((Object)AssessmentType.SELF_AWARENESS)) {
            assessmentResponseWrapper.put("ask_for_help", this.askForHelpClient.checkByStudentId(GetAskForHelpByStudentIdRequest.builder().student_id(student.getStudent_id()).build()));
        }
        return new ResponseEntity(assessmentResponseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sync/assessment-for-pv-state"})
    ResponseEntity<Void> syncAssessmentForPVState() {
        new Thread(() -> {
            for (Assessment assessment : this.assessmentService.getAll()) {
                try {
                    this.assessmentService.savePVState(assessment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/travel-log/for/student"})
    @ResponseBody
    public ResponseEntity<Object> getTravelLogForStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetTravelLogForStudentRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity(this.assessmentService.getTravelLog(request), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/sync/assessment-category-and-post"})
    @ResponseBody
    public ResponseEntity<Void> syncAssessmentCategoryAndPost(@RequestHeader(value="Authorization") String token) {
        this.authService.isAdmin(token);
        this.assessmentService.syncAssessmentCategoryAndPost();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-low-score-categories-by-assessment-texts"})
    @ResponseBody
    public ResponseEntity<List<CategoryAndScore>> getLowScoreCategoriesByAssessmentTexts(@RequestBody GetLowScoreCategoriesByAssessmentTextsRequest request) {
        CategoryDTO category;
        ArrayList<CategoryAndScore> categoryAndScoreList = new ArrayList<CategoryAndScore>();
        if (!AppUtils.isNullOrEmpty((String)request.getSelf_awareness())) {
            MoodDTO moodDTO = this.moodClient.getAllMoods().stream().filter(m -> m.getMood().equalsIgnoreCase(request.getSelf_awareness().trim())).findAny().orElse(null);
            CategoryAndScore categoryAndScore = new CategoryAndScore();
            long self_awareness_category_id = this.configurationRepository.getConfiguration().getSelf_awareness_category_id();
            HashSet<Long> category_ids = new HashSet<Long>();
            category_ids.add(self_awareness_category_id);
            CategoryDTO category2 = this.categoryClient.getCategoriesByIds(GetCategoriesByIdsRequest.builder().ids(category_ids).build()).stream().findFirst().orElse(null);
            categoryAndScore.setCategory(category2);
            categoryAndScore.setScore(moodDTO.getWeight());
            categoryAndScoreList.add(categoryAndScore);
        }
        if (!AppUtils.isNullOrEmpty((String)request.getResponsible_decision_making())) {
            DataSet responsible_decision_making = this.dataService.getDataSets().stream().filter(d -> d.getAssessment_category().equals((Object)AssessmentCategory.RESPONSIBLE_DECISION_MAKING)).filter(d -> d.getText_to_display().equalsIgnoreCase(request.getResponsible_decision_making().trim()) || d.getTitle().equalsIgnoreCase(request.getResponsible_decision_making().trim())).findAny().orElse(null);
            category = this.dataService.getCategoryByDataSetId(responsible_decision_making.getData_set_id());
            CategoryAndScore categoryAndScore = new CategoryAndScore();
            categoryAndScore.setCategory(category);
            categoryAndScore.setScore(responsible_decision_making.getScore());
            categoryAndScoreList.add(categoryAndScore);
        }
        if (!AppUtils.isNullOrEmpty((String)request.getSelf_management())) {
            DataSet self_management = this.dataService.getDataSets().stream().filter(d -> d.getAssessment_category().equals((Object)AssessmentCategory.SELF_MANAGEMENT)).filter(d -> d.getText_to_display().equalsIgnoreCase(request.getSelf_management().trim()) || d.getTitle().equalsIgnoreCase(request.getSelf_management().trim())).findAny().orElse(null);
            category = this.dataService.getCategoryByDataSetId(self_management.getData_set_id());
            CategoryAndScore categoryAndScore = new CategoryAndScore();
            categoryAndScore.setCategory(category);
            categoryAndScore.setScore(self_management.getScore());
            categoryAndScoreList.add(categoryAndScore);
        }
        if (!AppUtils.isNullOrEmpty((String)request.getSelf_management())) {
            DataSet social_awareness = this.dataService.getDataSets().stream().filter(d -> d.getAssessment_category().equals((Object)AssessmentCategory.SOCIAL_AWARENESS)).filter(d -> d.getText_to_display().equalsIgnoreCase(request.getSocial_awareness().trim()) || d.getTitle().equalsIgnoreCase(request.getSocial_awareness().trim())).findAny().orElse(null);
            category = this.dataService.getCategoryByDataSetId(social_awareness.getData_set_id());
            CategoryAndScore categoryAndScore = new CategoryAndScore();
            categoryAndScore.setCategory(category);
            categoryAndScore.setScore(social_awareness.getScore());
            categoryAndScoreList.add(categoryAndScore);
        }
        if (!AppUtils.isNullOrEmpty((String)request.getRelationship_skills())) {
            List texts = Arrays.stream(request.getRelationship_skills().split("\\s*,\\s*")).map(String::trim).collect(Collectors.toList());
            List relationship_skills = this.dataService.getDataSets().stream().filter(d -> d.getAssessment_category().equals((Object)AssessmentCategory.RELATIONSHIP_SKILLS)).filter(d -> texts.contains(d.getText_to_display()) || texts.contains(d.getTitle())).collect(Collectors.toList());
            CategoryDTO category3 = this.dataService.getCategoryByDataSetId(((DataSet)relationship_skills.get(0)).getData_set_id());
            CategoryAndScore categoryAndScore = new CategoryAndScore();
            categoryAndScore.setCategory(category3);
            categoryAndScore.setScore(relationship_skills.stream().map(DataSet::getScore).reduce(0.0, Double::sum) / 4.0);
            categoryAndScoreList.add(categoryAndScore);
        }
        categoryAndScoreList.sort(Comparator.comparing(CategoryAndScore::getScore));
        return new ResponseEntity(categoryAndScoreList, (HttpStatusCode)HttpStatus.OK);
    }
}

