/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.unsubscribe.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.unsubscribe.request.UnsubscribeFromRequest;
import com.infinite.focus.server.unsubscribe.service.UnsubscribeService;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/unsubscribe"})
public class UnsubscribeController {
    private final UnsubscribeService unsubscribeService;
    private final MessageService messageService;

    public UnsubscribeController(UnsubscribeService unsubscribeService, MessageService messageService) {
        this.unsubscribeService = unsubscribeService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/from"})
    public ResponseEntity<Message> unsubscribe(@RequestBody UnsubscribeFromRequest request) {
        this.unsubscribeService.unsubscribe(request.getEmail_address(), request.getUnsubscribe_type());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("unsubscribed.successfully"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }
}

