/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosrequest.repository;

import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.repository.SOSRequestRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;

@Repository
public class SOSRequestRepositoryImpl
implements SOSRequestRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SOSRequestDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        return SOSRequestDTO.builder().sos_request_id(rs.getLong("sos_request_id")).student_id(rs.getLong("student_id")).viewed(rs.getBoolean("viewed")).viewed_by_school(rs.getBoolean("viewed_by_school")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public SOSRequestDTO create(long student_id, long ask_for_help_id) {
        String INSERT_SQL = "INSERT INTO sosrequest (student_id, viewed, created_at, updated_at) VALUES (?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO sosrequest (student_id, viewed, created_at, updated_at) VALUES (?,?,?,?)", 1);
            ps.setLong(1, student_id);
            ps.setBoolean(2, false);
            ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int sos_result_id = Objects.requireNonNull(holder.getKey()).intValue();
        return SOSRequestDTO.builder().sos_request_id((long)sos_result_id).student_id(student_id).viewed(false).viewed_by_school(false).build();
    }

    public SOSRequestDTO findById(long sos_request_id) {
        String SQL = "SELECT * FROM sosrequest WHERE sos_request_id = ?";
        try {
            return (SOSRequestDTO)this.jdbcTemplate.queryForObject(SQL, SOSRequestRepositoryImpl::mapRow, new Object[]{sos_request_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int findNotViewedCountByStudentIds(Set<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String rowCountSql = "SELECT count(1) AS row_count FROM sosrequest WHERE student_id IN(%S) AND viewed = 0 ";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(String.format(rowCountSql, inSql), student_ids.toArray(), (rs, rowNum) -> rs.getInt(1));
        return count == null ? 0 : count;
    }

    public int findNotViewedCountForSchoolByStudentIds(Set<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String rowCountSql = "SELECT count(1) AS row_count FROM sosrequest WHERE student_id IN(%S) AND viewed_by_school = 0 ";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(String.format(rowCountSql, inSql), student_ids.toArray(), (rs, rowNum) -> rs.getInt(1));
        return count == null ? 0 : count;
    }

    public Page<SOSRequestDTO> findPageByStudentIds(Set<Long> student_ids, Date fromDate, Date toDate, Pageable pageable) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String rowCountSql = "SELECT count(1) AS row_count FROM sosrequest WHERE student_id IN(%S) AND created_at BETWEEN ? AND ? ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(String.format(rowCountSql, inSql), args.toArray(), (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM sosrequest WHERE student_id IN(%S) ");
        querySql.append("AND created_at BETWEEN ? AND ? ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(String.format(querySql.toString(), inSql), args.toArray(), SOSRequestRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    @Async
    public void updateViewed(long sos_request_id, boolean viewed) {
        String SQL = "UPDATE sosrequest SET viewed = ?, updated_at = ? WHERE sos_request_id = ? ";
        this.jdbcTemplate.update("UPDATE sosrequest SET viewed = ?, updated_at = ? WHERE sos_request_id = ? ", new Object[]{viewed, Timestamp.valueOf(LocalDateTime.now()), sos_request_id});
    }

    @Async
    public void updateViewedForSchool(long sos_request_id, boolean viewed) {
        String SQL = "UPDATE sosrequest SET viewed_by_school = ?, updated_at = ? WHERE sos_request_id = ? ";
        this.jdbcTemplate.update("UPDATE sosrequest SET viewed_by_school = ?, updated_at = ? WHERE sos_request_id = ? ", new Object[]{viewed, Timestamp.valueOf(LocalDateTime.now()), sos_request_id});
    }
}

