/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.standard.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.infinite.focus.server.grade.entity.Grade;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.student.entity.Student;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class Standard {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long standard_id;
    private String standard_name;
    @Transient
    private long grade_id;
    @OneToOne(targetEntity=Grade.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(nullable=true, name="grade_id", foreignKey=@ForeignKey(name="none"))
    private Grade grade;
    @ManyToMany(targetEntity=Instructor.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="instructor_standard", joinColumns={@JoinColumn(name="standard_id")}, inverseJoinColumns={@JoinColumn(name="instructor_id")})
    @JsonIgnore
    private Set<Instructor> instructors = new HashSet();
    @OneToMany(targetEntity=Student.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(nullable=true, name="standard_id", foreignKey=@ForeignKey(name="none"))
    @OrderBy(value="student_id asc")
    @JsonIgnoreProperties(value={"standard", "instructor", "parent", "class"})
    @JsonIgnore
    private Set<Student> students = new HashSet();
    @Column(name="created_at", nullable=false)
    @CreationTimestamp
    public Date createdAt;
    @Column(name="updated_at")
    @UpdateTimestamp
    public Date updatedAt;

    public long getStandard_id() {
        return this.standard_id;
    }

    public void setStandard_id(long standard_id) {
        this.standard_id = standard_id;
    }

    public String getStandard_name() {
        return this.standard_name;
    }

    public void setStandard_name(String standard_name) {
        this.standard_name = standard_name;
    }

    public long getGrade_id() {
        return this.grade == null ? this.grade_id : this.grade.getGrade_id();
    }

    public void setGrade_id(long grade_id) {
        this.grade_id = grade_id;
    }

    public Grade getGrade() {
        return this.grade;
    }

    public void setGrade(Grade grade) {
        this.grade = grade;
    }

    public Set<Instructor> getInstructors() {
        return this.instructors;
    }

    public void setInstructors(Set<Instructor> instructors) {
        this.instructors = instructors;
    }

    public Set<Student> getStudents() {
        return this.students;
    }

    public void setStudents(Set<Student> students) {
        this.students = students;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdateAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }
}

