/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.category;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.client.CategoryClient;
import com.infinite.focus.server.client.PostCategoryClient;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcategory.request.GetPostCategoryListByPostIdsRequest;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.category.StreakCategoryService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StreakCategoryServiceImpl
implements StreakCategoryService {
    private final PostRepository postRepository;
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final StreakHelper streakHelper;
    private final CategoryClient categoryClient;
    private final PostCategoryClient postCategoryClient;

    public StreakCategoryServiceImpl(PostRepository postRepository, StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, StreakHelper streakHelper, CategoryClient categoryClient, PostCategoryClient postCategoryClient) {
        this.postRepository = postRepository;
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.streakHelper = streakHelper;
        this.categoryClient = categoryClient;
        this.postCategoryClient = postCategoryClient;
    }

    public StreakDTO addStreakAllCompetencies(Long studentId, List<Activity> activities) {
        if (studentId == null) {
            return null;
        }
        if (AppUtils.isNullOrEmpty(activities)) {
            return null;
        }
        Set entityIds = activities.stream().map(Activity::getEntity_id).filter(entityId -> entityId > 0L).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(entityIds)) {
            return null;
        }
        List postDTOS = this.postRepository.findByIdsAndPostType(entityIds, PostType.VIDEO.name());
        if (AppUtils.isNullOrEmpty((List)postDTOS)) {
            return null;
        }
        Set postIds = postDTOS.stream().map(PostDTO::getPost_id).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(postIds)) {
            return null;
        }
        HashSet postCategoryList = new HashSet(this.postCategoryClient.getPostCategoryListByPostIds(GetPostCategoryListByPostIdsRequest.builder().post_ids(postIds).build()));
        if (AppUtils.isNullOrEmpty(postCategoryList)) {
            return null;
        }
        Set categoryIds = postCategoryList.stream().map(PostCategoryDTO::getCategory_id).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(categoryIds)) {
            return null;
        }
        Set allCategoryIds = this.categoryClient.getAllCategories().stream().map(CategoryDTO::getCategory_id).collect(Collectors.toSet());
        if (AppUtils.isNullOrEmpty(allCategoryIds)) {
            return null;
        }
        if (!allCategoryIds.equals(categoryIds)) {
            return null;
        }
        StreakDTO streak = this.streakRepository.findByStreakType(StreakType.ALL_COMPETENCIES.name()).stream().findFirst().orElse(null);
        if (streak == null) {
            return null;
        }
        if (this.studentStreakRepository.findByStudentIdAndStreakId(studentId, Long.valueOf(streak.getStreak_id())) != null) {
            return null;
        }
        return this.streakHelper.saveStudentStreak(studentId.longValue(), streak);
    }
}

