/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.journal.service;

import com.infinite.focus.server.client.NotificationClient;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.journal.component.JournalBadWordFilterComponent;
import com.infinite.focus.server.journal.dto.JournalDTO;
import com.infinite.focus.server.journal.repository.JournalRepository;
import com.infinite.focus.server.journal.service.JournalService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.notification.request.BadWordInJournalNotification;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class JournalServiceImpl
implements JournalService {
    private final JournalRepository journalRepository;
    private final MoodRepository moodRepository;
    private final ConfigurationRepository configurationRepository;
    private final StudentRepository studentRepository;
    private final JournalBadWordFilterComponent journalBadWordFilterComponent;
    private final NotificationClient notificationClient;

    public JournalServiceImpl(JournalRepository journalRepository, MoodRepository moodRepository, ConfigurationRepository configurationRepository, StudentRepository studentRepository, JournalBadWordFilterComponent journalBadWordFilterComponent, NotificationClient notificationClient) {
        this.journalRepository = journalRepository;
        this.moodRepository = moodRepository;
        this.configurationRepository = configurationRepository;
        this.studentRepository = studentRepository;
        this.journalBadWordFilterComponent = journalBadWordFilterComponent;
        this.notificationClient = notificationClient;
    }

    public Page<JournalDTO> getJournalByStudentIds(Set<Long> student_ids, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate) {
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page result = this.journalRepository.findPageByStudentIds(student_ids, fromDate, toDate, (Pageable)pageable);
        String imgElePath = this.configurationRepository.getConfiguration().getImages_elementary_path();
        String imgOthPath = this.configurationRepository.getConfiguration().getImages_others_path();
        String gifPath = this.configurationRepository.getConfiguration().getMood_gifs_path();
        PageImpl pagedResult = new PageImpl(result.stream().peek(journal -> {
            Student student = this.studentRepository.findByStudentId(Long.valueOf(journal.getStudent_id()));
            journal.setFirst_name(student.getFirst_name());
            journal.setLast_name(student.getLast_name());
            journal.setStudent_avatar(student.getAvatar_url());
            MoodDTO mood = this.moodRepository.findById(journal.getMood_id());
            if (mood != null) {
                journal.setMood(mood);
                if (!mood.getImages_elementary().contains(imgElePath)) {
                    mood.setImages_elementary(imgElePath + mood.getImages_elementary());
                    mood.setImages_others(imgOthPath + mood.getImages_others());
                    mood.setAnimated_image(gifPath + mood.getAnimated_image());
                }
            }
        }).collect(Collectors.toList()), result.getPageable(), result.getTotalElements());
        return pagedResult;
    }

    public JournalDTO create(long student_id, boolean demo, long mood_id, String mood_name, String mood_name_es, String journal_description) {
        ArrayList hasBadWords = this.journalBadWordFilterComponent.badWordsFoundCompareWordsOnly(journal_description);
        if (!AppUtils.isNullOrEmpty((List)hasBadWords)) {
            String badWords = String.join((CharSequence)",", hasBadWords);
            String language = Language.getLanguage();
            BadWordInJournalNotification badWordInJournalNotification = BadWordInJournalNotification.builder().student_id(student_id).bad_words(badWords).language(language).build();
            this.notificationClient.badWordInJournal(badWordInJournalNotification);
        }
        JournalDTO journal = new JournalDTO();
        journal.setStudent_id(student_id);
        MoodDTO mood = this.moodRepository.findById(mood_id);
        journal.setMood(mood);
        if (mood != null) {
            journal.setMood_name(mood.getMood());
            journal.setMood_name_es(mood.getMood_es());
        } else {
            journal.setMood_name(mood_name);
            journal.setMood_name_es(mood_name_es);
        }
        journal.setJournal_description(journal_description);
        if (demo) {
            long id = this.journalRepository.getLastRecordId() + 1L;
            journal.setJournal_id(id);
            journal.setCreatedAt(new Date());
            journal.setUpdatedAt(new Date());
            return journal;
        }
        if (mood != null) {
            journal = this.journalRepository.create(student_id, mood_id, mood.getMood(), mood.getMood_es(), journal_description);
            journal.setMood(mood);
        } else {
            journal = this.journalRepository.create(student_id, mood_id, mood_name, mood_name_es, journal_description);
        }
        return journal;
    }

    public JournalDTO update(long journal_id, long student_id, long mood_id, String mood_name, String mood_name_es, String journal_description) {
        ArrayList hasBadWords = this.journalBadWordFilterComponent.badWordsFoundCompareWordsOnly(journal_description);
        if (!AppUtils.isNullOrEmpty((List)hasBadWords)) {
            String badWords = String.join((CharSequence)",", hasBadWords);
            String language = Language.getLanguage();
            BadWordInJournalNotification badWordInJournalNotification = BadWordInJournalNotification.builder().student_id(student_id).bad_words(badWords).language(language).build();
            this.notificationClient.badWordInJournal(badWordInJournalNotification);
        }
        JournalDTO journal = this.journalRepository.findById(journal_id);
        journal.setStudent_id(student_id);
        MoodDTO mood = this.moodRepository.findById(mood_id);
        journal.setMood(mood);
        if (mood != null) {
            journal.setMood_name(mood.getMood());
            journal.setMood_name_es(mood.getMood_es());
        } else {
            journal.setMood_name(mood_name);
            journal.setMood_name_es(mood_name_es);
        }
        journal.setJournal_description(journal_description);
        journal.setUpdatedAt(new Date());
        if (mood != null) {
            journal = this.journalRepository.update(journal_id, student_id, mood_id, mood.getMood(), mood.getMood_es(), journal_description);
            journal.setMood(mood);
        } else {
            journal = this.journalRepository.update(journal_id, student_id, mood_id, mood_name, mood_name_es, journal_description);
        }
        return journal;
    }

    public void deleteById(long journal_id) {
        this.journalRepository.deleteById(journal_id);
    }
}

