/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpost.repository;

import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.view.WallPostView;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface WallPostRepository
extends JpaRepository<WallPost, Long> {
    @Query(value="SELECT * FROM wall_post WHERE wall_post_id = ?1 ORDER BY created_at DESC", nativeQuery=true)
    public WallPost findByWallPostId(long var1);

    @Query(value="SELECT * FROM wall_post WHERE student_id = ?1", nativeQuery=true)
    public List<WallPost> findByStudentId(long var1);

    @Query(value="SELECT DISTINCT(wall_post_id) FROM wall_post WHERE student_id = ?1", nativeQuery=true)
    public List<Long> findWallPostIdsByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM wall_post WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Query(value="SELECT * FROM wall_post WHERE student_id IN(?1)", nativeQuery=true)
    public List<WallPost> findByStudentIds(List<Long> var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM wall_post WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM wall_post WHERE wall_post_id IN(?1) ORDER BY created_at DESC", nativeQuery=true)
    public List<WallPost> findAllWallPostIds(List<Long> var1);

    @Query(value="SELECT wall_post_id FROM wall_post ORDER BY created_at DESC LIMIT 0,1", nativeQuery=true)
    public long getLastRecordId();

    @Modifying
    @Transactional
    @Query(value="UPDATE wall_post SET views = ?1 WHERE wall_post_id = ?2", nativeQuery=true)
    public void updateView(long var1, long var3);

    @Query(value="SELECT * FROM wall_post WHERE is_active = true AND is_deleted = false", nativeQuery=true)
    public Page<WallPostView> findAllActive(Pageable var1);

    @Query(value="SELECT * FROM wall_post WHERE student_id IN(?1) AND is_active = true AND is_deleted = false", nativeQuery=true)
    public Page<WallPostView> findAllActiveByStudentIds(Set<Long> var1, Pageable var2);

    @Query(value="SELECT * FROM wall_post WHERE student_id = ?1 AND is_active = true AND is_deleted = false", nativeQuery=true)
    public Page<WallPostView> findAllActiveByStudentId(long var1, Pageable var3);

    @Query(value="SELECT * FROM wall_post post LEFT JOIN student stu ON post.student_id = stu.student_id LEFT JOIN instructor instr ON post.instructor_id = instr.instructor_id WHERE is_active = true AND is_deleted = false AND (stu.instructor_id = ?1 OR post.instructor_id = ?1)", nativeQuery=true)
    public Page<WallPost> findAllActiveByInstructorId(long var1, Pageable var3);

    @Query(value="SELECT * FROM wall_post WHERE is_active = true AND is_deleted = false AND created_at > ?1", nativeQuery=true)
    public List<WallPostView> findAllActive(Date var1);

    @Query(value="SELECT * FROM wall_post WHERE student_id = ?1 AND deleted_date IS NOT NULL ORDER BY deleted_date DESC LIMIT 1", nativeQuery=true)
    public WallPost findMostRecentDeletedPostByStudentId(long var1);

    @Query(value="SELECT * FROM wall_post WHERE student_id = ?1 ORDER BY created_at DESC LIMIT 1", nativeQuery=true)
    public WallPost findLastWallPostByStudentId(long var1);
}

