/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.service.features;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.dashboard.model.FeatureAndTime;
import com.infinite.focus.server.dashboard.model.PageAndPerformance;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.service.features.FeaturesService;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.screen.repository.ScreenRepository;
import com.infinite.focus.server.screen.view.ScreenView;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeaturesServiceImpl
implements FeaturesService {
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    ActivityCriteriaRepository activityCriteriaRepository;
    @Autowired
    ScreenRepository screenRepository;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;
    String forwardSlash = "/";

    public Object getByStudentsDemographicsData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap values;
        List activities;
        GetDataDashBoardRequest getDataDashBoardRequest2;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        List screens = this.screenRepository.getAllScreenList();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest2.getGenders().clear();
            getDataDashBoardRequest2.getGenders().addAll(request.getGenders());
            List activitiesOfGenders = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest2, Long.valueOf(3L));
            LinkedHashMap<String, LinkedList> genderMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genderMap_es = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                activities = activitiesOfGenders.stream().filter(c -> c.getGender().equalsIgnoreCase(gender)).collect(Collectors.toList());
                values = this.getFeatureAndTimeMostAndLeast(activities, screens);
                genderMap_en.put(gender, (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                genderMap_es.put(genderItem.getGender_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Gender", genderMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", genderMap_es);
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ageMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ageMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().clear();
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            List activitiesOfAges = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L));
            for (Integer age : request.getAges()) {
                List activities2 = activitiesOfAges.stream().filter(c -> TimeUtils.getAge((Date)c.getDate_of_birth()) == age).collect(Collectors.toList());
                LinkedHashMap values2 = this.getFeatureAndTimeMostAndLeast(activities2, screens);
                ageMap_en.put(String.valueOf(age), (LinkedList)values2.get("en"));
                if (!Language.isSpanish()) continue;
                ageMap_es.put(String.valueOf(age), (LinkedList)values2.get("es"));
            }
            graphData_en.put("Age", ageMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Edad", ageMap_es);
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().clear();
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            List activitiesOfEthnicities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L));
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                activities = activitiesOfEthnicities.stream().filter(c -> c.getEthnicity().equalsIgnoreCase(ethnicity)).collect(Collectors.toList());
                values = this.getFeatureAndTimeMostAndLeast(activities, screens);
                ethnicityMap_en.put(ethnicity, (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", ethnicityMap_es);
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> gradeMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().clear();
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            List activitiesOfGrades = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L));
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                activities = activitiesOfGrades.stream().filter(c -> Objects.equals(c.getGrade_id(), grade_id)).collect(Collectors.toList());
                values = this.getFeatureAndTimeMostAndLeast(activities, screens);
                gradeMap_en.put(gradeView.getGrade_name(), (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                gradeMap_es.put(gradeView.getGrade_name_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Grade", gradeMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", gradeMap_es);
            }
        }
        getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
        LinkedHashMap values3 = this.getFeatureAndTimeMostAndLeast(this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest2, Long.valueOf(3L)), screens);
        LinkedHashMap<String, LinkedList> overall_en = new LinkedHashMap<String, LinkedList>();
        overall_en.put("Overall", (LinkedList)values3.get("en"));
        graphData_en.put("Overall", overall_en);
        LinkedHashMap<String, LinkedList> overall_es = new LinkedHashMap<String, LinkedList>();
        overall_es.put("En total", (LinkedList)values3.get("es"));
        graphData_es.put("En total", overall_es);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<String>> getFeatureAndTimeMostAndLeast(List<ActivityDTO> activities, List<ScreenView> screens) {
        LinkedHashMap<Long, Long> featuresMap = new LinkedHashMap<Long, Long>();
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDTO activity = activities.get(i);
            long key = activity.getEntity_id();
            long differnce = activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime();
            if (featuresMap.containsKey(key)) {
                long appUsedTime = differnce + (Long)featuresMap.get(key);
                featuresMap.put(key, appUsedTime);
                continue;
            }
            featuresMap.put(key, differnce);
        }
        LinkedList<FeatureAndTime> featureAndTimeList = new LinkedList<FeatureAndTime>();
        for (Long key : featuresMap.keySet()) {
            Optional<ScreenView> screenView = screens.stream().filter(s -> Objects.equals(s.getScreen_id(), key)).findFirst();
            if (!screenView.isPresent()) continue;
            ScreenView screen = screenView.get();
            FeatureAndTime featureAndTime = new FeatureAndTime();
            featureAndTime.setFeature(screen.getName());
            featureAndTime.setFeature_es(screen.getName_es());
            featureAndTime.setTime((Long)featuresMap.get(key));
            featureAndTimeList.add(featureAndTime);
        }
        Collections.sort(featureAndTimeList, new /* Unavailable Anonymous Inner Class!! */);
        LinkedList<Object> mostAndLeast_en = new LinkedList<Object>();
        LinkedList<Object> mostAndLeast_es = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty(featureAndTimeList)) {
            FeatureAndTime most = (FeatureAndTime)featureAndTimeList.get(0);
            FeatureAndTime least = (FeatureAndTime)featureAndTimeList.get(featureAndTimeList.size() - 1);
            mostAndLeast_en.add(most.getFeature() + " (" + TimeUtils.getTimeInString((long)most.getTime()) + ")");
            mostAndLeast_en.add(least.getFeature() + " (" + TimeUtils.getTimeInString((long)least.getTime()) + ")");
            if (Language.isSpanish()) {
                mostAndLeast_es.add(most.getFeature_es() + " (" + TimeUtils.getTimeInString((long)most.getTime()) + ")");
                mostAndLeast_es.add(least.getFeature_es() + " (" + TimeUtils.getTimeInString((long)least.getTime()) + ")");
            }
        } else {
            mostAndLeast_en.add("");
            mostAndLeast_en.add("");
            if (Language.isSpanish()) {
                mostAndLeast_es.add("");
                mostAndLeast_es.add("");
            }
        }
        LinkedHashMap<String, LinkedList<String>> graphData = new LinkedHashMap<String, LinkedList<String>>();
        graphData.put("en", mostAndLeast_en);
        if (Language.isSpanish()) {
            graphData.put("es", mostAndLeast_es);
        }
        return graphData;
    }

    public Object getByTeachersGradesData(GetDataDashBoardRequest request) {
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        List screens = this.screenRepository.getAllScreenList();
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> gradeMap_es = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().clear();
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                List activityDTOList = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L));
                LinkedHashMap values = this.getFeatureAndTimeMostAndLeast(activityDTOList, screens);
                gradeMap_en.put(gradeView.getGrade_name(), (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                gradeMap_es.put(gradeView.getGrade_name_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Grade", gradeMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", gradeMap_es);
            }
        }
        System.out.println("----------------------------- Overall ------------------------------");
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        LinkedHashMap values = this.getFeatureAndTimeMostAndLeast(this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L)), screens);
        LinkedHashMap<String, LinkedList> overall_en = new LinkedHashMap<String, LinkedList>();
        overall_en.put("Overall", (LinkedList)values.get("en"));
        LinkedHashMap<String, LinkedList> overall_es = new LinkedHashMap<String, LinkedList>();
        overall_es.put("En total", (LinkedList)values.get("es"));
        graphData_en.put("Overall", overall_en);
        graphData_es.put("En total", overall_es);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }

    public Object getPagePerformanceAnalyticsOrderByScreenId(GetDataDashBoardRequest request) {
        return this.activityRepository.PAGE_PERFORMANCE_ANALYTICS(3L, request.getFromDate(), request.getToDate()).stream().map(tuple -> PageAndPerformance.builder().page_name(tuple.get("page_name")).page_name_es(tuple.get("page_name_es")).views(tuple.get("views")).time(tuple.get("time")).avg_time(tuple.get("avg_time")).build()).collect(Collectors.toList());
    }

    private String getDurationString(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return this.twoDigitString(hours) + ":" + this.twoDigitString(minutes) + ":" + this.twoDigitString(seconds %= 60L);
    }

    private String twoDigitString(long number) {
        if (number == 0L) {
            return "00";
        }
        if (number / 10L == 0L) {
            return "0" + number;
        }
        return String.valueOf(number);
    }
}

