/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sharedyouth.controller;

import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.sharedyouth.entity.SharedYouth;
import com.infinite.focus.server.sharedyouth.request.GetColleagueInstructorsRequest;
import com.infinite.focus.server.sharedyouth.request.ShareStudentWithInstructorsRequest;
import com.infinite.focus.server.sharedyouth.service.SharedYouthService;
import com.infinite.focus.server.sharedyouth.wrapper.GetColleagueInstructorWrapper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.SearchStudentRequest;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.wrapper.StudentClassWrapper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sharedyouth"})
public class SharedYouthController {
    private final AuthService authService;
    private final SharedYouthService sharedYouthService;
    private final StudentService studentService;
    private final MessageService messageService;

    public SharedYouthController(AuthService authService, SharedYouthService sharedYouthService, StudentService studentService, MessageService messageService) {
        this.authService = authService;
        this.sharedYouthService = sharedYouthService;
        this.studentService = studentService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/get/colleague/instructors"})
    @ResponseBody
    public ResponseEntity<List<GetColleagueInstructorWrapper>> getColleagueInstructors(@RequestHeader(value="Authorization") String token, @RequestBody GetColleagueInstructorsRequest request) {
        this.authService.isInstructor(token);
        List instructors = this.sharedYouthService.getColleagueInstructorsByInstructorId(request.getInstructor_id());
        List getColleagueInstructorWrappers = instructors.stream().map(i -> new GetColleagueInstructorWrapper(i.getFirst_name(), i.getLast_name(), i.getInstructor_id(), this.sharedYouthService.isStudentSharedWithInstructor(request.getStudent_id(), i.getInstructor_id()))).collect(Collectors.toList());
        return new ResponseEntity(getColleagueInstructorWrappers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/share/student/with/instructors"})
    @ResponseBody
    public ResponseEntity<List<SharedYouth>> shareStudentWithInstructors(@RequestHeader(value="Authorization") String token, @RequestBody ShareStudentWithInstructorsRequest request) {
        this.authService.isInstructor(token);
        return new ResponseEntity((Object)this.sharedYouthService.shareStudentWithInstructors(request.getStudent_id().longValue(), request.getInstructor_ids()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/students/by/instructor/and/demographic"})
    public ResponseEntity<List<StudentClassWrapper>> searchStudentByInstructorAndDemographic(@RequestHeader(value="Authorization") String token, @RequestBody SearchStudentRequest searchStudentRequest) {
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        List studentIds = this.sharedYouthService.getSharedYouthByInstructorId(i.getInstructor_id()).stream().map(SharedYouth::getStudent_id).collect(Collectors.toList());
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
        }
        for (Student s : this.studentService.searchStudentByDemographicAndIds(searchStudentRequest, studentIds)) {
            if (s.getStatus() == null || s.getStatus() == Status.PENDING) continue;
            StudentClassWrapper w = new StudentClassWrapper();
            w.setStudent(s);
            list.add(w);
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }
}

