/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.assessment.controller;

import com.infinite.focus.server.assessment.dto.AssessmentDTO;
import com.infinite.focus.server.assessment.request.GetByStudentIdAndBetweenFromDateAndToDateRequest;
import com.infinite.focus.server.assessment.request.GetByStudentIdAndStandardIdRequest;
import com.infinite.focus.server.assessment.service.AssessmentService;
import com.infinite.focus.server.assessment.wrapper.StudentAssessmentWrapper;
import com.infinite.focus.server.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/assessment"})
public class AssessmentController {
    private final AssessmentService assessmentService;

    public AssessmentController(AssessmentService assessmentService) {
        this.assessmentService = assessmentService;
    }

    @PostMapping(value={"/get-assessment-pv-state-by-student-id"})
    ResponseEntity<List<AssessmentDTO>> getAssessmentPVStateByStudentId(@RequestBody GetByStudentIdAndBetweenFromDateAndToDateRequest request) {
        System.out.println("GetByStudentIdAndBetweenFromDateAndToDateRequest FromDate: " + DateUtils.getDateInString((Date)request.getFrom_date()) + " toDate: " + DateUtils.getDateInString((Date)request.getTo_date()));
        return new ResponseEntity((Object)this.assessmentService.getByStudentIdAndBetweenFromDateAndToDate(request.getStudent_id(), request.getFrom_date(), request.getTo_date()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-pending-assessment-for-today"})
    ResponseEntity<StudentAssessmentWrapper> getPendingAssessmentForToday(@RequestBody GetByStudentIdAndStandardIdRequest request) {
        return new ResponseEntity((Object)StudentAssessmentWrapper.builder().assessmentWrapper(this.assessmentService.getPendingAssessmentForToday(request.getStudent_id(), request.getStandard_id())).build(), (HttpStatusCode)HttpStatus.OK);
    }
}

