/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.service.stats;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.service.stats.StatsService;
import com.infinite.focus.server.dashboard.service.stats.StatsServiceImpl;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.entity.Grade;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatsServiceImpl
implements StatsService {
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    PostRepository postRepository;
    @Autowired
    LessonRepository lessonRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    ActivityCriteriaRepository activityCriteriaRepository;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;
    String forwardSlash = "/";

    public Object getVideoViewList(GetDataDashBoardRequest request) {
        List results = request.getAscOrDesc().equals("DESC") ? this.activityRepository.getVideoViewListOrderByCountAndFullWatchedPercentageDesc() : this.activityRepository.getVideoViewListOrderByCountAndFullWatchedPercentageASC();
        LinkedList videoViewList = new LinkedList();
        for (Object[] result : results) {
            LinkedHashMap<String, Object> videosMap = new LinkedHashMap<String, Object>();
            Long entity_id = ((Number)result[0]).longValue();
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)entity_id);
            videosMap.put("Lesson", lesson);
            int count = ((Number)result[1]).intValue();
            if (count > 0) {
                videosMap.put("Views", count);
                String fullWatchPercentage = result[2].toString();
                videosMap.put("Full_Watch_Percentage", fullWatchPercentage);
                Long countOfWhoWatched = this.activityRepository.getCountOfStudentsWhoWatchedVideoByEnitityId(entity_id);
                videosMap.put("Unique_Users_That_Watched_Video", countOfWhoWatched);
                List repeateStudents = this.activityRepository.getRepeteVideoWatchStudentIdListByEntityId(entity_id);
                videosMap.put("Unique_Users_That_Watched_Video_Again", repeateStudents.size());
                long totalTime = ((Number)result[3]).longValue();
                videosMap.put("Time", DateUtils.getTimeInString((long)totalTime));
                long avgTime = ((Number)result[4]).longValue();
                videosMap.put("Avg_Time", DateUtils.getTimeInString((long)avgTime));
            } else {
                videosMap.put("Views", "-");
                videosMap.put("Full_Watch_Percentage", "-");
                videosMap.put("Unique_Users_That_Watched_Video", "-");
                videosMap.put("Unique_Users_That_Watched_Video_Again", "-");
                videosMap.put("Time", "-");
                videosMap.put("Avg_Time", "-");
            }
            videoViewList.add(videosMap);
        }
        return videoViewList;
    }

    public List<LabelAndValue> getVideosDemographicData(GetDataDashBoardRequest request) {
        ArrayList<LabelAndValue> graphData;
        block5: {
            block7: {
                block6: {
                    block4: {
                        graphData = new ArrayList<LabelAndValue>();
                        if (!AppUtils.isNotNullOrEmpty((List)request.getGenders())) break block4;
                        for (String gender : request.getGenders()) {
                            GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
                            getDataDashBoardRequest.getGenders().add(gender);
                            graphData.add(new LabelAndValue(gender, (double)this.getVideosDemographic(getDataDashBoardRequest)));
                        }
                        break block5;
                    }
                    if (!AppUtils.isNotNullOrEmpty((List)request.getAges())) break block6;
                    for (Integer age : request.getAges()) {
                        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
                        getDataDashBoardRequest.getAges().add(age);
                        graphData.add(new LabelAndValue(String.valueOf(age), (double)this.getVideosDemographic(getDataDashBoardRequest)));
                    }
                    break block5;
                }
                if (!AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) break block7;
                for (String ethnicity : request.getEthnicity()) {
                    GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
                    getDataDashBoardRequest.getEthnicity().add(ethnicity);
                    graphData.add(new LabelAndValue(ethnicity, (double)this.getVideosDemographic(getDataDashBoardRequest)));
                }
                break block5;
            }
            if (!AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) break block5;
            for (Long grade_id : request.getGradeIds()) {
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                graphData.add(new LabelAndValue(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), (double)this.getVideosDemographic(getDataDashBoardRequest)));
            }
        }
        return graphData;
    }

    public long getVideosDemographic(GetDataDashBoardRequest request) {
        List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityTypeIdAndEntityId(request, Long.valueOf(2L), request.getEntity_id());
        return activities.size();
    }

    public Object getPostArticleOrVideoViewList(GetDataDashBoardRequest request) {
        List posts = this.postRepository.getAllPostByPostTypeOrderByPostId(request.getPostType(), request.getAscOrDesc());
        LinkedList videoViewList = new LinkedList();
        List ids = posts.stream().map(PostDTO::getPost_id).collect(Collectors.toList());
        List allActivities = this.activityCriteriaRepository.getStudentActivitiesByActivityTypeIdAndEntityIdsAndStartDateTimeBetweenFormDateTimeAndToDateTime(Long.valueOf(4L), ids, request.getFromDate(), request.getToDate());
        for (PostDTO post : posts) {
            LinkedHashMap<String, Object> videosMap = new LinkedHashMap<String, Object>();
            videosMap.put("post", post);
            List activities = allActivities.stream().filter(c -> c.getEntity_id() == post.getPost_id()).collect(Collectors.toList());
            int count = activities.size();
            if (count > 0) {
                videosMap.put("views", count);
                long totalSeconds = this.getTotalTimeFromActivities(activities);
                if (post.getPost_type().equals((Object)PostType.VIDEO)) {
                    time = this.getDurationString(totalSeconds);
                    videosMap.put("time", time);
                } else {
                    time = this.getDurationString(totalSeconds);
                    videosMap.put("time", time);
                }
                long unique_users = this.getUniqueUsersFromActivities(activities);
                videosMap.put("unique_users", unique_users);
                long unique_repeat_users = this.getUniqueRepeatUsersFromActivities(activities);
                videosMap.put("unique_repeat_users", unique_repeat_users);
                if (post.getPost_type().equals((Object)PostType.VIDEO)) {
                    avg_time = this.getDurationString((long)Math.round(totalSeconds / (long)count));
                    videosMap.put("avg_time", avg_time);
                    String full_view_percentage = DigitUtils.formatDoubleToTwoDigitDecimal((Double)((double)this.getFullViewCountByPostDurationFromActivities(post.getPost_duration() == null ? 0L : post.getPost_duration(), activities) / (double)count * 100.0)) + "%";
                    videosMap.put("full_view_percentage", full_view_percentage);
                } else {
                    avg_time = this.getDurationString((long)Math.round(totalSeconds / (long)count));
                    videosMap.put("avg_time", avg_time);
                    videosMap.put("full_view_percentage", "-");
                }
            } else {
                videosMap.put("views", "-");
                videosMap.put("time", "-");
                videosMap.put("unique_users", "-");
                videosMap.put("unique_repeat_users", "-");
                videosMap.put("avg_time", "-");
                videosMap.put("full_view_percentage", "-");
            }
            videoViewList.add(videosMap);
        }
        return videoViewList;
    }

    private long getTotalTimeFromActivities(List<ActivityDTO> activities) {
        long totalSeconds = 0L;
        if (AppUtils.isNotNullOrEmpty(activities)) {
            for (int i = 0; i < activities.size(); ++i) {
                totalSeconds += activities.get(i).getWatch_duration();
            }
        }
        return totalSeconds;
    }

    private String getDurationString(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return this.twoDigitString(hours) + ":" + this.twoDigitString(minutes) + ":" + this.twoDigitString(seconds %= 60L);
    }

    private String twoDigitString(long number) {
        if (number == 0L) {
            return "00";
        }
        if (number / 10L == 0L) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    private long getUniqueUsersFromActivities(List<ActivityDTO> activities) {
        LinkedHashSet<Long> studentIds = new LinkedHashSet<Long>();
        if (AppUtils.isNotNullOrEmpty(activities)) {
            for (int i = 0; i < activities.size(); ++i) {
                studentIds.add(activities.get(i).getStudent_id());
            }
        }
        return studentIds.size();
    }

    private long getUniqueRepeatUsersFromActivities(List<ActivityDTO> activities) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (int x = 0; x < activities.size() - 1; ++x) {
            boolean duplicated = false;
            for (int y = x + 1; y < activities.size(); ++y) {
                if (activities.get(x).getStudent_id() != activities.get(y).getStudent_id()) continue;
                duplicated = true;
                break;
            }
            if (!duplicated) continue;
            result.add(activities.get(x).getStudent_id());
        }
        return result.size();
    }

    private long getFullViewCountByPostDurationFromActivities(long post_duration, List<ActivityDTO> activities) {
        int full_view_count = 0;
        if (AppUtils.isNotNullOrEmpty(activities)) {
            for (int i = 0; i < activities.size(); ++i) {
                if (activities.get(i).getWatch_duration() < post_duration) continue;
                ++full_view_count;
            }
        }
        return full_view_count;
    }

    public Object getPostArticlesOrVideosDemographicData(GetDataDashBoardRequest request) {
        ArrayList<LabelAndValue> graphData_en = new ArrayList<LabelAndValue>();
        ArrayList<LabelAndValue> graphData_es = new ArrayList<LabelAndValue>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityTypeIdAndEntityId(getDataDashBoardRequest, Long.valueOf(4L), request.getEntity_id());
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                long value = activities.stream().filter(activityDTO -> activityDTO.getGender().equalsIgnoreCase(genderItem.getGender())).count();
                graphData_en.add(new LabelAndValue(genderItem.getGender(), (double)value));
                graphData_es.add(new LabelAndValue(genderItem.getGender_es(), (double)value));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityTypeIdAndEntityId(getDataDashBoardRequest, Long.valueOf(4L), request.getEntity_id());
            for (Integer age : request.getAges()) {
                long value = activities.stream().filter(activityDTO -> TimeUtils.getAge((Date)activityDTO.getDate_of_birth()) == age).count();
                graphData_en.add(new LabelAndValue(String.valueOf(age), (double)value));
                graphData_es.add(new LabelAndValue(String.valueOf(age), (double)value));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityTypeIdAndEntityId(getDataDashBoardRequest, Long.valueOf(4L), request.getEntity_id());
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                long value = activities.stream().filter(activityDTO -> activityDTO.getEthnicity().equalsIgnoreCase(ethnicityItem.getEthnicity())).count();
                graphData_en.add(new LabelAndValue(ethnicityItem.getEthnicity(), (double)value));
                graphData_es.add(new LabelAndValue(ethnicityItem.getEthnicity_es(), (double)value));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityTypeIdAndEntityId(getDataDashBoardRequest, Long.valueOf(4L), request.getEntity_id());
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                long value = activities.stream().filter(activityDTO -> activityDTO.getGrade_id().longValue() == gradeView.getGrade_id()).count();
                graphData_en.add(new LabelAndValue(gradeView.getGrade_name(), (double)value));
                graphData_es.add(new LabelAndValue(gradeView.getGrade_name_es(), (double)value));
            }
        }
        LinkedHashMap<String, ArrayList<LabelAndValue>> graphData = new LinkedHashMap<String, ArrayList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getTimeSpentByStudents(GetDataDashBoardRequest request) {
        List activities;
        GetDataDashBoardRequest getDataDashBoardRequest;
        Date firstStudentCreatedDate = this.studentRepository.getFirstStudentCreatedDate();
        Date fromDate = firstStudentCreatedDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentCreatedDate);
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genders_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            List activitiesOfGenders = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L));
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                activities = activitiesOfGenders.stream().filter(c -> c.getGender().equalsIgnoreCase(gender)).collect(Collectors.toList());
                genders_en.put(gender, this.getTimeSpent(activities, fromDate, toDate, getDataDashBoardRequest.getTimeZone()));
                genders_es.put(genderItem.getGender_es(), (LinkedList)genders_en.get(gender));
            }
            graphData_en.put("Gender", genders_en);
            graphData_es.put("G\u00e9nero", genders_es);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages = new LinkedHashMap<String, LinkedList>();
            GetDataDashBoardRequest getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest2.getAges().addAll(request.getAges());
            List activitiesOfAges = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest2, Long.valueOf(1L));
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                List activities2 = activitiesOfAges.stream().filter(c -> TimeUtils.getAge((Date)c.getDate_of_birth()) == age).collect(Collectors.toList());
                ages.put(String.valueOf(age), this.getTimeSpent(activities2, fromDate, toDate, getDataDashBoardRequest2.getTimeZone()));
            }
            graphData_en.put("Age", ages);
            graphData_es.put("Edad", ages);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            List activitiesOfEthnicities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L));
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                activities = activitiesOfEthnicities.stream().filter(c -> c.getEthnicity().equalsIgnoreCase(ethnicity)).collect(Collectors.toList());
                ethnicityMap_en.put(ethnicity, this.getTimeSpent(activities, fromDate, toDate, getDataDashBoardRequest.getTimeZone()));
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), (LinkedList)ethnicityMap_en.get(ethnicity));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            graphData_es.put("Etnia", ethnicityMap_es);
        }
        System.out.println(DateUtils.yearMonthDateHoursMinutesSeconds.format(new Date()));
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> grades_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            List activitiesOfGrades = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L));
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                activities = activitiesOfGrades.stream().filter(c -> c.getGrade_id() == grade_id).collect(Collectors.toList());
                grades_en.put(gradeView.getGrade_name(), this.getTimeSpent(activities, fromDate, toDate, getDataDashBoardRequest.getTimeZone()));
                grades_es.put(gradeView.getGrade_name_es(), (LinkedList)grades_en.get(gradeView.getGrade_name()));
            }
            graphData_en.put("Grade", grades_en);
            graphData_es.put("Grado", grades_es);
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getTimeSpentByTeachers(GetDataDashBoardRequest request) {
        System.out.println("----------------------------- TIME_SPENT_BY_TEACHERS------------------------------");
        Date firstInstructorCreatedDate = this.instructorRepository.getFirstInstructorCreatedDate();
        Date fromDate = firstInstructorCreatedDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : firstInstructorCreatedDate;
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> grades_es = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades_en.put(gradeView.getGrade_name(), this.getTimeSpent(this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate, getDataDashBoardRequest.getTimeZone()));
                grades_es.put(gradeView.getGrade_name_es(), (LinkedList)grades_en.get(gradeView.getGrade_name()));
            }
            graphData_en.put("Grade", grades_en);
            graphData_es.put("Grado", grades_es);
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithRequest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setEntity_id(request.getEntity_id());
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setPostType(request.getPostType());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        getDataDashBoardRequest.setTimeZone(request.getTimeZone());
        return getDataDashBoardRequest;
    }

    public LinkedList<String> getTimeSpent(List<ActivityDTO> activities, Date fromDate, Date toDate, TimeZone timeZone) {
        LinkedList<String> reportings = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty(activities)) {
            long timeSpent = this.activityService.getTotalTimeSpent(activities);
            System.out.println("Time Spent Diff - " + timeSpent + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            Long dailyTimeSpent = Math.round((double)timeSpent / days);
            System.out.println("dailyTimeSpent - " + dailyTimeSpent + " = timeSpent: " + timeSpent + " / Days: " + days);
            reportings.add(DateUtils.getTimeInString((long)dailyTimeSpent));
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            Long weeklyTimeSpent = Math.round((double)timeSpent / weeks);
            System.out.println("weeklyTimeSpent - " + weeklyTimeSpent + " = timeSpent: " + timeSpent + " / Weeks: " + weeks);
            reportings.add(DateUtils.getTimeInString((long)weeklyTimeSpent));
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            Long monthlyTimeSpent = Math.round((double)timeSpent / months);
            System.out.println("monthlyReporting - " + monthlyTimeSpent + " = timeSpent: " + timeSpent + " / Months: " + months);
            reportings.add(DateUtils.getTimeInString((long)monthlyTimeSpent));
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            Long yearlyTimeSpent = Math.round((double)timeSpent / years);
            System.out.println("yearlyTimeSpent - " + yearlyTimeSpent + " = timeSpent: " + timeSpent + " / Years: " + years);
            reportings.add(DateUtils.getTimeInString((long)yearlyTimeSpent));
        } else {
            reportings.add("00:00:00");
            reportings.add("00:00:00");
            reportings.add("00:00:00");
            reportings.add("00:00:00");
        }
        return reportings;
    }

    public Object getTimeSpentByDemographicsData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, List> graphData_en = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> graphData_es = new LinkedHashMap<String, List>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            values = this.getTimeSpentByDemographics(getDataDashBoardRequest);
            graphData_en.put("Gender", (List)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", (List)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            values = this.getTimeSpentByDemographics(getDataDashBoardRequest);
            graphData_en.put("Age", (List)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Edad", (List)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            values = this.getTimeSpentByDemographics(getDataDashBoardRequest);
            graphData_en.put("Ethnicity", (List)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", (List)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            values = this.getTimeSpentByDemographics(getSocioEmotionalDataAnalyticsRequest);
            graphData_en.put("Grade", (List)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Grado", (List)values.get("es"));
            }
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getTimeSpentByDemographics(GetDataDashBoardRequest request) {
        List activities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities, Language.getLanguage());
        ArrayList<LabelAndValue> labelAndValues_en = new ArrayList<LabelAndValue>();
        ArrayList<LabelAndValue> labelAndValues_es = new ArrayList<LabelAndValue>();
        for (String[] keys : activityMap.keySet()) {
            List values = (List)activityMap.get(keys);
            if (!values.isEmpty()) {
                long timeSpent = this.activityService.getTotalTimeSpent(values);
                double avgTime = DigitUtils.getAverage((Double)Double.valueOf(timeSpent / 1000L), (Double)60.0);
                System.out.println("getTimeSpentByDemographics " + keys[0] + "Time in double - " + timeSpent + " - Time in string " + DateUtils.getTimeInString((long)timeSpent));
                labelAndValues_en.add(new LabelAndValue(keys[0], avgTime));
                if (!Language.isSpanish()) continue;
                labelAndValues_es.add(new LabelAndValue(keys[1], avgTime));
                continue;
            }
            labelAndValues_en.add(new LabelAndValue(keys[0], 0.0));
            if (!Language.isSpanish()) continue;
            labelAndValues_es.add(new LabelAndValue(keys[1], 0.0));
        }
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        graphData.put("en", labelAndValues_en);
        if (Language.isSpanish()) {
            graphData.put("es", labelAndValues_es);
        }
        return graphData;
    }

    public Object getTimeSpentByDemographicData(GetDataDashBoardRequest request) {
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$DemographicType[request.getDemographicType().ordinal()]) {
            case 1: {
                return this.getStudentsTimeSpentByGender(request);
            }
            case 2: {
                return this.getStudentsTimeSpentByAge(request);
            }
            case 3: {
                return this.getStudentsTimeSpentByEthnicity(request);
            }
            case 4: {
                return this.getStudentsTimeSpentByGrade(request);
            }
        }
        return new LinkedHashMap();
    }

    public Object getStudentsTimeSpentByGender(GetDataDashBoardRequest request) {
        LinkedList<Object> list;
        long timeSpent;
        LinkedHashMap gendersAndAverageAndTime_en = new LinkedHashMap();
        LinkedHashMap<String, LinkedList> gendersAndAverageAndTime_es = new LinkedHashMap<String, LinkedList>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
        getSocioEmotionalDataAnalyticsRequest.getGenders().clear();
        getSocioEmotionalDataAnalyticsRequest.getGenders().addAll(request.getGenders());
        List activitiesOfGenders = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
        for (int i = 0; i < request.getGenders().size(); ++i) {
            String key = (String)request.getGenders().get(i);
            List activities = activitiesOfGenders.stream().filter(c -> c.getGender().equalsIgnoreCase(key)).collect(Collectors.toList());
            timeSpent = this.activityService.getTotalTimeSpent(activities);
            list = new LinkedList<Object>();
            list.add(timeSpent);
            System.out.println("Gender " + key + " Time Spent " + DateUtils.getTimeInString((long)timeSpent) + " Total Time Spent" + (totalTimeSpent += timeSpent));
            gendersAndTime.put(key, list);
        }
        for (String key : gendersAndTime.keySet()) {
            Gender gender = this.genderRepository.findByGender(key);
            timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            list = new LinkedList();
            Double percentage = DigitUtils.getPercentageInTwoDigit((Long)timeSpent, (Long)totalTimeSpent);
            System.out.println("GENDER timeSpent : " + timeSpent + " totalTimeSpent : " + totalTimeSpent + " percentage : " + percentage);
            list.add(percentage);
            list.add(DateUtils.getTimeInString((long)timeSpent));
            gendersAndAverageAndTime_en.put(key, list);
            gendersAndAverageAndTime_es.put(gender.getGender_es(), (LinkedList)gendersAndAverageAndTime_en.get(key));
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", gendersAndAverageAndTime_en);
        if (Language.isSpanish()) {
            graphData.put("es", gendersAndAverageAndTime_es);
        }
        return graphData;
    }

    public Object getStudentsTimeSpentByAge(GetDataDashBoardRequest request) {
        LinkedHashMap gendersAndAverageAndTime_en = new LinkedHashMap();
        LinkedHashMap<Object, LinkedList> gendersAndAverageAndTime_es = new LinkedHashMap<Object, LinkedList>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
        getSocioEmotionalDataAnalyticsRequest.getAges().clear();
        getSocioEmotionalDataAnalyticsRequest.getAges().addAll(request.getAges());
        List activitiesOfAges = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
        for (int i = 0; i < request.getAges().size(); ++i) {
            Object key = (Integer)request.getAges().get(i);
            List activities = activitiesOfAges.stream().filter(arg_0 -> StatsServiceImpl.lambda$getStudentsTimeSpentByAge$10((Integer)key, arg_0)).collect(Collectors.toList());
            long timeSpent = this.activityService.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gendersAndTime.put(String.valueOf(key), list);
        }
        for (Object key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            Double percentage = DigitUtils.getPercentageInTwoDigit((Long)timeSpent, (Long)totalTimeSpent);
            System.out.println("AGE timeSpent : " + timeSpent + " totalTimeSpent : " + totalTimeSpent + " percentage : " + percentage);
            list.add(percentage);
            list.add(DateUtils.getTimeInString((long)timeSpent));
            gendersAndAverageAndTime_en.put(key, list);
            gendersAndAverageAndTime_es.put(key, (LinkedList)gendersAndAverageAndTime_en.get(key));
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", gendersAndAverageAndTime_en);
        if (Language.isSpanish()) {
            graphData.put("es", gendersAndAverageAndTime_es);
        }
        return graphData;
    }

    public Object getStudentsTimeSpentByEthnicity(GetDataDashBoardRequest request) {
        LinkedList<Object> list;
        long timeSpent;
        LinkedHashMap gendersAndAverageAndTime_en = new LinkedHashMap();
        LinkedHashMap<String, LinkedList> gendersAndAverageAndTime_es = new LinkedHashMap<String, LinkedList>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
        getSocioEmotionalDataAnalyticsRequest.getEthnicity().clear();
        getSocioEmotionalDataAnalyticsRequest.getEthnicity().addAll(request.getEthnicity());
        List activitiesOfEthnicities = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
        for (int i = 0; i < request.getEthnicity().size(); ++i) {
            String key = (String)request.getEthnicity().get(i);
            List activities = activitiesOfEthnicities.stream().filter(c -> c.getEthnicity().equalsIgnoreCase(key)).collect(Collectors.toList());
            timeSpent = this.activityService.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            list = new LinkedList<Object>();
            list.add(timeSpent);
            gendersAndTime.put(key, list);
        }
        for (String key : gendersAndTime.keySet()) {
            Ethnicity ethnicity = this.ethnicityRepository.findByEthnicity(key);
            timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            list = new LinkedList();
            Double percentage = DigitUtils.getPercentageInTwoDigit((Long)timeSpent, (Long)totalTimeSpent);
            System.out.println("ETHNICITY timeSpent : " + timeSpent + " totalTimeSpent : " + totalTimeSpent + " percentage : " + percentage);
            list.add(percentage);
            list.add(DateUtils.getTimeInString((long)timeSpent));
            gendersAndAverageAndTime_en.put(key, list);
            gendersAndAverageAndTime_es.put(ethnicity.getEthnicity_es(), (LinkedList)gendersAndAverageAndTime_en.get(key));
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", gendersAndAverageAndTime_en);
        if (Language.isSpanish()) {
            graphData.put("es", gendersAndAverageAndTime_es);
        }
        return graphData;
    }

    public Object getStudentsTimeSpentByGrade(GetDataDashBoardRequest request) {
        LinkedList<Object> list;
        long timeSpent;
        LinkedHashMap gendersAndAverageAndTime_en = new LinkedHashMap();
        LinkedHashMap<String, LinkedList> gendersAndAverageAndTime_es = new LinkedHashMap<String, LinkedList>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
        getSocioEmotionalDataAnalyticsRequest.getGradeIds().clear();
        getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
        List activitiesOfAllGrades = this.activityCriteriaRepository.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
        for (int i = 0; i < request.getGradeIds().size(); ++i) {
            Object key = (Long)request.getGradeIds().get(i);
            List activities = activitiesOfAllGrades.stream().filter(arg_0 -> StatsServiceImpl.lambda$getStudentsTimeSpentByGrade$12((Long)key, arg_0)).collect(Collectors.toList());
            timeSpent = this.activityService.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            list = new LinkedList<Object>();
            list.add(timeSpent);
            gendersAndTime.put(((Grade)this.gradeRepository.getOne(key)).getGrade_name(), list);
        }
        for (Object key : gendersAndTime.keySet()) {
            GradeView grade = this.gradeRepository.findByGradeName((String)key);
            timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            list = new LinkedList();
            Double percentage = DigitUtils.getPercentageInTwoDigit((Long)timeSpent, (Long)totalTimeSpent);
            System.out.println("GRADE timeSpent : " + timeSpent + " totalTimeSpent : " + totalTimeSpent + " percentage : " + percentage);
            list.add(percentage);
            list.add(DateUtils.getTimeInString((long)timeSpent));
            gendersAndAverageAndTime_en.put(key, list);
            gendersAndAverageAndTime_es.put(grade.getGrade_name_es(), (LinkedList)gendersAndAverageAndTime_en.get(key));
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", gendersAndAverageAndTime_en);
        if (Language.isSpanish()) {
            graphData.put("es", gendersAndAverageAndTime_es);
        }
        return graphData;
    }

    public Object getTimeSpentByGradesData(GetDataDashBoardRequest request) {
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        for (Long grade_id : request.getGradeIds()) {
            GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithRequest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().add(grade_id);
            List activities = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(getSocioEmotionalDataAnalyticsRequest.getTimeLine(), activities, Language.getLanguage());
            ArrayList<LabelAndValue> labelAndValues_en = new ArrayList<LabelAndValue>();
            ArrayList<LabelAndValue> labelAndValues_es = new ArrayList<LabelAndValue>();
            for (String[] keys : activityMap.keySet()) {
                List values = (List)activityMap.get(keys);
                if (!values.isEmpty()) {
                    double appUsedTime = 0.0;
                    for (ActivityDTO activity : values) {
                        double differnce = (activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime()) / 1000L;
                        if (!(differnce >= 1.0)) continue;
                        appUsedTime += differnce;
                    }
                    labelAndValues_en.add(new LabelAndValue(keys[0], DigitUtils.getAverage((Double)appUsedTime, (Double)60.0).doubleValue()));
                    if (!Language.isSpanish()) continue;
                    labelAndValues_es.add(new LabelAndValue(keys[1], DigitUtils.getAverage((Double)appUsedTime, (Double)60.0).doubleValue()));
                    continue;
                }
                labelAndValues_en.add(new LabelAndValue(keys[0], 0.0));
                if (!Language.isSpanish()) continue;
                labelAndValues_es.add(new LabelAndValue(keys[1], 0.0));
            }
            graphData_en.put(gradeView.getGrade_name(), labelAndValues_en);
            if (!Language.isSpanish()) continue;
            graphData_es.put(gradeView.getGrade_name_es(), labelAndValues_es);
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets(graphData_es));
        }
        return graphData;
    }

    public Object getTimeSpentByGradeData(GetDataDashBoardRequest request) {
        LinkedList<Object> list;
        long timeSpent;
        LinkedHashMap gradesAndAverageAndTime_en = new LinkedHashMap();
        LinkedHashMap<String, LinkedList> gradesAndAverageAndTime_es = new LinkedHashMap<String, LinkedList>();
        LinkedHashMap gradesAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        ArrayList grade_ids = new ArrayList();
        grade_ids.addAll(request.getGradeIds());
        for (int i = 0; i < grade_ids.size(); ++i) {
            Object key = (Long)grade_ids.get(i);
            request.getGradeIds().clear();
            request.getGradeIds().add(key);
            List activities = this.activityCriteriaRepository.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
            timeSpent = this.activityService.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            list = new LinkedList();
            list.add(timeSpent);
            gradesAndTime.put(((Grade)this.gradeRepository.getOne(key)).getGrade_name(), list);
        }
        for (Object key : gradesAndTime.keySet()) {
            GradeView gradeView = this.gradeRepository.findByGradeName((String)key);
            timeSpent = (Long)((LinkedList)gradesAndTime.get(key)).get(0);
            list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(DateUtils.getTimeInString((long)timeSpent));
            gradesAndAverageAndTime_en.put(key, list);
            gradesAndAverageAndTime_es.put(gradeView.getGrade_name_es(), (LinkedList)gradesAndAverageAndTime_en.get(key));
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", gradesAndAverageAndTime_en);
        if (Language.isSpanish()) {
            graphData.put("es", gradesAndAverageAndTime_es);
        }
        return graphData;
    }

    private static /* synthetic */ boolean lambda$getStudentsTimeSpentByGrade$12(Long key, ActivityDTO c) {
        return c.getGrade_id() == key;
    }

    private static /* synthetic */ boolean lambda$getStudentsTimeSpentByAge$10(Integer key, ActivityDTO c) {
        return TimeUtils.getAge((Date)c.getDate_of_birth()) == key;
    }
}

