/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organizationadmin.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.client.ParentClient;
import com.infinite.focus.server.client.SchoolClient;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.repository.OrganizationAdminRepository;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.school.request.GetSchoolByIdRequest;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrganizationAdminServiceImpl
implements OrganizationAdminService {
    private final AccountService accountService;
    private final OrganizationAdminRepository organizationAdminRepository;
    private final EmailSenderService emailSenderService;
    private final TemplateService templateService;
    private final DistrictService districtService;
    private final ConfigurationService configurationService;
    private final CorporateService corporateService;
    private final ParentClient parentClient;
    private final SchoolClient schoolClient;

    public OrganizationAdminServiceImpl(AccountService accountService, OrganizationAdminRepository organizationAdminRepository, EmailSenderService emailSenderService, TemplateService templateService, DistrictService districtService, ConfigurationService configurationService, CorporateService corporateService, ParentClient parentClient, SchoolClient schoolClient) {
        this.accountService = accountService;
        this.organizationAdminRepository = organizationAdminRepository;
        this.emailSenderService = emailSenderService;
        this.templateService = templateService;
        this.districtService = districtService;
        this.configurationService = configurationService;
        this.corporateService = corporateService;
        this.parentClient = parentClient;
        this.schoolClient = schoolClient;
    }

    public OrganizationAdmin createOrganizationAdmin(String firstName, String lastName, String email, OrganizationType organization_type, long organization_id, String address, String city, String state) {
        String password = AppUtils.generatePassword();
        Account account = this.accountService.createAccountByEmailAndPassword(email, password);
        OrganizationAdmin organizationAdmin = new OrganizationAdmin();
        organizationAdmin.setAccount(account);
        organizationAdmin.setFirst_name(firstName);
        organizationAdmin.setLast_name(lastName);
        organizationAdmin.setAddress(address);
        organizationAdmin.setCity(city);
        organizationAdmin.setState(state);
        organizationAdmin.setOrganization_type(organization_type);
        organizationAdmin.setOrganization_id(organization_id);
        OrganizationAdmin admin = (OrganizationAdmin)this.organizationAdminRepository.save((Object)organizationAdmin);
        Object organizationName = "";
        String language = "";
        if (admin.getOrganization_type() == OrganizationType.LARGE_ORGANIZATION) {
            organizationName = this.districtService.getDistrictById(admin.getOrganization_id()).getDistrict_name();
            language = this.districtService.getDistrictById(admin.getOrganization_id()).getLanguage();
        } else if (admin.getOrganization_type() == OrganizationType.ORGANIZATION) {
            organizationName = this.schoolClient.getSchoolById(GetSchoolByIdRequest.builder().school_id(admin.getOrganization_id()).build()).getSchool_name();
            language = this.schoolClient.getSchoolById(GetSchoolByIdRequest.builder().school_id(admin.getOrganization_id()).build()).getLanguage();
        } else if (admin.getOrganization_type() == OrganizationType.CORPORATE) {
            organizationName = this.corporateService.getCorporateById(admin.getOrganization_id()).getCorporate_name();
            language = this.corporateService.getCorporateById(admin.getOrganization_id()).getLanguage();
        } else if (admin.getOrganization_type() == OrganizationType.PARENT) {
            organizationName = this.parentClient.getParentById(GetByIdRequest.builder().id(admin.getOrganization_id()).build()).getFirst_name() + " " + this.parentClient.getParentById(GetByIdRequest.builder().id(admin.getOrganization_id()).build()).getLast_name();
            language = this.parentClient.getParentById(GetByIdRequest.builder().id(admin.getOrganization_id()).build()).getLanguage();
        }
        try {
            this.emailSenderService.sendHtmlMail(account.getUsername(), (Language.isSpanish((String)language) ? "Clymb Dashboard Acceso Para " : "Clymb Dashboard Access For ") + (String)organizationName, this.templateService.getSendEmailToOrganizationAdminForDashboardAccess(admin.getFirst_name(), (String)organizationName, this.configurationService.getConfiguration().getBaseUrl(), account.getUsername(), password, language));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return admin;
    }

    public List<OrganizationAdmin> findByOrganizationTypeAndAccountId(String organization_type, long account_id) {
        return this.organizationAdminRepository.findByOrganizationTypeAndAccountId(organization_type, account_id);
    }

    public OrganizationAdmin save(OrganizationAdmin organizationAdmin) {
        return (OrganizationAdmin)this.organizationAdminRepository.save((Object)organizationAdmin);
    }
}

