/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postcontent.controller;

import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.postcontent.request.CreatePostContentRequest;
import com.infinite.focus.server.postcontent.request.GetPostContentListByPostIdsRequest;
import com.infinite.focus.server.postcontent.service.PostContentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/post-content"})
public class PostContentController {
    @Autowired
    private PostContentService postContentService;

    @PostMapping(value={"/create"})
    public ResponseEntity<List<PostContentDTO>> create(@RequestBody CreatePostContentRequest request) {
        return new ResponseEntity((Object)this.postContentService.create(request.getPost_id(), request.getContent_ids()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-post-ids-by-content-ids"})
    public ResponseEntity<List<Long>> getPostIdsByContentIds(@RequestBody CreatePostContentRequest request) {
        return new ResponseEntity((Object)this.postContentService.getPostIdsByContentIds(request.getContent_ids()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-post-content-list-by-post-ids"})
    public ResponseEntity<List<PostContentDTO>> getPostContentListByPostIds(@RequestBody GetPostContentListByPostIdsRequest request) {
        return new ResponseEntity((Object)this.postContentService.getPostContentListByPostIds(request.getPost_ids()), (HttpStatusCode)HttpStatus.OK);
    }
}

