/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.youthsurveychoice.repository;

import com.infinite.focus.server.youthsurveychoice.entity.YouthSurveyChoice;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface YouthSurveyChoiceRepository
extends JpaRepository<YouthSurveyChoice, Long> {
    @Query(value="SELECT * FROM youth_survey_choice WHERE survey_id = ?1", nativeQuery=true)
    public List<YouthSurveyChoice> findBySurveyId(Long var1);

    @Query(value="SELECT * FROM youth_survey_choice WHERE student_id = ?1", nativeQuery=true)
    public List<YouthSurveyChoice> findByStudentId(long var1);

    @Query(value="SELECT * FROM youth_survey_choice WHERE survey_id = ?1 AND student_id = ?2 ORDER BY youth_survey_choice_id ASC", nativeQuery=true)
    public List<YouthSurveyChoice> findBySurveyIdAndStudentIdOrderByYouthSurveyChoiceASC(long var1, long var3);

    @Query(value="SELECT * FROM youth_survey_choice WHERE created_at BETWEEN ?1 AND ?2 ORDER BY created_at desc", nativeQuery=true)
    public List<YouthSurveyChoice> findByCreatedAtBetweenFromDateAndEndDateOrderByDESC(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT student_id) FROM youth_survey_choice WHERE created_at BETWEEN ?1 AND ?2", nativeQuery=true)
    public long countByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT y.student_id) FROM youth_survey_choice y WHERE y.created_at BETWEEN ?1 AND ?2 AND y.created_at < (SELECT MAX(act.start_date_time) FROM activity act WHERE act.activity_type_id = 1 AND act.student_id = y.student_id) ", nativeQuery=true)
    public long loginCountOfStudentForWhoLoggedAfterReceivingSurveyByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT student_id) FROM youth_survey_choice WHERE survey_choice_id > 0 AND created_at BETWEEN ?1 AND ?2", nativeQuery=true)
    public long countFilledByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT * FROM youth_survey_choice WHERE updated_at BETWEEN ?1 AND ?2 ORDER BY updated_at desc", nativeQuery=true)
    public List<YouthSurveyChoice> findByUpdatedAtBetweenFromDateAndEndDateOrderByDESC(String var1, String var2);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM youth_survey_choice WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM youth_survey_choice WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);
}

