/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.freetrial.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.freetrial.request.FreeTrialRequest;
import com.infinite.focus.server.freetrial.request.GetFreeTrialsRequest;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.freetrial.wrapper.FreeTrialWrapper;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/free-trial"})
public class FreeTrialController {
    @Autowired
    AuthService authService;
    @Autowired
    FreeTrialService freeTrialService;

    @PostMapping(value={"/get/free-trials"})
    @ResponseBody
    public ResponseEntity<Page<FreeTrialWrapper>> getFreeTrials(@RequestHeader(value="Authorization") String token, @RequestBody GetFreeTrialsRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.freeTrialService.getFreeTrials(request), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/create/free-trial"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, Object>> createFreeTrial(@RequestHeader(value="Authorization") String token, @RequestBody FreeTrialRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.freeTrialService.createFreeTrial(request), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/create/free-trial/corporate"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, Object>> createFreeTrialCorporate(@RequestHeader(value="Authorization") String token, @RequestBody FreeTrialRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.freeTrialService.createFreeTrialForCorporate(request), (HttpStatusCode)HttpStatus.OK);
    }
}

