/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.mobile.controller;

import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mobile.dto.MobileDTO;
import com.infinite.focus.server.mobile.service.MobileService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mobile"})
public class MobileController {
    private final MobileService mobileService;
    private final MessageService messageService;

    public MobileController(MobileService mobileService, MessageService messageService) {
        this.mobileService = mobileService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/get-configuration"})
    ResponseEntity<MobileDTO> getConfiguration() {
        List mobileDTOS = this.mobileService.getAll();
        if (AppUtils.isNullOrEmpty((List)mobileDTOS)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.mobile.configuration.is.not.found"));
        }
        return new ResponseEntity((Object)((MobileDTO)mobileDTOS.get(0)), (HttpStatusCode)HttpStatus.OK);
    }
}

