/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.relationshipskills.repository;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.relationshipskills.dto.RelationshipSkillsUpdateDTO;
import com.infinite.focus.server.relationshipskills.repository.RelationshipSkillsUpdateCriteriaRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class RelationshipSkillsUpdateCriteriaRepositoryImpl
implements RelationshipSkillsUpdateCriteriaRepository {
    @Autowired
    EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static RelationshipSkillsUpdateDTO mapRow(ResultSet rs, int i) throws SQLException {
        return RelationshipSkillsUpdateDTO.builder().relationship_skills_update_id(rs.getLong("relationship_skills_update_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).score(rs.getDouble("score")).original_scores(rs.getString("original_scores")).data_set_ids(rs.getString("data_set_ids")).text(rs.getString("text")).text_es(rs.getString("text_es")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public List<AssessmentOccurrence> getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate, AssessmentChildCategory assessmentChildCategory) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.mapToAssessmentOccurance(assessmentChildCategory, new ArrayList());
        }
        Query query = this.entityManager.createNativeQuery("SELECT distinct substring_index(substring_index(text,',',?1),',',-1) AS text_to_display, substring_index(substring_index(text_es,',',?1),',',-1) AS text_to_display_es, substring_index(substring_index(data_set_ids,',',?1),',',-1) AS data_set_id, count(*) AS occurrence, COALESCE(ROUND((count(*)/?2),2),0.00) AS count FROM relationship_skills_update WHERE relationship_skills_update.student_id IN(?3) AND created_at BETWEEN ?4 AND ?5 GROUP BY data_set_id, text_to_display, text_to_display_es ORDER BY data_set_id", Tuple.class).setParameter(1, (Object)this.getPosition(assessmentChildCategory)).setParameter(2, (Object)studentIds.size()).setParameter(3, studentIds).setParameter(4, (Object)fromDate).setParameter(5, (Object)toDate);
        List list = query.getResultList();
        return this.mapToAssessmentOccurance(assessmentChildCategory, list.stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), ((BigDecimal)tuple.get("count", BigDecimal.class)).doubleValue(), ((Long)tuple.get("occurrence", Long.class)).longValue(), 0.0, null)).collect(Collectors.toList()));
    }

    public List<AssessmentOccurrence> mapToAssessmentOccurance(AssessmentChildCategory assessmentChildCategory, List<AssessmentOccurrence> list) {
        List textToDisplayList = this.getTextToDisplay(assessmentChildCategory);
        if (!AppUtils.isNullOrEmpty(list)) {
            for (AssessmentOccurrence a : textToDisplayList) {
                list.stream().filter(o -> o.getText_to_display().equals(a.getText_to_display()) && o.getText_to_display_es().equals(a.getText_to_display_es())).findFirst().ifPresent(o -> {
                    a.setCount(o.getCount());
                    a.setOccurrence(o.getOccurrence());
                });
            }
        }
        long totalOccurrence = textToDisplayList.stream().map(AssessmentOccurrence::getOccurrence).reduce(0L, Long::sum);
        return textToDisplayList.stream().peek(t -> t.setOccurrence_average(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)t.getOccurrence() / (double)totalOccurrence * 100.0)).doubleValue())).collect(Collectors.toList());
    }

    public int getPosition(AssessmentChildCategory assessmentChildCategory) {
        if (assessmentChildCategory.equals((Object)AssessmentChildCategory.COMMUNICATION)) {
            return 1;
        }
        if (assessmentChildCategory.equals((Object)AssessmentChildCategory.WORKING_TOGETHER)) {
            return 2;
        }
        if (assessmentChildCategory.equals((Object)AssessmentChildCategory.ASK_FOR_HELP)) {
            return 3;
        }
        if (assessmentChildCategory.equals((Object)AssessmentChildCategory.PEER_PRESSURE)) {
            return 4;
        }
        return 0;
    }

    public List<AssessmentOccurrence> getTextToDisplay(AssessmentChildCategory assessmentChildCategory) {
        Query query = this.entityManager.createNativeQuery("SELECT distinct substring_index(substring_index(text,',',?1),',',-1) AS text_to_display, substring_index(substring_index(text_es,',',?1),',',-1) AS text_to_display_es, substring_index(substring_index(data_set_ids,',',?1),',',-1) AS data_set_id FROM relationship_skills_update GROUP BY data_set_id, text_to_display, text_to_display_es ORDER BY data_set_id", Tuple.class).setParameter(1, (Object)this.getPosition(assessmentChildCategory));
        List items = query.getResultList();
        List<AssessmentOccurrence> list = items.stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), 0.0, 0L, 0.0, null)).collect(Collectors.toList());
        return list;
    }

    public List<RelationshipSkillsUpdateDTO> findByStudentIdsAndBetweenFromDateAndToDate2(Set<Long> student_ids, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<RelationshipSkillsUpdateDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String SQL = "SELECT * FROM relationship_skills_update re_up WHERE re_up.student_id IN(%S) AND re_up.created_at BETWEEN ? AND ? ORDER BY re_up.created_at DESC ";
        List relationshipSkillsUpdateDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), RelationshipSkillsUpdateCriteriaRepositoryImpl::mapRow);
        return relationshipSkillsUpdateDTOS;
    }

    public List<AssessmentOccurrence> getTextToDisplay2(AssessmentChildCategory assessmentChildCategory) {
        String SQL = "SELECT distinct substring_index(substring_index(text,',',?),',',-1) AS text_to_display, substring_index(substring_index(text_es,',',?),',',-1) AS text_to_display_es, substring_index(substring_index(data_set_ids,',',?),',',-1) AS data_set_id FROM relationship_skills_update GROUP BY data_set_id, text_to_display, text_to_display_es ORDER BY data_set_id ";
        List assessmentOccurrences = this.jdbcTemplate.query(SQL, (rs, i) -> AssessmentOccurrence.builder().text_to_display(rs.getString("text_to_display")).text_to_display_es(rs.getString("text_to_display_es")).mood_id(0L).count(0.0).occurrence(0L).occurrence_average(0.0).build(), new Object[]{this.getPosition(assessmentChildCategory), this.getPosition(assessmentChildCategory), this.getPosition(assessmentChildCategory)});
        return assessmentOccurrences;
    }

    public RelationshipSkillsUpdateDTO findById(long relationship_skills_update_id) {
        String SQL = "SELECT * FROM relationship_skills_update WHERE relationship_skills_update_id = ? ";
        try {
            return (RelationshipSkillsUpdateDTO)this.jdbcTemplate.queryForObject(SQL, RelationshipSkillsUpdateCriteriaRepositoryImpl::mapRow, new Object[]{relationship_skills_update_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getTextToDisplay3(AssessmentChildCategory assessmentChildCategory) {
        String SQL = "SELECT distinct substring_index(substring_index(text,',',?),',',-1) AS text_to_display, substring_index(substring_index(text_es,',',?),',',-1) AS text_to_display_es, substring_index(substring_index(data_set_ids,',',?),',',-1) AS data_set_id FROM relationship_skills_update GROUP BY data_set_id, text_to_display, text_to_display_es ORDER BY data_set_id ";
        List occurrenceAndOccurrenceAverages = this.jdbcTemplate.query(SQL, (rs, i) -> OccurrenceAndOccurrenceAverage.builder().text_to_display(rs.getString("text_to_display")).text_to_display_es(rs.getString("text_to_display_es")).count(0.0).occurrence(0L).occurrence_average(0.0).build(), new Object[]{this.getPosition(assessmentChildCategory), this.getPosition(assessmentChildCategory), this.getPosition(assessmentChildCategory)});
        return occurrenceAndOccurrenceAverages;
    }
}

