/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostimage.repository;

import com.infinite.focus.server.wallpostimage.dto.WallPostImageDTO;
import com.infinite.focus.server.wallpostimage.repository.WallPostImageRepository;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class WallPostImageRepositoryImpl
implements WallPostImageRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static WallPostImageDTO mapRow(ResultSet rs, int i) throws SQLException {
        return WallPostImageDTO.builder().wall_post_image_id(rs.getLong("wall_post_image_id")).url(rs.getString("url")).url_es(rs.getString("url_es")).title(rs.getString("title")).title_es(rs.getString("title_es")).description(rs.getString("description")).description_es(rs.getString("description_es")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public WallPostImageDTO create(String url, String url_es, String title, String title_es, String description, String description_es) {
        String INSERT_SQL = "INSERT INTO wall_post_image (url, url_es, title, title_es, description, description_es, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO wall_post_image (url, url_es, title, title_es, description, description_es, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, url);
            ps.setString(2, url_es);
            ps.setString(3, title);
            ps.setString(4, title_es);
            ps.setString(5, description);
            ps.setString(6, description_es);
            ps.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(8, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int wall_post_image_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)wall_post_image_id);
    }

    public WallPostImageDTO findById(long id) {
        String SQL = "SELECT * FROM wall_post_image WHERE wall_post_image_id = ?";
        try {
            WallPostImageDTO wallPostImageDTO = (WallPostImageDTO)this.jdbcTemplate.queryForObject(SQL, WallPostImageRepositoryImpl::mapRow, new Object[]{id});
            return wallPostImageDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public WallPostImageDTO update(long wall_post_image_id, String url, String url_es, String title, String title_es, String description, String description_es) {
        String SQL = "UPDATE wall_post_image SET url = ?, url_es = ?, title = ?, title_es = ?, description = ?, description_es = ?, updated_at = ? WHERE wall_post_image_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE wall_post_image SET url = ?, url_es = ?, title = ?, title_es = ?, description = ?, description_es = ?, updated_at = ? WHERE wall_post_image_id = ? ", new Object[]{url, url_es, title, title_es, description, description_es, Timestamp.valueOf(LocalDateTime.now()), wall_post_image_id});
        if (updateCount == 1) {
            return this.findById(wall_post_image_id);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }

    public Page<WallPostImageDTO> findAll(Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM wall_post_image ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM wall_post_image ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), WallPostImageRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public Page<WallPostImageDTO> findByTitle(String title, Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM wall_post_image WHERE CASE WHEN ? IS NOT NULL THEN title LIKE '%" + title + "%' ELSE true END ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[]{title}, (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM wall_post_image WHERE CASE WHEN ? IS NOT NULL THEN title LIKE '%" + title + "%' ELSE true END ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), new Object[]{title}, WallPostImageRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM wall_post_image WHERE wall_post_image_id = ?";
        try {
            this.jdbcTemplate.update("DELETE FROM wall_post_image WHERE wall_post_image_id = ?", new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

