/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpost.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.wallpost.model.Reaction;
import com.infinite.focus.server.wallpost.model.WallPostType;
import com.infinite.focus.server.wallpostreaction.entity.WallPostReaction;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.annotations.CreationTimestamp;

@Entity
public class WallPost {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long wall_post_id;
    private long student_id;
    private long instructor_id;
    private long post_id;
    private long streak_id;
    private String text;
    private String type;
    private String title;
    private String description;
    private String title_es;
    private String description_es;
    private String image;
    private String wow_message;
    private String wow_message_es;
    @Enumerated(value=EnumType.STRING)
    @Column(name="wall_post_type", columnDefinition="enum('WALL_POST','RESOURCE_LIBRARY','BADGE','STREAK') default 'WALL_POST'")
    private WallPostType wall_post_type = WallPostType.WALL_POST;
    private Boolean isActive = false;
    private int likes = 0;
    private long views = 0L;
    private Boolean isDeleted = false;
    @Transient
    private Student student;
    public Date approved_date;
    public Date deleted_date;
    @OneToMany(targetEntity=WallPostReaction.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(nullable=true, name="wall_post_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"wallPost"})
    private Set<WallPostReaction> wallPostReactions = new HashSet();
    @Transient
    Reaction reaction;
    @CreationTimestamp
    public Date createdAt;

    public int getLikes() {
        return this.likes;
    }

    public void setLikes(int likes) {
        this.likes = likes;
    }

    public long getViews() {
        return this.views;
    }

    public void setViews(long views) {
        this.views = views;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public WallPostType getWall_post_type() {
        return this.wall_post_type;
    }

    public void setWall_post_type(WallPostType wall_post_type) {
        this.wall_post_type = wall_post_type;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public long getWall_post_id() {
        return this.wall_post_id;
    }

    public void setWall_post_id(long wall_post_id) {
        this.wall_post_id = wall_post_id;
    }

    public long getStudent_id() {
        return this.student_id;
    }

    public void setStudent_id(long student_id) {
        this.student_id = student_id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public long getInstructor_id() {
        return this.instructor_id;
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public long getPost_id() {
        return this.post_id;
    }

    public void setPost_id(long post_id) {
        this.post_id = post_id;
    }

    public long getStreak_id() {
        return this.streak_id;
    }

    public void setStreak_id(long streak_id) {
        this.streak_id = streak_id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle_es() {
        return this.title_es;
    }

    public void setTitle_es(String title_es) {
        this.title_es = title_es;
    }

    public String getDescription_es() {
        return this.description_es;
    }

    public void setDescription_es(String description_es) {
        this.description_es = description_es;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getWow_message() {
        return this.wow_message;
    }

    public void setWow_message(String wow_message) {
        this.wow_message = wow_message;
    }

    public String getWow_message_es() {
        return this.wow_message_es;
    }

    public void setWow_message_es(String wow_message_es) {
        this.wow_message_es = wow_message_es;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Student getStudent() {
        return this.student;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public Date getApproved_date() {
        return this.approved_date;
    }

    public void setApproved_date(Date approved_date) {
        this.approved_date = approved_date;
    }

    public Date getDeleted_date() {
        return this.deleted_date;
    }

    public void setDeleted_date(Date deleted_date) {
        this.deleted_date = deleted_date;
    }

    public Map<Reaction, Long> getWallPostReactions() {
        return this.wallPostReactions.stream().collect(Collectors.groupingBy(WallPostReaction::getReaction, Collectors.counting()));
    }

    public Reaction getReaction() {
        return this.reaction;
    }

    public void setReaction(long student_id) {
        this.reaction = this.wallPostReactions.stream().filter(wallPostReaction -> wallPostReaction.getStudent().getStudent_id() == student_id).findFirst().map(WallPostReaction::getReaction).orElse(null);
    }

    public void setWallPostReactions(Set<WallPostReaction> wallPostReactions) {
        this.wallPostReactions = wallPostReactions;
    }
}

