/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.confirmationtoken.entity;

import com.infinite.focus.server.account.entity.Account;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.UUID;

@Entity
public class ConfirmationToken {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="token_id")
    private long tokenid;
    @Column(name="confirmation_token")
    private String confirmationToken;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="account_id", foreignKey=@ForeignKey(name="none"))
    private Account account;

    public ConfirmationToken() {
    }

    public ConfirmationToken(Account account) {
        this.account = account;
        this.createdDate = new Date();
        this.confirmationToken = UUID.randomUUID().toString();
    }

    public String getConfirmationToken() {
        return this.confirmationToken;
    }

    public void setConfirmationToken(String confirmationToken) {
        this.confirmationToken = confirmationToken;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public long getTokenid() {
        return this.tokenid;
    }

    public void setTokenid(long tokenid) {
        this.tokenid = tokenid;
    }
}

