/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.askforhelp.repository;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.repository.AskForHelpRepository;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class AskForHelpRepositoryImpl
implements AskForHelpRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public AskForHelpDTO create(long student_id, long mood_update_id) {
        String INSERT_SQL = "INSERT INTO ask_for_help (student_id, mood_update_id, sos_request_id, created_at, updated_at) VALUES (?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO ask_for_help (student_id, mood_update_id, sos_request_id, created_at, updated_at) VALUES (?,?,?,?,?)", 1);
            ps.setLong(1, student_id);
            ps.setLong(2, mood_update_id);
            ps.setLong(3, 0L);
            ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int ask_for_help_id = Objects.requireNonNull(holder.getKey()).intValue();
        return AskForHelpDTO.builder().ask_for_help_id((long)ask_for_help_id).student_id(student_id).mood_update_id(mood_update_id).sos_request_id(0L).build();
    }

    public List<AskForHelpDTO> findByStudentIdOrderByCreatedAtDESC(long student_id) {
        String SQL = "SELECT * FROM ask_for_help WHERE student_id = ? ORDER BY created_at DESC";
        List askForHelpDTOS = this.jdbcTemplate.query(SQL, new Object[]{student_id}, (rs, rowNum) -> AskForHelpDTO.builder().ask_for_help_id(rs.getLong("ask_for_help_id")).student_id(rs.getLong("student_id")).mood_update_id(rs.getLong("mood_update_id")).sos_request_id(rs.getLong("sos_request_id")).build());
        return askForHelpDTOS;
    }

    public AskForHelpDTO setSOSRequestId(long ask_for_help_id, long sos_request_id) {
        String SQL = "UPDATE ask_for_help SET sos_request_id = ?, updated_at = ? WHERE ask_for_help_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE ask_for_help SET sos_request_id = ?, updated_at = ? WHERE ask_for_help_id = ? ", new Object[]{sos_request_id, Timestamp.valueOf(LocalDateTime.now()), ask_for_help_id});
        if (updateCount == 1) {
            return this.findById(ask_for_help_id);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }

    public AskForHelpDTO findById(long ask_for_help_id) {
        String SQL = "SELECT * FROM ask_for_help WHERE ask_for_help_id = ?";
        return (AskForHelpDTO)this.jdbcTemplate.queryForObject(SQL, (rs, i) -> AskForHelpDTO.builder().ask_for_help_id(rs.getLong("ask_for_help_id")).student_id(rs.getLong("student_id")).mood_update_id(rs.getLong("mood_update_id")).sos_request_id(rs.getLong("sos_request_id")).build(), new Object[]{ask_for_help_id});
    }
}

