/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.data.controller;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.client.MoodAndStandardClient;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.data.model.MoodOccurance;
import com.infinite.focus.server.data.request.DataApiRequest;
import com.infinite.focus.server.data.service.DataService;
import com.infinite.focus.server.data.wrapper.AssessmentDataWrapper;
import com.infinite.focus.server.data.wrapper.SocioEmotionalDataWrapper;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.lessonrecord.entity.LessonRecord;
import com.infinite.focus.server.lessonrecord.repository.LessonRecordRepository;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.test.entity.Test;
import com.infinite.focus.server.test.repository.TestRepository;
import com.infinite.focus.server.testresult.entity.TestResult;
import com.infinite.focus.server.testresult.repository.TestResultRepository;
import com.infinite.focus.server.testresultgrade.entity.TestResultGrade;
import com.infinite.focus.server.testresultgrade.repository.TestResultGradeRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/data"})
public class DataController {
    private final InstructorRepository instructorRepository;
    private final MoodUpdateRepository moodUpdateRepository;
    private final ClassRepository classRepository;
    private final TestRepository testRepository;
    private final TestResultRepository testResultRepository;
    private final TestResultGradeRepository testResultGradeRepository;
    private final LessonRepository lessonRepository;
    private final LessonRecordRepository lessonRecordRepository;
    private final SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    private final MoodRepository moodRepository;
    private final DataSetService dataSetService;
    private final DataService dataService;
    private final ConfigurationRepository configurationRepository;
    private final ClassService classService;
    private final StudentRepository studentRepository;
    private final AuthService authService;
    private final MoodAndStandardClient moodAndStandardClient;

    public DataController(InstructorRepository instructorRepository, MoodUpdateRepository moodUpdateRepository, ClassRepository classRepository, TestRepository testRepository, TestResultRepository testResultRepository, TestResultGradeRepository testResultGradeRepository, LessonRepository lessonRepository, LessonRecordRepository lessonRecordRepository, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, MoodRepository moodRepository, DataSetService dataSetService, DataService dataService, ConfigurationRepository configurationRepository, ClassService classService, StudentRepository studentRepository, AuthService authService, MoodAndStandardClient moodAndStandardClient) {
        this.instructorRepository = instructorRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.classRepository = classRepository;
        this.testRepository = testRepository;
        this.testResultRepository = testResultRepository;
        this.testResultGradeRepository = testResultGradeRepository;
        this.lessonRepository = lessonRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.moodRepository = moodRepository;
        this.dataSetService = dataSetService;
        this.dataService = dataService;
        this.configurationRepository = configurationRepository;
        this.classService = classService;
        this.studentRepository = studentRepository;
        this.authService = authService;
        this.moodAndStandardClient = moodAndStandardClient;
    }

    @PostMapping(value={"/get/socio/emotional/data"})
    public ResponseEntity<List<SocioEmotionalTestResult>> getSocioEmotionalRecords(@RequestBody DataApiRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSZ", Locale.getDefault());
        dateFormat.setTimeZone(request.getTimeZone());
        System.out.println(dateFormat.format(request.getFromDate()));
        System.out.println(dateFormat.format(request.getToDate()));
        String from_date = DateUtils.getDateInString((Date)request.getFromDate());
        String to_date = DateUtils.getDateInString((Date)request.getToDate());
        System.out.println(from_date);
        System.out.println(to_date);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(request.getTimeZone());
        List results = this.socioEmotionalTestResultRepository.findByStudentIdOrderByCreatedAtLatestToOldestBetweenFromDateAndEndDate(request.getStudent_id(), from_date, to_date);
        String date = null;
        ArrayList socioEmotionalTestResults = new ArrayList(results);
        for (SocioEmotionalTestResult t : results) {
            String createdAt = format.format(t.getCreatedAt());
            if (date == null || !date.equals(createdAt)) {
                date = createdAt;
                continue;
            }
            if (!date.equals(createdAt)) continue;
            socioEmotionalTestResults.remove(t);
        }
        Collections.sort(socioEmotionalTestResults, Comparator.comparing(SocioEmotionalTestResult::getCreatedAt));
        return new ResponseEntity(socioEmotionalTestResults, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/socio/emotional/data/by/instructor"})
    public ResponseEntity<List<SocioEmotionalDataWrapper>> getSocioEmotionalRecordsByInstructor(@RequestBody DataApiRequest request) {
        String from_date = DateUtils.getDateInString((Date)request.getFromDate());
        String to_date = DateUtils.getDateInString((Date)request.getToDate());
        List students = this.studentRepository.findByInstructorIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(request.getInstructor_id());
        ArrayList<SocioEmotionalDataWrapper> list = new ArrayList<SocioEmotionalDataWrapper>();
        for (Student s : students) {
            for (SocioEmotionalTestResult t : this.socioEmotionalTestResultRepository.findByStudentIdAndBetweenFromDateAndEndDate(Long.valueOf(s.getStudent_id()), from_date, to_date)) {
                boolean found = false;
                for (SocioEmotionalDataWrapper sdw : list) {
                    if (t.getCreatedAt().getMonth() + 1 != sdw.month || t.getCreatedAt().getYear() + 1900 != sdw.year) continue;
                    sdw.score += t.score;
                    ++sdw.count;
                    found = true;
                }
                if (found) continue;
                list.add(new SocioEmotionalDataWrapper(t.score, 1, t.getCreatedAt().getMonth() + 1, t.getCreatedAt().getYear() + 1900));
            }
        }
        for (SocioEmotionalDataWrapper a : list) {
            a.score /= a.count;
        }
        Collections.sort(list, Comparator.comparing(SocioEmotionalDataWrapper::getYear).thenComparing(SocioEmotionalDataWrapper::getMonth));
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/socio/emotional/data/by/class"})
    public ResponseEntity<Object> getSocioEmotionalRecordsByClass(@RequestBody DataApiRequest request) {
        return new ResponseEntity(this.dataService.getSocioEmotionalRecordsByClass(request), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data/by/class"})
    public ResponseEntity<List<AssessmentDataWrapper>> getAssessmentByClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        List studentViews = this.classService.findStudentsByClassId(class_id.longValue());
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (StudentView studentView : studentViews) {
            for (LessonRecord l : this.lessonRecordRepository.findByStudentId(studentView.getStudent_id())) {
                AssessmentDataWrapper adw = new AssessmentDataWrapper();
                Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
                if (lesson == null) {
                    new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                adw.setLesson(lesson);
                Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
                if (test == null) {
                    new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                adw.setTest(test);
                TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), studentView.getStudent_id());
                if (testResult != null) {
                    TestResultGrade trg = this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id()));
                    if (trg != null) {
                        adw.setGrade(trg.getGrade());
                    } else {
                        adw.setGrade(0.0f);
                    }
                    adw.setTestResult(testResult);
                }
                boolean found = false;
                for (AssessmentDataWrapper a : list) {
                    if (a.getTest().getTest_id() != adw.getTest().getTest_id()) continue;
                    a.setCount(a.getCount() + 1);
                    a.setGrade(a.getGrade() + adw.getGrade());
                    found = true;
                }
                if (found) continue;
                adw.setCount(adw.getCount() + 1);
                list.add(adw);
            }
        }
        for (AssessmentDataWrapper a : list) {
            a.setGrade(a.getGrade() / (float)a.getCount());
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data"})
    public ResponseEntity<List<AssessmentDataWrapper>> getRecords(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(student_id)) {
            AssessmentDataWrapper adw = new AssessmentDataWrapper();
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
            if (lesson == null) {
                new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            adw.setLesson(lesson);
            Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
            if (test == null) {
                new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            adw.setTest(test);
            TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), student_id);
            if (testResult != null) {
                adw.setGrade(this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id())).getGrade());
                adw.setTestResult(testResult);
            }
            list.add(adw);
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/sel/analytics"})
    public ResponseEntity<Object> getSELAnalytics(@RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity(this.dataService.getSELAnalytics(request), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/sel/analytics/by/instructor"})
    public ResponseEntity<List<AssessmentOccurrence>> getSELAnalyticsByInstructor(@RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity((Object)this.dataService.getSELAnalyticsByInstructor(request), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/sel/analytics/by/class"})
    public ResponseEntity<Object> getSELAnalyticsByClass(@RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity(this.dataService.getSELAnalyticsByClass(request), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/sel/analytics/by/school"})
    public ResponseEntity<Object> getSELAnalyticsBySchool(@RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity(this.dataService.getSELAnalyticsBySchool(request), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/analysis"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysis(@RequestBody DataApiRequest request) {
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        for (MoodDTO m : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccurance(m.getMood(), m.getMood_es(), Double.valueOf(0.0)));
        }
        for (MoodDTO m : this.moodUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(request.getStudent_id().longValue(), request.getFromDate(), request.getToDate())) {
            for (MoodOccurance moodOccurance : list) {
                if (!this.containsMood(moodOccurance.getMood(), m.getText())) continue;
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals(moodOccurance.getMood())) continue;
                    o.setCount(Double.valueOf(o.getCount() + 1.0));
                }
            }
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/analysis/by/class"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysisByClass(@RequestBody DataApiRequest request) {
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        List studentViews = this.classService.findStudentsByClassId(request.getClass_id().longValue());
        for (MoodDTO moodDTO : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccurance(moodDTO.getMood(), moodDTO.getMood_es(), Double.valueOf(0.0)));
        }
        for (StudentView studentView : studentViews) {
            for (MoodUpdateDTO m : this.moodUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(studentView.getStudent_id().longValue(), request.getFromDate(), request.getToDate())) {
                for (MoodOccurance moodOccurance : list) {
                    if (!this.containsMood(moodOccurance.getMood(), m.getText())) continue;
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals(moodOccurance.getMood())) continue;
                        o.setCount(Double.valueOf(o.getCount() + 1.0));
                    }
                }
            }
        }
        for (MoodOccurance moodOccurance : list) {
            moodOccurance.count = moodOccurance.count / (double)studentViews.size();
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/socio/emotional/data/by/school"})
    public ResponseEntity<Object> getSocioEmotionalRecordsBySchool(@RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity(this.dataService.getSocioEmotionalRecordsBySchool(request), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data/by/school"})
    public ResponseEntity<List<AssessmentDataWrapper>> getAssessmentBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List instructors = this.instructorRepository.findBySchoolId(school_id);
        ArrayList studentViews = new ArrayList();
        for (Instructor i : instructors) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                studentViews.addAll(this.classService.findStudentsByClassId(c.getClass_id()));
            }
        }
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (StudentView studentView : studentViews) {
            for (LessonRecord l : this.lessonRecordRepository.findByStudentId(studentView.getStudent_id())) {
                AssessmentDataWrapper adw = new AssessmentDataWrapper();
                Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
                if (lesson == null) {
                    new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                adw.setLesson(lesson);
                Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
                if (test == null) {
                    new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                adw.setTest(test);
                TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), studentView.getStudent_id());
                if (testResult != null) {
                    TestResultGrade trg = this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id()));
                    if (trg != null) {
                        adw.setGrade(trg.getGrade());
                    } else {
                        adw.setGrade(0.0f);
                    }
                    adw.setTestResult(testResult);
                }
                boolean found = false;
                for (AssessmentDataWrapper a : list) {
                    if (a.getTest().getTest_id() != adw.getTest().getTest_id()) continue;
                    a.setCount(a.getCount() + 1);
                    a.setGrade(a.getGrade() + adw.getGrade());
                    found = true;
                }
                if (found) continue;
                adw.setCount(adw.getCount() + 1);
                list.add(adw);
            }
        }
        for (AssessmentDataWrapper a : list) {
            a.setGrade(a.getGrade() / (float)a.getCount());
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/analysis/by/school"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysisBySchool(@RequestBody DataApiRequest request) {
        List instructors = this.instructorRepository.findBySchoolId(request.getSchool_id());
        ArrayList studentViews = new ArrayList();
        for (Instructor i : instructors) {
            List list = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : list) {
                studentViews.addAll(this.classService.findStudentsByClassId(c.getClass_id()));
            }
        }
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        for (MoodDTO moodDTO : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccurance(moodDTO.getMood(), moodDTO.getMood_es(), Double.valueOf(0.0)));
        }
        for (StudentView studentView : studentViews) {
            for (MoodUpdateDTO m : this.moodUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(studentView.getStudent_id().longValue(), request.getFromDate(), request.getToDate())) {
                for (MoodOccurance moodOccurance : list) {
                    if (!this.containsMood(moodOccurance.getMood(), m.getText())) continue;
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals(moodOccurance.getMood())) continue;
                        o.setCount(Double.valueOf(o.getCount() + 1.0));
                    }
                }
            }
        }
        for (MoodOccurance moodOccurance : list) {
            if (studentViews.size() > 0) {
                moodOccurance.count = moodOccurance.count / (double)studentViews.size();
                continue;
            }
            moodOccurance.count = moodOccurance.count;
        }
        return new ResponseEntity(list, (HttpStatusCode)HttpStatus.OK);
    }

    private boolean containsMood(String mood, String text) {
        return text.toLowerCase().trim().equalsIgnoreCase(mood.toLowerCase().trim());
    }

    @GetMapping(value={"/get/assessment-master-details"})
    public ResponseEntity<LinkedHashMap<String, Object>> getAssessmentMasterDetails(@RequestHeader(value="Authorization") String token) {
        List<Object> moods;
        LinkedHashMap<String, List> assessmentMasterDetailsWrapper = new LinkedHashMap<String, List>();
        List allMoods = this.moodRepository.getAllMoodsOrderBySortIndex();
        Student student = this.authService.getStudentByToken(token);
        if (student != null && student.getStandard_id() > 0L) {
            List moodAndStandards = this.moodAndStandardClient.getMoodAndStandardByStandardId(GetByStandardIdRequest.builder().standard_id(student.getStandard_id()).build());
            moods = moodAndStandards.stream().map(moodAndStandard -> allMoods.stream().filter(mood -> mood.getMood_id() == moodAndStandard.getMood_id()).findAny().orElse(null)).collect(Collectors.toList());
        } else {
            moods = new ArrayList(allMoods);
        }
        if (AppUtils.isNotNullOrEmpty(moods)) {
            for (int i = 0; i < moods.size(); ++i) {
                MoodDTO mood = (MoodDTO)moods.get(i);
                ((MoodDTO)moods.get(i)).setImages_elementary(this.configurationRepository.getConfiguration().getImages_elementary_path() + mood.getImages_elementary());
                ((MoodDTO)moods.get(i)).setImages_others(this.configurationRepository.getConfiguration().getImages_others_path() + mood.getImages_others());
                ((MoodDTO)moods.get(i)).setAnimated_image(this.configurationRepository.getConfiguration().getMood_gifs_path() + mood.getAnimated_image());
            }
        }
        assessmentMasterDetailsWrapper.put("moods", moods);
        LinkedHashMap dataSetsWrapper = new LinkedHashMap();
        assessmentMasterDetailsWrapper.put("responsibleDecisionMaking", this.dataSetService.addDataSetsImages(this.dataSetService.getDataSetsByAssessmentCategory(AssessmentCategory.RESPONSIBLE_DECISION_MAKING)));
        assessmentMasterDetailsWrapper.put("selfManagement", this.dataSetService.addDataSetsImages(this.dataSetService.getDataSetsByAssessmentCategory(AssessmentCategory.SELF_MANAGEMENT)));
        assessmentMasterDetailsWrapper.put("socialAwareness", this.dataSetService.addDataSetsImages(this.dataSetService.getDataSetsByAssessmentCategory(AssessmentCategory.SOCIAL_AWARENESS)));
        assessmentMasterDetailsWrapper.put("relationshipSkills", this.dataSetService.addDataSetsImages(this.dataSetService.getDataSetsByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS)));
        return new ResponseEntity(assessmentMasterDetailsWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/insights/post"})
    public ResponseEntity<Object> getMoodInsightsPost(@RequestHeader(value="Authorization") String token, @RequestBody DataApiRequest request) {
        Instructor instructor;
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        String language = Language.getLanguage();
        if (!AppUtils.isNullOrEmpty((String)token) && (instructor = this.authService.getInstructorByToken(token)) != null) {
            language = instructor.getLanguage();
        }
        return new ResponseEntity(this.dataService.getMoodInsightsPost(request, language), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/insights/post/by/instructor"})
    public ResponseEntity<LinkedHashMap<String, Object>> getMoodInsightsPostByInstructor(@RequestHeader(value="Authorization") String token, @RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity((Object)this.dataService.getMoodInsightsPostByInstructor(request, Language.getLanguage()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/insights/post/by/class"})
    public ResponseEntity<Object> getMoodInsightsPostByClass(@RequestHeader(value="Authorization") String token, @RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        return new ResponseEntity(this.dataService.getMoodInsightsPostByClass(request, Language.getLanguage()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/mood/insights/post/by/school"})
    public ResponseEntity<Object> getMoodInsightsPostBySchool(@RequestHeader(value="Authorization") String token, @RequestBody DataApiRequest request) {
        if (request.getEthnicity() != null && request.getEthnicity().contains("Black or African American")) {
            request.getEthnicity().add("Black/African American");
        }
        String language = Language.getLanguage();
        if (!AppUtils.isNullOrEmpty((String)token)) {
            School school = this.authService.getSchoolByToken(token).stream().filter(item -> item.getSchool_id() == request.getSchool_id().longValue()).findFirst().orElse(null);
            if (school != null) {
                language = school.getLanguage();
            } else {
                District district = this.authService.getDistrictByToken(token);
                if (district != null) {
                    language = district.getLanguage();
                }
            }
        }
        return new ResponseEntity(this.dataService.getMoodInsightsPostBySchool(request, language), (HttpStatusCode)HttpStatus.OK);
    }
}

