/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostimage.service;

import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpostimage.dto.WallPostImageDTO;
import com.infinite.focus.server.wallpostimage.entity.WallPostImage;
import com.infinite.focus.server.wallpostimage.repository.WallPostImageRepository;
import com.infinite.focus.server.wallpostimage.service.WallPostImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class WallPostImageServiceImpl
implements WallPostImageService {
    @Autowired
    WallPostImageRepository wallPostImageRepository;
    @Autowired
    MessageService messageService;

    public Page<WallPostImageDTO> getWallPostImages(String title, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = AppUtils.isNullOrEmpty((String)title) ? this.wallPostImageRepository.findAll((Pageable)paging) : this.wallPostImageRepository.findByTitle(title, (Pageable)paging);
        return pagedResult;
    }

    public WallPostImageDTO create(WallPostImage wallPostImage) {
        if (wallPostImage == null || AppUtils.isNullOrEmpty((String)wallPostImage.getUrl())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.image.is.not.found"));
        }
        return this.wallPostImageRepository.create(wallPostImage.getUrl(), wallPostImage.getUrl_es(), wallPostImage.getTitle(), wallPostImage.getTitle_es(), wallPostImage.getDescription(), wallPostImage.getDescription_es());
    }

    public WallPostImageDTO update(WallPostImage wallPostImage) {
        if (wallPostImage == null || AppUtils.isNullOrEmpty((String)wallPostImage.getUrl())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.image.is.not.found"));
        }
        WallPostImageDTO wallPostImageToUpdate = this.wallPostImageRepository.findById(wallPostImage.getWall_post_image_id());
        if (wallPostImageToUpdate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.wall.post.image.is.not.found"));
        }
        return this.wallPostImageRepository.update(wallPostImage.getWall_post_image_id(), wallPostImage.getUrl(), wallPostImage.getUrl_es(), wallPostImage.getTitle(), wallPostImage.getTitle_es(), wallPostImage.getDescription(), wallPostImage.getDescription_es());
    }

    public WallPostImageDTO delete(WallPostImage wallPostImage) {
        WallPostImageDTO wallPostImageToDelete = this.wallPostImageRepository.findById(wallPostImage.getWall_post_image_id());
        if (wallPostImageToDelete == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.wall.post.image.is.not.found"));
        }
        this.wallPostImageRepository.deleteById(wallPostImageToDelete.getWall_post_image_id());
        return wallPostImageToDelete;
    }

    public WallPostImageDTO getById(long id) {
        return this.wallPostImageRepository.findById(id);
    }
}

