/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.utils;

import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.FromDateToDate;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final SimpleDateFormat yearMonthDateHoursMinutesSecondsUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSZ", Locale.getDefault());
    public static final SimpleDateFormat yearMonthDateHoursMinutesSeconds = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat dayWitTimeFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat dailyDateFormat = new SimpleDateFormat("MMM dd, yyyy", Locale.getDefault());
    public static final SimpleDateFormat dailyDateFormat_es = new SimpleDateFormat("MMM dd, yyyy", new Locale("es"));
    public static final SimpleDateFormat weeklyDateFormat = new SimpleDateFormat("MMM dd", Locale.getDefault());
    public static final SimpleDateFormat weeklyDateFormat_es = new SimpleDateFormat("MMM dd", new Locale("es"));
    public static final SimpleDateFormat monthlyDateFormat = new SimpleDateFormat("MMM yyyy", Locale.getDefault());
    public static final SimpleDateFormat monthlyDateFormat_es = new SimpleDateFormat("MMM yyyy", new Locale("es"));
    public static final SimpleDateFormat yearlyDateFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
    public static final SimpleDateFormat yearlyDateFormat_es = new SimpleDateFormat("yyyy", new Locale("es"));
    public static final SimpleDateFormat hoursAndMinutes24hoursDateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
    public static final SimpleDateFormat hoursMinutesSeconds24hoursDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat MMDDYYYY_SLASH = new SimpleDateFormat("MM/dd/yyyy", Locale.getDefault());
    public static final SimpleDateFormat YYYYMMDD_DASH = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    public static final SimpleDateFormat YYYYMMM = new SimpleDateFormat("yyyy MMM", Locale.getDefault());

    public static Date getToDateByTimeLine(TimeLine timeLine) {
        Date toDate = new Date();
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$TimeLine[timeLine.ordinal()]) {
            case 1: {
                toDate = DateUtils.getDailyDate();
                break;
            }
            case 2: {
                toDate = DateUtils.getWeeklyDate();
                break;
            }
            case 3: {
                toDate = DateUtils.getMonthlyDate();
                break;
            }
            case 4: {
                toDate = DateUtils.getYearlyDate();
            }
        }
        return toDate;
    }

    public static Date getDailyDate() {
        Calendar c = Calendar.getInstance();
        c.add(6, -14);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getWeeklyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        int i = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -i - 35);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getMonthlyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, -5);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getYearlyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        c.set(5, 1);
        c.add(1, -4);
        Date startDate = c.getTime();
        return startDate;
    }

    public static List<String[]> getLabelsByTimeLine(TimeLine timeLine, String language) {
        List<Object> labels = new ArrayList<String[]>();
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$TimeLine[timeLine.ordinal()]) {
            case 1: {
                labels = DateUtils.getDailyLabels((String)language);
                break;
            }
            case 2: {
                labels = DateUtils.getWeeklyLabels((String)language);
                break;
            }
            case 3: {
                labels = DateUtils.getMonthlyLabels((String)language);
                break;
            }
            case 4: {
                labels = DateUtils.getYearlyLabels((String)language);
            }
        }
        return labels;
    }

    public static List<String[]> getDailyLabels(String language) {
        ArrayList<String[]> labels = new ArrayList<String[]>();
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < 15; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(6, -i);
            String[] keys = new String[2];
            keys[0] = dailyDateFormat.format(c.getTime());
            if (Language.isSpanish((String)language)) {
                keys[1] = dailyDateFormat_es.format(c.getTime());
            }
            labels.add(keys);
        }
        return labels;
    }

    public static String getDateByLanguage(Date date, TimeZone timeZone, String language) {
        if (Language.isSpanish((String)language)) {
            return dailyDateFormat_es.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy", Locale.getDefault());
        format.setTimeZone(timeZone);
        return format.format(date);
    }

    public static List<FromDateToDate> getDatesForDailyTimeLine(TimeZone timeZone) {
        ArrayList<FromDateToDate> labels = new ArrayList<FromDateToDate>();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        for (int i = 0; i < 15; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(6, -i);
            labels.add(FromDateToDate.builder().fromDate(DateUtils.setTimeToFromDate((Date)c.getTime(), (TimeZone)timeZone)).toDate(DateUtils.setTimeToToDate((Date)c.getTime(), (TimeZone)timeZone)).build());
        }
        return labels;
    }

    public static String getWeekendByDate(Date date, String language) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        Date startDate = c.getTime();
        c.add(5, 6);
        Date endDate = c.getTime();
        String weekend = Language.isSpanish((String)language) ? weeklyDateFormat_es.format(startDate) + " - " + weeklyDateFormat_es.format(endDate) : weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
        return weekend;
    }

    public static final List<String[]> getWeeklyLabels(String language) {
        ArrayList<String[]> labels = new ArrayList<String[]>();
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < 6; ++i) {
            String[] keys;
            Date date = new Date();
            c.setTime(date);
            int x = c.get(7) - c.getFirstDayOfWeek();
            c.add(5, -x - 7 * i);
            Date startDate = c.getTime();
            c.add(5, 6);
            Date endDate = c.getTime();
            if (labels.isEmpty()) {
                keys = new String[2];
                keys[0] = weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
                if (Language.isSpanish((String)language)) {
                    keys[1] = weeklyDateFormat_es.format(startDate) + " - " + weeklyDateFormat_es.format(endDate);
                }
                labels.add(keys);
                continue;
            }
            keys = new String[2];
            keys[0] = weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
            if (Language.isSpanish((String)language)) {
                keys[1] = weeklyDateFormat_es.format(startDate) + " - " + weeklyDateFormat_es.format(endDate);
            }
            labels.add(keys);
        }
        return labels;
    }

    public static List<FromDateToDate> getDatesForWeeklyTimeLine(TimeZone timeZone) {
        ArrayList<FromDateToDate> labels = new ArrayList<FromDateToDate>();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        for (int i = 0; i < 6; ++i) {
            Date date = new Date();
            c.setTime(date);
            int x = c.get(7) - c.getFirstDayOfWeek();
            c.add(5, -x - 7 * i);
            Date startDate = c.getTime();
            c.add(5, 6);
            Date endDate = c.getTime();
            if (labels.isEmpty()) {
                labels.add(FromDateToDate.builder().fromDate(DateUtils.setTimeToFromDate((Date)startDate, (TimeZone)timeZone)).toDate(DateUtils.setTimeToToDate((Date)endDate, (TimeZone)timeZone)).build());
                continue;
            }
            labels.add(FromDateToDate.builder().fromDate(DateUtils.setTimeToFromDate((Date)startDate, (TimeZone)timeZone)).toDate(DateUtils.setTimeToToDate((Date)endDate, (TimeZone)timeZone)).build());
        }
        return labels;
    }

    public static String getWeeklyLabelByFromDateToDateAndLanguage(Date fromDate, Date toDate, TimeZone timeZone, String language) {
        if (Language.isSpanish((String)language)) {
            return weeklyDateFormat_es.format(fromDate) + " - " + weeklyDateFormat_es.format(toDate);
        }
        SimpleDateFormat format = new SimpleDateFormat("MMM dd", Locale.getDefault());
        format.setTimeZone(timeZone);
        return format.format(fromDate) + " - " + format.format(toDate);
    }

    public static List<String[]> getMonthlyLabels(String language) {
        ArrayList<String[]> labels = new ArrayList<String[]>();
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        for (int i = 0; i < 6; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(2, -i);
            String[] keys = new String[2];
            keys[0] = monthlyDateFormat.format(c.getTime());
            if (Language.isSpanish((String)language)) {
                keys[1] = monthlyDateFormat_es.format(c.getTime());
            }
            labels.add(keys);
        }
        return labels;
    }

    public static List<FromDateToDate> getDatesForMonthlyTimeLine(TimeZone timeZone) {
        ArrayList<FromDateToDate> labels = new ArrayList<FromDateToDate>();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.set(5, 1);
        for (int i = 0; i < 6; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(2, -i);
            c.set(5, 1);
            Date fromDate = c.getTime();
            c.set(5, c.getActualMaximum(5));
            Date toDate = c.getTime();
            labels.add(FromDateToDate.builder().fromDate(DateUtils.setTimeToFromDate((Date)fromDate, (TimeZone)timeZone)).toDate(DateUtils.setTimeToToDate((Date)toDate, (TimeZone)timeZone)).build());
        }
        return labels;
    }

    public static String getMonthlyLabelByDateAndLanguage(Date date, TimeZone timeZone, String language) {
        if (Language.isSpanish((String)language)) {
            return monthlyDateFormat_es.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("MMM yyyy", Locale.getDefault());
        format.setTimeZone(timeZone);
        return format.format(date);
    }

    public static List<String[]> getYearlyLabels(String language) {
        ArrayList<String[]> labels = new ArrayList<String[]>();
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        for (int i = 0; i < 5; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(1, -i);
            String[] keys = new String[2];
            keys[0] = yearlyDateFormat.format(c.getTime());
            if (Language.isSpanish((String)language)) {
                keys[1] = yearlyDateFormat_es.format(c.getTime());
            }
            labels.add(keys);
        }
        return labels;
    }

    public static List<FromDateToDate> getDatesForYearlyTimeLine(TimeZone timeZone) {
        ArrayList<FromDateToDate> labels = new ArrayList<FromDateToDate>();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.set(5, 1);
        for (int i = 0; i < 5; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(1, -i);
            c.set(6, 1);
            Date fromDate = c.getTime();
            c.set(2, 11);
            c.set(5, c.getActualMaximum(5));
            Date toDate = c.getTime();
            labels.add(FromDateToDate.builder().fromDate(DateUtils.setTimeToFromDate((Date)fromDate, (TimeZone)timeZone)).toDate(DateUtils.setTimeToToDate((Date)toDate, (TimeZone)timeZone)).build());
        }
        return labels;
    }

    public static String getYearlyLabelByDateAndLanguage(Date date, TimeZone timeZone, String language) {
        if (Language.isSpanish((String)language)) {
            return yearlyDateFormat_es.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy", Locale.getDefault());
        format.setTimeZone(timeZone);
        return format.format(date);
    }

    public static int getDayCountByFromDateAndToDate(Date fromDate, Date toDate, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(timeZone);
        System.out.println("getDayCountByFromDateAndToDate : " + dateFormat.format(fromDate) + " " + dateFormat.format(toDate));
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(fromDate);
        Date endDate = c.getTime();
        String day = dailyDateFormat.format(endDate);
        System.out.println("day :" + day + " " + c.getTimeInMillis());
        Calendar c1 = Calendar.getInstance();
        c1.setTimeZone(timeZone);
        c1.setTime(toDate);
        toDate = c1.getTime();
        System.out.println("day1 :" + day + " " + c1.getTimeInMillis());
        System.out.println("getDayCountByFromDateAndToDate : " + dateFormat.format(fromDate) + " " + dateFormat.format(toDate));
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(5, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static int getWeekCountByFromDateAndToDate(Date fromDate, Date toDate, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        Date startDate = DateUtils.getWeekendLastDate((Date)fromDate, (TimeZone)timeZone);
        c.setTime(startDate);
        Date endDate = DateUtils.getWeekendLastDate((Date)toDate, (TimeZone)timeZone);
        String weekend = weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
        int count = 0;
        while (startDate.getTime() <= endDate.getTime()) {
            c.add(5, 1);
            startDate = DateUtils.getWeekendLastDate((Date)c.getTime(), (TimeZone)timeZone);
            c.setTime(startDate);
            ++count;
        }
        return count;
    }

    public static Date getWeekendFirstDate(Date date, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        return c.getTime();
    }

    public static Date getWeekendLastDate(Date date, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        c.add(5, 6);
        return c.getTime();
    }

    public static int getMonthCountByFromDateAndToDate(Date fromDate, Date toDate, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(toDate);
        c.set(5, 1);
        toDate = c.getTime();
        c.setTime(fromDate);
        c.set(5, 1);
        Date endDate = c.getTime();
        String month = monthlyDateFormat.format(endDate);
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(2, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static int getYearCountByFromDateAndToDate(Date fromDate, Date toDate, TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(toDate);
        c.set(5, 1);
        c.set(2, 11);
        toDate = c.getTime();
        c.setTime(fromDate);
        c.set(5, 1);
        c.set(2, 11);
        Date endDate = c.getTime();
        String month = yearlyDateFormat.format(endDate);
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(1, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static Date between(Date startInclusive, Date endExclusive) {
        long startMillis = startInclusive.getTime();
        long endMillis = endExclusive.getTime();
        long randomMillisSinceEpoch = ThreadLocalRandom.current().nextLong(startMillis, endMillis);
        return new Date(randomMillisSinceEpoch);
    }

    public static Date setTimeToFromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date setTimeToFromDate(Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date setTimeToToDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date setTimeToToDate(Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Period getPeriodByFromAndToDate(Date fromDate, Date toDate) {
        LocalDate pdate = DateUtils.convertToLocalDateViaInstant((Date)DateUtils.setTimeToFromDate((Date)fromDate));
        LocalDate now = DateUtils.convertToLocalDateViaInstant((Date)DateUtils.setTimeToToDate((Date)toDate));
        Period diff = Period.between(pdate, now);
        System.out.printf("\nDifference is %d years, %d months and %d days old\n\n", diff.getYears(), diff.getMonths(), diff.getDays());
        return diff;
    }

    public static LocalDate convertToLocalDateViaInstant(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime convertToLocalDateTimeViaInstant(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static int getAge(Date dateOfBirth) {
        Calendar today = Calendar.getInstance();
        Calendar birthDate = Calendar.getInstance();
        int age = 0;
        birthDate.setTime(dateOfBirth);
        if (birthDate.after(today)) {
            throw new IllegalArgumentException("Can't be born in the future");
        }
        age = today.get(1) - birthDate.get(1);
        if (birthDate.get(6) - today.get(6) > 3 || birthDate.get(2) > today.get(2)) {
            --age;
        } else if (birthDate.get(2) == today.get(2) && birthDate.get(5) > today.get(5)) {
            --age;
        }
        return age;
    }

    public static boolean isAgeInRange(Date dateOfBirth, int minAge, int maxAge) {
        int age = DateUtils.getAge((Date)dateOfBirth);
        if (age < 4 || age > 19) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "The age must be " + minAge + "-" + maxAge + ".");
        }
        return true;
    }

    public static Date getFromDateWithoutTime(Date fromDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getToDateWithoutTime(Date toDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(toDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static String getFromDateInString(Date from_date) {
        if (from_date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(from_date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date fromDate = cal.getTime();
        return yearMonthDateHoursMinutesSeconds.format(fromDate);
    }

    public static String getToDateInString(Date to_date) {
        if (to_date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(to_date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date toDate = cal.getTime();
        return yearMonthDateHoursMinutesSeconds.format(toDate);
    }

    public static SimpleDateFormat getSimpleDateFormatWithPatternAndZonedDateTime(String pattern, ZonedDateTime zonedDateTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
        TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    public static String getDateInString(Date from_date) {
        if (from_date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(from_date);
        Date fromDate = cal.getTime();
        return yearMonthDateHoursMinutesSeconds.format(fromDate);
    }

    public static String getDateInString(Date from_date, TimeZone timeZone) {
        if (from_date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(from_date);
        Date fromDate = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        format.setTimeZone(timeZone);
        return format.format(fromDate);
    }

    public static long getDaysCountBetweenFromDateAndToDate(Date fromDate, Date toDate) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeViaInstant((Date)fromDate);
        LocalDateTime enddate = DateUtils.convertToLocalDateTimeViaInstant((Date)toDate);
        if (startDate == null || enddate == null) {
            throw new IllegalArgumentException("No such a date");
        }
        return ChronoUnit.DAYS.between(startDate, enddate);
    }

    public static long getWeeksCountBetweenFromDateAndToDate(Date fromDate, Date toDate) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeViaInstant((Date)fromDate);
        LocalDateTime enddate = DateUtils.convertToLocalDateTimeViaInstant((Date)toDate);
        if (startDate == null || enddate == null) {
            throw new IllegalArgumentException("No such a date");
        }
        return ChronoUnit.WEEKS.between(startDate, enddate);
    }

    public static long getMonthsCountBetweenFromDateAndToDate(Date fromDate, Date toDate) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeViaInstant((Date)fromDate);
        LocalDateTime enddate = DateUtils.convertToLocalDateTimeViaInstant((Date)toDate);
        if (startDate == null || enddate == null) {
            throw new IllegalArgumentException("No such a date");
        }
        return ChronoUnit.MONTHS.between(startDate, enddate);
    }

    public static long countDaysBetweenFromDateAndToDate(Date fromDate, Date toDate) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeViaInstant((Date)DateUtils.setTimeToFromDate((Date)fromDate));
        LocalDateTime enddate = DateUtils.convertToLocalDateTimeViaInstant((Date)DateUtils.setTimeToToDate((Date)toDate));
        if (startDate == null || enddate == null) {
            throw new IllegalArgumentException("No such a date");
        }
        long daysBetween = ChronoUnit.DAYS.between(startDate, enddate);
        return daysBetween;
    }

    public static long countHoursBetweenFromDateAndToDate(Date fromDate, Date toDate) {
        LocalDateTime startDate = DateUtils.convertToLocalDateTimeViaInstant((Date)fromDate);
        LocalDateTime enddate = DateUtils.convertToLocalDateTimeViaInstant((Date)toDate);
        if (startDate == null || enddate == null) {
            throw new IllegalArgumentException("No such a date");
        }
        long daysBetween = ChronoUnit.HOURS.between(startDate, enddate);
        return daysBetween;
    }

    public static boolean checkDateTimeIsPassed(Date date) {
        Date current = new Date();
        return date.before(current);
    }

    public static Date getNextYearDateFromToday() {
        Calendar now = Calendar.getInstance();
        System.out.println("Current date : " + (now.get(2) + 1) + "-" + now.get(5) + "-" + now.get(1));
        now.add(1, 1);
        return now.getTime();
    }

    public static Date getNextYearDateFromDate(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        System.out.println("Current date : " + (now.get(2) + 1) + "-" + now.get(5) + "-" + now.get(1));
        now.add(1, 1);
        return now.getTime();
    }

    public static Date subtractDaysInDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -days);
        return cal.getTime();
    }

    public static String getDateInStringByFormat(Date date, SimpleDateFormat format) {
        if (date == null) {
            throw new IllegalArgumentException("The date should not be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("The format should not be null.");
        }
        return format.format(date);
    }

    public static boolean isDateInBetweenFromDateAndToDate(Date fromDate, Date toDate, Date date) {
        return !date.before(fromDate) && !date.after(toDate);
    }

    public static String getTimeInString(long time) {
        String timeString = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(time), TimeUnit.MILLISECONDS.toMinutes(time) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(time) % TimeUnit.MINUTES.toSeconds(1L));
        return timeString;
    }

    public static String getSystemTimeOffset(ZonedDateTime zonedDateTime) {
        DateTimeFormatter offsetFormatter = DateTimeFormatter.ofPattern("xxx");
        ZoneOffset offset = zonedDateTime.getOffset();
        return offsetFormatter.format(offset);
    }

    public static String getMinutesAndSecondInString(long milliseconds) {
        long minutes = milliseconds / 1000L / 60L;
        long seconds = milliseconds / 1000L % 60L;
        String minutesStr = Long.toString(minutes);
        Object mins = minutesStr.length() < 2 ? "0" + minutesStr : minutesStr;
        String secondsStr = Long.toString(seconds);
        Object secs = secondsStr.length() >= 2 ? secondsStr.substring(0, 2) : "0" + secondsStr;
        return (String)mins + ":" + (String)secs;
    }

    public static long countBusinessDaysBetween(Date start_date, Date end_date) throws ParseException {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(start_date);
        cal2.setTime(end_date);
        int numberOfDays = 0;
        while (cal1.before(cal2)) {
            if (7 != cal1.get(7) && 1 != cal1.get(7)) {
                ++numberOfDays;
                cal1.add(5, 1);
                continue;
            }
            cal1.add(5, 1);
        }
        System.out.println(numberOfDays);
        return numberOfDays;
    }

    public static String getCurrentYear() {
        int year = Calendar.getInstance().get(1);
        return String.valueOf(year);
    }

    public static Date getStartDateTimeOfTheMonth(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEndDateTimeOfTheMonth(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date addTimeInCurrentDateFromTimestamp(Timestamp timestamp, String time_zone) {
        ZoneOffset zoneOffSet = ZoneOffset.of(time_zone);
        ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneOffSet);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
        calendar.set(11, timestamp.toLocalDateTime().getHour());
        calendar.set(12, timestamp.toLocalDateTime().getMinute());
        calendar.set(13, timestamp.toLocalDateTime().getMinute());
        calendar.set(14, timestamp.toLocalDateTime().getNano());
        Instant instant = calendar.toInstant();
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        ZonedDateTime currentDate = ZonedDateTime.ofInstant(instant, zoneId);
        return Date.from(currentDate.toInstant());
    }
}

