/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.ParentAuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.utils.AppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParentAuthServiceImpl
implements ParentAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    CorporateService corporateService;
    @Autowired
    ParentService parentService;

    public Parent createParentTrialAccount(long corporate_id, FreeTrialAccountRequest request) {
        if (AppUtils.isNullOrEmpty((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getEmail());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        Corporate corporate = this.corporateService.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getEmail());
        a = (Account)this.accountRepository.save((Object)account);
        Parent parent = new Parent();
        parent.setFirst_name(request.getFirst_name());
        parent.setLast_name(request.getLast_name());
        parent.setAccount(a);
        parent.setCorporate_id(corporate_id);
        parent.setCity(request.getCity());
        parent.setState(request.getState());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Parent x = this.parentService.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                parent.setRegistration_code("P" + possible_code);
                continue;
            }
            isUnique = false;
        }
        parent.setLanguage(Language.getLanguage());
        return this.parentService.save(parent);
    }
}

