/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.content.service;

import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.content.repository.ContentRepository;
import com.infinite.focus.server.content.service.ContentService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ContentServiceImpl
implements ContentService {
    @Autowired
    private ContentRepository contentRepository;

    public ContentDTO getContentById(long content_id) {
        return this.contentRepository.findById(content_id);
    }

    public Page<ContentDTO> getContents(String content_name, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        return this.contentRepository.findPageByContentName(content_name, (Pageable)paging);
    }

    public void deleteById(long content_id) {
        this.contentRepository.deleteById(content_id);
    }

    public ContentDTO create(String content_name, String content_name_es, int status) {
        return this.contentRepository.create(content_name, content_name_es, status);
    }

    public ContentDTO update(long content_id, String content_name, String content_name_es, int status) {
        return this.contentRepository.update(content_id, content_name, content_name_es, status);
    }

    public ContentDTO getById(long id) {
        return this.contentRepository.findById(id);
    }

    public List<ContentDTO> getAll() {
        return this.contentRepository.findAll();
    }

    public List<ContentDTO> getContentsByIds(Set<Long> ids) {
        return this.contentRepository.findByIds(ids);
    }
}

