/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.SchoolAuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.utils.AppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SchoolAuthServiceImpl
implements SchoolAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    ConfigurationService configurationService;

    public School createSchoolTrialAccount(long district_id, FreeTrialAccountRequest organization, FocusOn focus_on) {
        if (AppUtils.isNullOrEmpty((String)organization.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)organization.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(organization.getEmail());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.s.email.is.already.exist"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)organization.getPassword()));
        account.setUsername(organization.getEmail());
        account.setRole_in_organization(organization.getRole_in_organization());
        a = (Account)this.accountRepository.save((Object)account);
        School s = new School();
        s.setAddress(organization.getAddress());
        s.setSchool_name(organization.getName());
        s.setAuto_approve_wall_posts(true);
        s.setEnable_wow(true);
        s.setEnable_journal(true);
        s.setDistrict_id(district_id);
        s.setAccount_id(a.getAccount_id());
        s.setNumber_of_youth(district_id < 1L ? (long)this.configurationService.getConfiguration().getFree_trial_number_of_youth() : 0L);
        s.setActive(district_id < 1L);
        if (focus_on != null) {
            s.setFocus_on(focus_on);
        }
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            School x = this.schoolRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                s.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        s.setLanguage(Language.getLanguage());
        this.schoolRepository.save((Object)s);
        return s;
    }
}

