/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor.repository;

import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.view.InstructorView;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface InstructorRepository
extends JpaRepository<Instructor, Long> {
    @Query(value="SELECT ac.created_at FROM instructor instr JOIN account ac ON instr.account_id = ac.account_id WHERE ac.username IS NOT NULL AND ac.username != '' ORDER BY instr.instructor_id ASC LIMIT 0,1", nativeQuery=true)
    public Date getFirstInstructorCreatedDate();

    @Query(value="SELECT instr.instructor_id FROM instructor instr JOIN account acc ON instr.account_id = acc.account_id WHERE acc.account_id IS NOT NULL AND acc.account_id > 0 ORDER BY instr.instructor_id", nativeQuery=true)
    public List<InstructorView> findAllInstructorIdOrderById();

    @Query(value="SELECT * FROM instructor ORDER BY instructor_id ASC", nativeQuery=true)
    public List<Instructor> findAllOrderByInstructorIdASC();

    @Query(value="SELECT * FROM instructor WHERE account_id = ?1 ", nativeQuery=true)
    public Instructor findByAccountId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE instructor_id = ?1 ", nativeQuery=true)
    public Instructor findByInstructorId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE instructor_id = ?1 ", nativeQuery=true)
    public InstructorView findInstructorViewByInstructorId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE school_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<Instructor> findBySchoolId(Long var1);

    @Query(value="SELECT DISTINCT(instructor_id) FROM instructor WHERE school_id = ?1 ORDER BY instructor_id ASC", nativeQuery=true)
    public List<Long> findInstructorIdsBySchoolIdOrderByInstructorIdASC(Long var1);

    @Query(value="SELECT * FROM instructor WHERE school_id = ?1 ORDER BY first_name ASC", nativeQuery=true)
    public List<Instructor> findBySchoolIdOrderByFirstNameASC(Long var1);

    @Query(value="SELECT * FROM instructor WHERE registration_code = ?1", nativeQuery=true)
    public Instructor findByRegistrationCode(String var1);

    @Query(value="SELECT a.username FROM instructor i LEFT JOIN account a ON a.account_id = i.account_id", nativeQuery=true)
    public List<String> getAllInstructorsEmailAddresses();

    @Query(value="SELECT COALESCE(inst.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor instr JOIN account acco ON instr.account_id = acco.account_id WHERE COALESCE (instr.operating_system, '') <> '')),2) as percentage FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE COALESCE (inst.operating_system, '') <> '' group by inst.operating_system", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfOS();

    @Query(value="SELECT COALESCE(inst.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor instr JOIN account acco ON instr.account_id = acco.account_id WHERE COALESCE (instr.operating_system, '') <> '' AND acco.created_at BETWEEN ?1 AND ?2)),2) as percentage FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE COALESCE (inst.operating_system, '') <> '' AND acc.created_at BETWEEN ?1 AND ?2 group by inst.operating_system", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfOSCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT COALESCE(inst.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor instr JOIN account acco ON instr.account_id = acco.account_id WHERE COALESCE (instr.browser, '') <> '')),2) as percentage FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE COALESCE (inst.browser, '') <> '' group by inst.browser", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfBrowser();

    @Query(value="SELECT COALESCE(inst.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor instr JOIN account acco ON instr.account_id = acco.account_id WHERE COALESCE (instr.browser, '') <> '' AND acco.created_at BETWEEN ?1 AND ?2)),2) as percentage FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE COALESCE (inst.browser, '') <> '' AND acc.created_at BETWEEN ?1 AND ?2 group by inst.browser", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfBrowserCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT COUNT(*) FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE acc.created_at BETWEEN ?1 AND ?2", nativeQuery=true)
    public Long getCountByCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT COUNT(*) FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id", nativeQuery=true)
    public Long getCount();

    @Query(value="SELECT instr.instructor_id FROM instructor instr WHERE instr.school_id = ?1", nativeQuery=true)
    public List<BigInteger> findInstructorIdsBySchoolId(long var1);

    @Query(value="SELECT DISTINCT instr.instructor_id FROM instructor instr WHERE CONCAT(instr.first_name,  ' ', instr.last_name) LIKE %?1% AND instr.school_id = ?2", nativeQuery=true)
    public List<Long> findInstructorIdsWhereInstructorNameLikeAndBySchoolId(String var1, long var2);

    @Query(value="SELECT * FROM instructor WHERE clever_id = ?1 ", nativeQuery=true)
    public Instructor findByCleverId(String var1);

    @Query(value="SELECT * FROM instructor WHERE clever_id IN(?1) ", nativeQuery=true)
    public List<Instructor> findByCleverIds(List<String> var1);

    @Query(value="SELECT inst.* FROM instructor inst JOIN account acc ON inst.account_id = acc.account_id WHERE acc.username IS NOT NULL AND acc.username != ''", nativeQuery=true)
    public List<Instructor> getAllInstructors();
}

